package com.yizhi.site.application.controller.api;

import java.util.List;

import com.yizhi.site.application.service.HomeLogoService;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.vo.domain.PortalTemplateVo;
import com.yizhi.site.application.vo.site.AnnouncementVO;
import com.yizhi.site.application.vo.site.ApiPortalPCLink;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yizhi.site.application.domain.HomeLogo;
import com.yizhi.site.application.domain.PortalImage;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.domain.TrPortalLookNum;
import com.yizhi.site.application.service.IRelationLiveService;
import com.yizhi.site.application.service.ITrInformationReadNumberService;
import com.yizhi.site.application.service.ITrPortalLookNumService;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.service.PortalImageService;
import com.yizhi.site.application.service.PortalNavigateService;
import com.yizhi.site.application.service.PortalTemplateService;
import com.yizhi.site.application.service.ProtalPlateService;

@RestController
@RequestMapping("/api/portal/pc")
public class PortalApiPCController {
	
	
	
	@Autowired
	private HomeLogoService homeLogoService;
	
	@Autowired
	private PortalNavigateService portalNavigateService;
	
	@Autowired
	private IRelationLiveService relationLiveService;
	
	@Autowired
	private InformationService informationService;
	
	@Autowired
	private PortalTemplateService portalTemplateService;
	
	@Autowired
	private ProtalPlateService protalPlateService;
	
	@Autowired
	private ITrInformationReadNumberService trInformationReadNumberService;
	
	@Autowired
	private ITrPortalLookNumService trPortalLookNumService;
	
	
	
	@Autowired
	private PortalImageService portalImageService;
	
	@GetMapping(value = "/base/message")
    HomeLogo baseMeaagePC(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType) {
		return homeLogoService.baseMeaagePCByTerminalId(siteId, terminalType);
	}
	
	
	@GetMapping(value = "/link/up")
	List<ApiPortalPCLink> listApiPortalPCLinkUp(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType){
		return portalNavigateService.listApiPortalPCLinkUp(siteId, terminalType);
	}
	
	
	@GetMapping("/banner/image")
	List<PortalImage> listApiPortalPCPortalImage(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType){
		return portalImageService.listApiPortalPCPortalImage(siteId, terminalType);
	}
	
	@GetMapping("/look/num")
    TrPortalLookNum listApiPortalPCPortalLookNum(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType) {
		return trPortalLookNumService.listApiPortalPCPortalLookNum(siteId, terminalType);
	}
	
	
	@GetMapping(value="/live")
	Long getLiveActivityPc(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType) {
		return relationLiveService.getRelationLive(siteId, terminalType);
	}

	
	@GetMapping(value="/link/down")
	List<ApiPortalPCLink> listApiPortalPCLinkDown(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType){
		return portalNavigateService.listApiPortalPCLinkDown(siteId, terminalType);
	}
	
	@GetMapping(value="/announcement/select")
	List<AnnouncementVO> getApiRelationAnnouncement(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType){
		return informationService.getApiRelationAnnouncement(siteId, terminalType);
	}
	
	
	@GetMapping(value="/module/list/select")
	List<PortalTemplate> moduleListSelectApi(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType){
		return portalTemplateService.moduleListSelectApi(siteId, terminalType);
	}
	
	
	

	@GetMapping("/template/content/view")
	List<ProtalPlate> templateContentViewApi(@RequestParam(name = "id", required = true) Long id){
		return protalPlateService.templateContentViewApi(id);
	}
	
	
	@GetMapping("/news/supply/notIds")
	List<Information> listSupplyInformation(@RequestParam("siteId")Long siteId, @RequestParam(name="ids",required=false)List<Long> ids){
		return informationService.listSupplyInformation(siteId, ids);
	}
	
	
	@GetMapping("/news/read/count")
	Integer newsReadCount(@RequestParam("id")Long id) {
		
		return trInformationReadNumberService.getInformationReadCountPc(id);
	}

	/**
	 * 获取模块的详情
	 * @param  id 模块id
	 * @return
	 */
	@GetMapping("/get/template")
	public PortalTemplateVo getPortalTemplate(@RequestParam(name = "id") Long id){
		PortalTemplate p=portalTemplateService.selectById(id);
		PortalTemplateVo pt=new PortalTemplateVo();
		BeanUtils.copyProperties(p,pt);
		return pt;
	}
	
}
