package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-04-02
 */
@ApiModel(value = "HomeAnnouncementEntityVo", description = "首页公告")
@Data
@TableName("tr_home_announcement")
public class HomeAnnouncement extends Model<HomeAnnouncement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "首页公告ID")
    private Long id;
    
    @ApiModelProperty(value = "首页ID")
    @TableField("home_id")
    private Long homeId;
    
    @ApiModelProperty(value = "公告ID")
    @TableField("information_id")
    private Long informationId;
    
    @ApiModelProperty(value = "排序")
    private Integer sort;
    
    @ApiModelProperty(value = "公告是否显示 公告0不显示  1 显示")
    private Integer display;
    
    @ApiModelProperty(value = "状态 0 删除  1未删除")
    private Integer state;
    
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;
    
    @ApiModelProperty(value = "创建姓名")
    @TableField("create_by_name")
    private String createByName;
    
    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;
    
    @ApiModelProperty(value = "更新人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value = "更新姓名")
    @TableField("update_by_name")
    private String updateByName;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
