package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Data
@Api(tags = "PageFooterItemConfigEntityVo", description = "链接")
@TableName("page_footer_item_config")
public class PageFooterItemConfig extends Model<PageFooterItemConfig> {

    private static final long serialVersionUID = 1L;

    private Long id;

    @TableField("page_footer_item_id")
    private Long pageFooterItemId;

    @ApiModelProperty(value = "文字链接标签")
    @TableField("charater_tag")
    private String charaterTag;

    @ApiModelProperty(value = "图片地址")
    @TableField("img_oss_url")
    private String imgOssUrl;

    @ApiModelProperty(value = "链接路径: 文字链接 / 图片链接")
    private String link;

    @ApiModelProperty(value = " 0  未删除  1 表示删除  (默认 0)")
    private Integer delete;

    @ApiModelProperty(value = " 排序")
    private Integer sort;

    @ApiModelProperty(value = "企业_ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "部门_ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
