package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalTerminalEntityVo", description = "终端")
@Data
@TableName("tr_portal_terminal")
public class PortalTerminal extends Model<PortalTerminal> {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "主键")
    private Long id;
    
    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;
    
    @ApiModelProperty(value = "应用名称")
    @TableField("terminal_name")
    private String terminalName;
    
    @ApiModelProperty(value = "终端类型:1-PC 2-APP 3-微信")
    @TableField("type")
    private Integer type;
    
    @ApiModelProperty(value = "0未发布 1已生效（已发布）")
    private Integer state;
    
    @ApiModelProperty(value = "0不显示 1显示")
    private Integer display;
    
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;
    
    @ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;
    
    @ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;
    
    @ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;
    
    @ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;
    
    @ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
