package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.yizhi.site.application.vo.domain.InformationClassify;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * com.yizhi.site.application.domain
 *
 * @author yanglang
 * @create 2024-01-09 13:48:46
 */
@ApiModel(value = "SystemMailbox", description = "信箱")
@Data
@TableName("system_mailbox")
public class SystemMailbox {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主鍵")
    private Long id;

    @ApiModelProperty(value = "信箱标题")
    @TableField("file_name")
    private String fileName;

    @ApiModelProperty(value = "信箱类型  1： 纪检   2: 书记")
    @TableField("type")
    private Integer type;

    @ApiModelProperty(value = "联系人名称")
    @TableField("contact_name")
    private String contactName;

    @ApiModelProperty(value = "联系人手机号/邮箱")
    @TableField("contact_number")
    private String contactNumber;

    @ApiModelProperty(value = "提交时间")
    @TableField("submit_time")
    private Date submitTime;

    @ApiModelProperty(value = "内容")
    @TableField("content")
    private String content;

    @ApiModelProperty(value = "备注")
    @TableField("remark")
    private String  remark;

    @ApiModelProperty(value = "审核时间")
    @TableField("approve_time")
    private Date approveTime;

    @ApiModelProperty(value = "审批人")
    @TableField("approve_by_id")
    private Long approveById;

    @ApiModelProperty(value = "状态 0 删除 1 草稿 2 待审核 3 待发布 4 已发布 5 不通过")
    @TableField("state")
    private Integer state;

    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

    @ApiModelProperty(value = "图片链接地址")
    @TableField("oss_pic_url")
    private String ossPicUrl;

    @ApiModelProperty(value = "来信目的")
    @TableField("target_from")
    private String targetFrom;

    @ApiModelProperty(value = "是否匿名：0否1是")
    @TableField("anonymous_flag")
    private Integer anonymousFlag;

    @ApiModelProperty(value = "视频链接地址")
    @TableField("oss_video_url")
    private String ossVideoUrl;

    @ApiModelProperty(value = "1:已删除，0未删除")
    @TableLogic
    private Integer deleted;

    protected Serializable pkVal() {
        return this.id;
    }
}
