package com.yizhi.site.application.mapper;

import java.util.List;

import com.yizhi.site.application.domain.PortalNavigate;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.site.NavigateListVO;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalNavigateMapper extends BaseMapper<PortalNavigate> {

	List<NavigateListVO> listNavigate(Page<NavigateListVO> page, Long homeId);

	@Select("select max(sort) from tr_portal_navigate where home_id=#{homeId} and site_id=#{siteId}")
	Integer selectMaxSort(@Param("homeId") Long homeId, @Param("siteId") Long siteId);
	

	
	/**
	 * ----------------------分割线------------------------------
	 */
	
	@Select("select max(sort) from tr_portal_navigate where home_id=#{homeId}  and pc_type=#{pcType}")
	Integer selectMaxSortPc(@Param("homeId") Long homeId, @Param("pcType")Integer pcType);

	
	
	Long getNextPortalNavigate(@Param("homeId") Long homeId, @Param("curSort")Integer curSort,@Param("isDown")Integer isDown);
	
	
	Boolean setImageNullById(@Param("id")Long id);
	
	Boolean setCodeAndNameNullById(@Param("id")Long id);
	
    Boolean setUrlNullById(@Param("id")Long id);
    
    
    
    List<PortalNavigate> selectListInit();
	
}
