package com.yizhi.site.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.domain.Publication;
import com.yizhi.site.application.vo.site.AnnouncementVO;
import com.yizhi.site.application.vo.site.InfomationParamVO;
import com.yizhi.site.application.vo.site.PublicationParamVO;
import com.yizhi.site.application.vo.site.PublicationStudentVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author yanglang
 * @since 2024-12-17
 */
public interface PublicationMapper extends BaseMapper<Publication> {

    List<Publication> publicationTwoList(InfomationParamVO vo, Page<Publication> page);

    List<AnnouncementVO> selectAnnouncement(Page<AnnouncementVO> page, Map<String, Object> map);

    List<PublicationStudentVO> publicationPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<PublicationStudentVO> page);

    /**
     * 版本2  修改 ：去掉置顶排序
     */
    List<PublicationStudentVO> publicationPageListV2(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<PublicationStudentVO> page);

    List<PublicationStudentVO> publicationPageOtherList(@Param("typeOne") Long typeOne, @Param("typeTwo") Long typeTwo, @Param("siteId") Long siteId, Page<PublicationStudentVO> page);

    List<PublicationStudentVO> selectpublicationVO(@Param("typeOne") Long typeOne, @Param("siteId") Long siteId,
                                                   @Param("state") Integer state, Page<PublicationStudentVO> page);

    List<Publication> searchpublication(Page<Publication> page, Publication info);

    List<Publication> searchpublication(Publication info);

    /**
     * 查询新闻数量
     *
     * @param id
     * @return
     */

    Integer querypublicationByTypeTwo(@Param("id") Long id);

    String getNumberByCode(@Param("code") String code);


    /**
     * ---------------------分割线---------------
     */
    List<Publication> getRelationAnnouncementPC(@Param("terminalId") Long terminalId);


    List<PublicationStudentVO> publicationPcPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<PublicationStudentVO> page);


    List<PublicationStudentVO> publicationClassifyPcPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeTwo") Long typeTwo, @Param("level") Integer level, Page<PublicationStudentVO> page);


    Long publicationRelationGetpublicationIds(@Param("terminalId") Long terminalId);

    List<Long> getRelationpublicationIds(@Param("templateId") Long templateId);


    String getType(@Param("id") Long id, @Param("siteId") Long siteId);

    /**
     * 获取相关的新闻id
     *
     * @param terminalId
     * @return
     */
    List<Long> selectRelationIds(@Param("terminalId") Long terminalId);

    /**
     * 获取置顶的公告
     */
    List<PublicationStudentVO> publicationTopList(@Param("typeName") String typeName, @Param("siteId") Long siteId,@Param("typeOne") Long typeOne);
    
    /**
     * 获取首页置顶新闻
     */
    List<PublicationStudentVO> publicationIndexTopList(@Param("siteId") Long siteId);

    List<Publication> publicationFirstList(PublicationParamVO publicationParamVO, Page<Publication> page);
}