package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.site.application.vo.site.PlateVO;
import com.yizhi.site.application.vo.site.PortalPlateVO;
import com.yizhi.site.application.vo.site.TemplateInsertPcVO;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface ProtalPlateService extends IService<ProtalPlate> {
	
	
	Boolean templateContentAdd(TemplateInsertPcVO templateInsertPcVO);
	
	
	List<ProtalPlate> templateContentView(Long id);
	
	List<Long> templateContentViewByTerminalIdAndModuleType( Long terminalId, Integer moduleType);
	
	Boolean templateContentUpdate(Long id,Long activityId,Integer state,String imgUrl);
	
	List<ProtalPlate> templateContentViewApi(Long id);

    /**
     * 获取列表
     * @param templateId
     * @return
     */
	List<PortalPlateVO> getPlateVOList(Long templateId);

    /**
     * 根据id或模块内列表
     * @param id
     * @return
     */
	List<ProtalPlate> getPlateListById(Long id);

    /**
     * 排序
     * @param id
     * @param code
     * @return
     */
	boolean sortPlate(Long id,String code);

    /**
     * 通过templateId 获取列表
     * @param templateId
     * @return
     */
	List<ProtalPlate> getIdsByTemplateId(Long templateId);

    /**
     * 修改模块
     * @param plateVO
     * @return
     */
    boolean updatePlate(PlateVO plateVO);

    /**
     * 获取模块
     * @param protalPlate
     * @return
     */
    ProtalPlate getPlate(ProtalPlate protalPlate);
    /**
     * 查询首页配置的模块的列表
     * @param terminalName 终端名称 PC 和移动端
     * @param siteId 站点id
     * @param moduleType 首页模块的类型
     * @return
     * */
    List<Long> selectHomeConfigList(String terminalName,Long siteId,int moduleType);
    
    
    ProtalPlate getUrl(Long selectActivityId);

    /**
     * 获取关联的列表
     * @param ids
     * @return
     */
    List<ProtalPlate> getPlateListById(List<Long> ids);

    /**
     * 修改模块并回调
     * @param plateVO
     * @return
     */
    ProtalPlateVo updateBackPlate(PlateVO plateVO);
}
