package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
//import com.yizhi.application.job.remote.vo.VmyJobVO;
import com.google.common.collect.Lists;
import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.domain.ProtalPlate;
//import com.yizhi.application.job.remote.JobClient;
import com.yizhi.site.application.mapper.HomeAnnouncementMapper;
import com.yizhi.site.application.mapper.InformationClassifyMapper;
import com.yizhi.site.application.mapper.InformationMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.comment.application.feign.PdfPagesClient;
import com.yizhi.comment.application.vo.PdfVO;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.site.application.service.*;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.domain.InformationClassify;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.util.application.constant.TpActivityType;
import com.yizhi.util.application.date.DateUtil;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Log4j2
@Service
public class InformationServiceImpl extends ServiceImpl<InformationMapper, Information> implements InformationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformationServiceImpl.class);
    private static final String jobGroup = "information";
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private InformationMapper informationMapper;
    @Autowired
    private EventTrackService eventTrackService;
    @Autowired
    private PortalBannerService portalBannerService;
    @Autowired
    private DataClassificationService dataClassificationService;
    @Autowired
    private ProtalPlateService protalPlateService;

    @Autowired
    private PortalTerminalMapper portalTerminalMapper;

    @Autowired
    private HomeAnnouncementMapper homeAnnouncementMapper;

    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    @Autowired
    private PdfPagesClient pdfPagesClient;
    @Autowired
    private ITrInformationReadNumberService informationReadNumberService;

    @Autowired
    private InformationClassifyMapper informationClassifyMapper;

//    @Autowired
//    JobClient jobClient;

//	@Override
//	public InformationListVO informationPageList(InfoVO vo) {
//		InformationListVO infoVO = new InformationListVO();
//		Integer pageNo = vo.getPageNo();
//		Integer pageSize = vo.getPageSize();
//		String typeName = vo.getTypeName();
//		Long siteId = vo.getContext().getSiteId();
//		Page<InformationStudentVO> page = new Page<InformationStudentVO>(pageNo, pageSize);
//		List<InformationStudentVO> info = null;
//		if(typeName.equals(SiteConstant.ANNOUNCEMENT)){  //公告
//			info = informationMapper.informationPageList(typeName, siteId, page);
//		}else{
//			info = informationMapper.informationPageOtherList(typeName, siteId, page);
//		}
//		page.setRecords(info);
//		infoVO.setInfo(page);
//
//		//轮播图
//		AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
//		avo.setBannerName(vo.getB`nnerName());
//		avo.setTerminalName(vo.getTerminalName());
//		avo.setSiteId(siteId);
//		avo.setCompanyId(vo.getContext().getCompanyId());
//		avo.setOrgId(vo.getContext().getOrgId());
//		List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);
//		infoVO.setPortalImageList(portalImageList);
//		return infoVO;
//	}

    @Override
    public InformationListVO informationPageList(InfoVO vo) {


        InformationListVO infoVO = new InformationListVO();

        //如果是新闻二级分类列表
        if (vo.getTypeTwo() != null) {
            vo.setTypeName("news");
            InformationListPcVo informationListPcVo = this.informationPcPageList(vo);
            if (null != informationListPcVo && CollectionUtils.isNotEmpty(informationListPcVo.getNews())) {
                List<InfoViewListVO> infoViewListVOS = new ArrayList<>();
                InfoViewListVO infoViewListVO = new InfoViewListVO();
                Page<InformationStudentVO> page = new Page<>(vo.getPageNo(), vo.getPageSize());
                page.setRecords(informationListPcVo.getNews());
                page.setTotal(informationListPcVo.getPageTotal());
                infoViewListVO.setInfo(page);
                infoViewListVOS.add(infoViewListVO);

                infoVO.setInfoListVO(infoViewListVOS);
                return infoVO;
            } else {
                return null;
            }
        }

        Integer pageNo = vo.getPageNo();
        Integer pageSize = vo.getPageSize();
        Long siteId = vo.getContext().getSiteId();

        List<InfoViewListVO> list = new ArrayList<InfoViewListVO>();

        InfoViewListVO view = new InfoViewListVO();
        //公告
        Page<InformationStudentVO> ggPage = new Page<InformationStudentVO>(pageNo, pageSize);
        // 新增代码 by lilingye
        RequestContext contextHolder = ContextHolder.get();
        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
        siteComponyIdVO.setCompanyId(ContextHolder.get().getCompanyId());
        siteComponyIdVO.setSiteId(ContextHolder.get().getSiteId());
        siteComponyIdVO.setCreateById(ContextHolder.get().getAccountId());
        siteComponyIdVO.setCreateByName(ContextHolder.get().getAccountName());
        siteComponyIdVO.setOrgId(ContextHolder.get().getOrgId());
        siteComponyIdVO.setSiteId(ContextHolder.get().getSiteId());

        List<ClassificationVO> classificationVOList = dataClassificationService.getClassification(siteComponyIdVO);
        Long typeOne = null;
        for (ClassificationVO classificationVO :
                classificationVOList) {
            if (SiteConstant.ANNOUNCEMENT.equals(classificationVO.getName())) {
                typeOne = classificationVO.getId();

                log.info("typeOne值为:" + typeOne);
                break;
            }

        }

        List<InformationStudentVO> gglist = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, typeOne, ggPage);
        // modify by lingye
        if (gglist != null && gglist.size() > 0) {
            view.setTypeName(SiteConstant.ANNOUNCEMENT);
            ggPage.setRecords(gglist);
            view.setInfo(ggPage);
            list.add(view);
        }


        //公告     SiteConstant.ANNOUNCEMENT     新闻   SiteConstant.PORTALNEWS
        Map<String, Object> map1 = new HashMap<String, Object>();
        map1.put("name", "新闻");
        map1.put("site_id", siteId);
        map1.put("parent_id", 0);
        map1.put("state", 1);
        List<DataClassification> selectByMap = dataClassificationService.selectByMap(map1);
        if (selectByMap != null && selectByMap.size() > 0) {
            DataClassification d = selectByMap.get(0);
            if (d != null) {
                Map<String, Object> map2 = new HashMap<String, Object>();
                map2.put("parent_id", d.getId());
                map2.put("site_id", siteId);
                map2.put("state", 1);
                List<DataClassification> selectByMap2 = dataClassificationService.selectByMap(map2);
                if (selectByMap2.size() > 0 && selectByMap2 != null) {
                    InfoViewListVO view1 = null;
                    Page<InformationStudentVO> page = null;
                    List<InformationStudentVO> info = null;
                    for (DataClassification dc : selectByMap2) {
                        if (gglist == null || gglist.size() == 0 && selectByMap2.indexOf(dc) == 0) {
                            view1 = new InfoViewListVO();
                            view1.setTypeTwo(dc.getId());
                            view1.setTypeName(dc.getName());
                            page = new Page<InformationStudentVO>(pageNo, pageSize);
                            info = informationMapper.informationPageOtherList(d.getId(), dc.getId(), siteId, page);
                            // modify by lilingye @ 2018-7-3 14:51:21
                            if (info != null && info.size() > 0) {
                                page.setRecords(info);
                                view1.setTypeName(dc.getName());
                                view1.setInfo(page);
                                list.add(view1);
                            }
                        } else {
                            if (vo.getPageNo() == 1) {
                                view1 = new InfoViewListVO();
                                view1.setTypeTwo(dc.getId());
                                view1.setTypeName(dc.getName());
                                list.add(view1);
                            }
                        }


//                        page = new Page<InformationStudentVO>(pageNo, pageSize);
//                        info = informationMapper.informationPageOtherList(d.getId(), dc.getId(), siteId, page);
//                        // modify by lilingye @ 2018-7-3 14:51:21
//                        if (info != null && info.size() > 0) {
//                            page.setRecords(info);
//                            view1.setTypeName(dc.getName());
//                            view1.setInfo(page);
//                            list.add(view1);
//                        }
                    }
                }
            }
        }
        infoVO.setInfoListVO(list);


//        //轮播图
//        AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
//        avo.setBannerName(vo.getBannerName());
//        avo.setTerminalName(vo.getTerminalName());
//        avo.setSiteId(siteId);
//        avo.setCompanyId(vo.getContext().getCompanyId());
//        avo.setOrgId(vo.getContext().getOrgId());
//        List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);
//        infoVO.setPortalImageList(portalImageList);
        return infoVO;
    }

    @Override
    public InformationListPcVo informationPcPageList(InfoVO vo) {
        RequestContext res = ContextHolder.get();
        InformationListPcVo infoVO = new InformationListPcVo();
        Integer pageNo = vo.getPageNo();
        Integer pageSize = vo.getPageSize();
        Long siteId = res.getSiteId();

        List<InformationStudentVO> list = null;

        InfoViewListVO view = new InfoViewListVO();
        //公告
        Page<InformationStudentVO> page = new Page<InformationStudentVO>(pageNo, pageSize);
        // 新增代码 by lilingye
        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
        siteComponyIdVO.setCompanyId(res.getCompanyId());
        siteComponyIdVO.setSiteId(res.getSiteId());
        siteComponyIdVO.setCreateById(res.getAccountId());
        siteComponyIdVO.setCreateByName(res.getAccountName());
        siteComponyIdVO.setOrgId(res.getOrgId());
        siteComponyIdVO.setSiteId(res.getSiteId());

        List<ClassificationVO> classificationVOList = dataClassificationService.getClassification(siteComponyIdVO);
        Long typeOne = null;
        Long typeTwo = vo.getTypeTwo();
        //如果是新闻,查出所有新闻分页信息及其新闻分类列表
        if (vo.getTypeName().equals(SiteConstant.PCPORTALNEWS)) {
            //如果是分类列表
            if (null != typeTwo) {
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, typeTwo, vo.getLevel(), page);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (InformationStudentVO informationStudentVO : list) {
                        //添加列表序号,以便查找上/下一条
                        informationStudentVO.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO) + 1);
                        if (null != informationStudentVO.getContent()) {
                            String content = informationStudentVO.getContent();
                            content = delHTMLTag(content);
                            if (content.length() > 150) {
                                informationStudentVO.setContent(content.substring(0, 150));
                            } else {
                                informationStudentVO.setContent(content);
                            }
                        }

                    }
                    infoVO.setNews(list);
                    infoVO.setPageTotal(page.getTotal());
                }
            } else {
                //如果是全部列表
                for (ClassificationVO classificationVO :
                        classificationVOList) {
                    if (SiteConstant.PORTALNEWS.equals(classificationVO.getName())) {
                        typeOne = classificationVO.getId();

                        log.info("typeOne值为:" + typeOne);
                        break;
                    }
                }

//                //查出所有新闻分类
//                Map<String, Object> map1 = new HashMap<String, Object>();
//                map1.put("site_id", siteId);
//                map1.put("parent_id", typeOne);
//                map1.put("state", 1);
//                List<DataClassificationEntityVo> selectByMap = dataClassificationService.selectByMap(map1);
//                if (CollectionUtils.isNotEmpty(selectByMap)) {
//                    //默认首页的时候返回
//                    if (null != pageNo && pageNo == 1) {
//                        infoVO.setClassifyNews(selectByMap);
//                    }
//                    //获取所有新闻分页信息
//                    List<Long> ids = selectByMap.stream().map(DataClassificationEntityVo::getId).collect(Collectors.toList());
//                    if (CollectionUtils.isNotEmpty(ids)) {
//                        list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, typeOne, ids, page);
//                    }
//
//                    if (CollectionUtils.isNotEmpty(list)) {
//                        for (InformationStudentVO informationStudentVO : list) {
//                            //添加每页序号,以便查找上/下一条
//                            informationStudentVO.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO) + 1);
//                            if (null != informationStudentVO.getContent()) {
//                                String content = informationStudentVO.getContent();
//                                content = delHTMLTag(content);
//                                if (content.length() > 150) {
//                                    informationStudentVO.setContent(content.substring(0, 150));
//                                } else {
//                                    informationStudentVO.setContent(content);
//                                }
//
//                            }
//                        }
//                        infoVO.setNews(list);
//                        infoVO.setPageTotal(page.getTotal());
//                    }
//                }
                if (null != pageNo && pageNo == 1) {
//                    Map<String, Object> map1 = new HashMap<String, Object>();
//                    map1.put("site_id", siteId);
//                    map1.put("parent_id", typeOne);
//                    map1.put("state", 1);
//                    List<DataClassificationEntityVo> selectByMap = dataClassificationService.selectByMap(map1);
                    //没有内容的二级分类需要筛除,重写sql
                    List<DataClassification> selectByMap = dataClassificationService.getSubcategories(siteId, typeOne);
                    List<DataClassificationVo> selectVoByMap=new ArrayList<>();
                    for (DataClassification d:selectByMap) {
                        DataClassificationVo entityVo=new DataClassificationVo();
                        BeanUtils.copyProperties(d,entityVo);
                        selectVoByMap.add(entityVo);
                    }
                    infoVO.setClassifyNews(selectVoByMap);

                }


                list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, typeOne, page);

                if (CollectionUtils.isNotEmpty(list)) {
                    for (InformationStudentVO informationStudentVO : list) {
                        //添加每页序号,以便查找上/下一条
                        informationStudentVO.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO) + 1);
                        if (null != informationStudentVO.getContent()) {
                            String content = informationStudentVO.getContent();
                            content = delHTMLTag(content);
                            if (content.length() > 150) {
                                informationStudentVO.setContent(content.substring(0, 150));
                            } else {
                                informationStudentVO.setContent(content);
                            }

                        }
                    }
                    infoVO.setNews(list);
                    infoVO.setPageTotal(page.getTotal());
                }


                //轮播图第一页的时候返回
                if (null != pageNo && pageNo == 1) {
                    AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
                    avo.setBannerName(vo.getBannerName());
                    avo.setTerminalName(vo.getTerminalName());
                    avo.setSiteId(siteId);
                    avo.setCompanyId(res.getCompanyId());
                    avo.setOrgId(res.getOrgId());
                    List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);
                    infoVO.setPortalImageList(portalImageList);
                }
            }
        } else if (vo.getTypeName().equals(SiteConstant.PCANNOUNCEMENT)) {
            //如果是公告,查出所有公告分页信息
            for (ClassificationVO classificationVO :
                    classificationVOList) {
                if (SiteConstant.ANNOUNCEMENT.equals(classificationVO.getName())) {
                    typeOne = classificationVO.getId();

                    log.info("typeOne值为:" + typeOne);
                    break;
                }
            }
            //获取所有公告分页信息
            list = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, typeOne, page);

            if (list != null && list.size() > 0) {
                //添加每页序号,以便查找上/下一条
                for (InformationStudentVO informationStudentVO1 : list) {
                    informationStudentVO1.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO1) + 1);
                    if (null != informationStudentVO1.getContent()) {
                        String content = informationStudentVO1.getContent();
                        content = delHTMLTag(content);
                        if (content.length() > 150) {
                            informationStudentVO1.setContent(content.substring(0, 150));
                        } else {
                            informationStudentVO1.setContent(content);
                        }
                    }
                }
                infoVO.setNotices(list);
                infoVO.setPageTotal(page.getTotal());
            }
        }

        return infoVO;
    }


    @Override
    public InformationListPcVo informationPcPageListV2(InfoVO vo) {
        RequestContext res = ContextHolder.get();
        InformationListPcVo infoVO = new InformationListPcVo();
        Integer pageNo = vo.getPageNo();
        Integer pageSize = vo.getPageSize();
        Long siteId = res.getSiteId();

        List<InformationStudentVO> list = null;

        InfoViewListVO view = new InfoViewListVO();
        //公告
        Page<InformationStudentVO> page = new Page<InformationStudentVO>(pageNo, pageSize);

        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
        siteComponyIdVO.setCompanyId(res.getCompanyId());
        siteComponyIdVO.setSiteId(res.getSiteId());
        siteComponyIdVO.setCreateById(res.getAccountId());
        siteComponyIdVO.setCreateByName(res.getAccountName());
        siteComponyIdVO.setOrgId(res.getOrgId());
        siteComponyIdVO.setSiteId(res.getSiteId());

        List<ClassificationVO> classificationVOList = null;//dataClassificationService.getClassification(siteComponyIdVO);

        //获取根节点下的所有分类
        Long typeOne = vo.getRelationId();
        if(typeOne == null){
            typeOne = 0L;
        }
        List<DataClassificationVo> classifyNews = null;
        Long typeTwo = vo.getTypeTwo();

        //如果是新闻,查出所有新闻分页信息及其新闻分类列表
        if (vo.getTypeName().equals(SiteConstant.PCPORTALNEWS)) {
            //如果是分类列表
            if (null != typeTwo) {
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, typeTwo, vo.getLevel(), page);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (InformationStudentVO informationStudentVO : list) {
                        //添加列表序号,以便查找上/下一条
                        informationStudentVO.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO) + 1);
                        if (null != informationStudentVO.getContent()) {
                            String content = informationStudentVO.getContent();
                            content = delHTMLTag(content);
                            if (content.length() > 150) {
                                informationStudentVO.setContent(content.substring(0, 150));
                            } else {
                                informationStudentVO.setContent(content);
                            }
                        }

                    }
                    infoVO.setNews(list);
                    infoVO.setPageTotal(page.getTotal());
                }
            } else {
                //如果是全部列表，查询所有的分类含根目录
                classifyNews = dataClassificationService.getAllClassification(siteComponyIdVO, typeOne);
                infoVO.setClassifyNews(classifyNews);

               /* if (null != pageNo && pageNo == 1) {
                    //没有内容的二级分类需要筛除,重写sql
                    List<DataClassification> selectByMap = dataClassificationService.getSubcategories(siteId, typeOne);
                    List<DataClassificationVo> selectVoByMap=new ArrayList<>();
                    for (DataClassification d:selectByMap) {
                        DataClassificationVo entityVo=new DataClassificationVo();
                        BeanUtils.copyProperties(d,entityVo);
                        selectVoByMap.add(entityVo);
                    }

                }*/

                //查询所有分类
                list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, typeOne, page);

                if (CollectionUtils.isNotEmpty(list)) {
                    for (InformationStudentVO informationStudentVO : list) {
                        //添加每页序号,以便查找上/下一条
                        informationStudentVO.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO) + 1);
                        if (null != informationStudentVO.getContent()) {
                            String content = informationStudentVO.getContent();
                            content = delHTMLTag(content);
                            if (content.length() > 150) {
                                informationStudentVO.setContent(content.substring(0, 150));
                            } else {
                                informationStudentVO.setContent(content);
                            }
                        }
                    }
                    infoVO.setNews(list);
                    infoVO.setPageTotal(page.getTotal());
                }
                //轮播图第一页的时候返回
                if (null != pageNo && pageNo == 1) {
                    AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
                    avo.setBannerName(vo.getBannerName());
                    avo.setTerminalName(vo.getTerminalName());
                    avo.setSiteId(siteId);
                    avo.setCompanyId(res.getCompanyId());
                    avo.setOrgId(res.getOrgId());
                    List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);
                    infoVO.setPortalImageList(portalImageList);
                }
            }
        } else if (vo.getTypeName().equals(SiteConstant.PCANNOUNCEMENT)) {
            //如果是公告,查出所有公告分页信息
            for (ClassificationVO classificationVO :
                    classificationVOList) {
                if (SiteConstant.ANNOUNCEMENT.equals(classificationVO.getName())) {
                    typeOne = classificationVO.getId();

                    log.info("typeOne值为:" + typeOne);
                    break;
                }
            }
            //获取所有公告分页信息
            list = informationMapper.informationPageListV2(SiteConstant.ANNOUNCEMENT, siteId, typeOne, page);
            //获取置顶的公告
            List<InformationStudentVO> topList = informationMapper.informationTopList(SiteConstant.ANNOUNCEMENT, siteId, typeOne);
            infoVO.setTopInfos(topList);
            if (list != null && list.size() > 0) {
                //添加每页序号,以便查找上/下一条
                for (InformationStudentVO informationStudentVO1 : list) {
                    informationStudentVO1.setListNo((pageNo - 1) * pageSize + list.indexOf(informationStudentVO1) + 1);
                    if (null != informationStudentVO1.getContent()) {
                        String content = informationStudentVO1.getContent();
                        content = delHTMLTag(content);
                        if (content.length() > 150) {
                            informationStudentVO1.setContent(content.substring(0, 150));
                        } else {
                            informationStudentVO1.setContent(content);
                        }
                    }
                }
                infoVO.setNotices(list);
                infoVO.setPageTotal(page.getTotal());
            }
        }

        return infoVO;
    }

    @Override
    public InformationViewVO getPcInformation(IdOneVO idOneVO) {
        RequestContext res = ContextHolder.get();
        Long siteId = res.getSiteId();
        Information information = this.getInformation(idOneVO.getId(), siteId);


        // 新增阅读次数
        InformationViewVO informationViewVO = new InformationViewVO();
        if (null != information) {
            BeanUtils.copyProperties(information, informationViewVO);
        }
        //查询详情
        informationViewVO.setReadCount(informationReadNumberService.getInformationReadCount(idOneVO.getId()));
        Integer listNo = idOneVO.getListNo();
        Integer total = idOneVO.getTotal();

        //用于查询上/下一条信息
        List<InformationStudentVO> list = null;
        Page<InformationStudentVO> page = null;

        //如果是链接查看详情,
        if (null == idOneVO.getTypeName() && null == idOneVO.getTypeOne() && null == idOneVO.getTypeTwo()) {
            //查找该条信息类型
            String typeName = informationMapper.getType(idOneVO.getId(), siteId);
            if (null != typeName) {
                informationViewVO.setTypeName(typeName);
            }
            return informationViewVO;
        }


        //如果是新闻分类列表详情,从该分类列表中查出上/下一条
        if (null != idOneVO.getTypeTwo() && idOneVO.getTypeName().equals(SiteConstant.PCPORTALNEWS)) {
            //如果是第一条
            if (listNo == 1) {
                //将每条信息分成一页
                page = new Page<>(2, 1);
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeTwo(), null, page);
                if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                    informationViewVO.setSuffixInformationId(list.get(0).getId());
                    informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                    if (null != list.get(0).getLinkUrl()) {
                        informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                    }
                    if (null != listNo) {
                        informationViewVO.setSuffixListNO(listNo + 1);
                    }
                }
            } else if (listNo.equals(total)) {
                //如果是最后一页最后一条数据只查上一条
                page = new Page<>(listNo - 1, 1);
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeTwo(), null, page);
                if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                    informationViewVO.setPreInformationId(list.get(0).getId());
                    informationViewVO.setPreInformationName(list.get(0).getFileName());
                    if (null != list.get(0).getLinkUrl()) {
                        informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                    }
                    if (null != listNo) {
                        informationViewVO.setPreListNO(listNo - 1);
                    }

                }
            } else {
                //其他的都查上一条,下一条
                page = new Page<>(listNo - 1, 1);
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeTwo(), null, page);
                if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                    informationViewVO.setPreInformationId(list.get(0).getId());
                    informationViewVO.setPreInformationName(list.get(0).getFileName());
                    if (null != list.get(0).getLinkUrl()) {
                        informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                    }
                    if (null != listNo) {
                        informationViewVO.setPreListNO(listNo - 1);
                    }

                }
                list.clear();
                page = new Page<>(listNo + 1, 1);
                list = informationMapper.informationClassifyPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeTwo(), null, page);
                if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                    informationViewVO.setSuffixInformationId(list.get(0).getId());
                    informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                    if (null != list.get(0).getLinkUrl()) {
                        informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                    }
                    if (null != listNo) {
                        informationViewVO.setSuffixListNO(listNo + 1);
                    }

                }
            }
        } else if (null != idOneVO.getTypeOne()) {
            //如果是所有列表详情
            if (idOneVO.getTypeName().equals(SiteConstant.PCPORTALNEWS)) {
                //如果是新闻,从所有新闻列表中查出上/下一条
                if (listNo == 1) {
                    //将每条信息分成一页,如果是第一页第一条
                    page = new Page<>(2, 1);
//                    Map<String, Object> map1 = new HashMap<String, Object>();
//                    map1.put("site_id", siteId);
//                    map1.put("parent_id", idOneVO.getTypeOne());
//                    map1.put("state", 1);
//                    List<DataClassificationEntityVo> selectByMap = dataClassificationService.selectByMap(map1);
//                    if (CollectionUtils.isNotEmpty(selectByMap)) {
//                        //获取所有新闻分页信息
//                        List<Long> ids = selectByMap.stream().map(DataClassificationEntityVo::getId).collect(Collectors.toList());
//                        if (CollectionUtils.isNotEmpty(ids)) {
//                            list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), ids, page);
//                        }
//                    }
                    list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setSuffixInformationId(list.get(0).getId());
                        informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setSuffixListNO(listNo + 1);
                        }

                    }
                } else if (listNo.equals(total)) {
                    //如果是最后一页最后一条数据只查上一条
                    page = new Page<>(listNo - 1, 1);
//                    Map<String, Object> map1 = new HashMap<String, Object>();
//                    map1.put("site_id", siteId);
//                    map1.put("parent_id", idOneVO.getTypeOne());
//                    map1.put("state", 1);
//                    List<DataClassificationEntityVo> selectByMap = dataClassificationService.selectByMap(map1);
//                    if (CollectionUtils.isNotEmpty(selectByMap)) {
//                        //获取所有新闻分页信息
//                        List<Long> ids = selectByMap.stream().map(DataClassificationEntityVo::getId).collect(Collectors.toList());
//                        if (CollectionUtils.isNotEmpty(ids)) {
//                            list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), ids, page);
//                        }
//                    }
                    list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setPreInformationId(list.get(0).getId());
                        informationViewVO.setPreInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setPreListNO(listNo - 1);
                        }

                    }
                } else {
                    //其他的都查上一条,下一条
                    page = new Page<>(listNo - 1, 1);
                    Map<String, Object> map1 = new HashMap<String, Object>();
//                    map1.put("site_id", siteId);
//                    map1.put("parent_id", idOneVO.getTypeOne());
//                    map1.put("state", 1);
//                    List<DataClassificationEntityVo> selectByMap = dataClassificationService.selectByMap(map1);
//                    if (CollectionUtils.isNotEmpty(selectByMap)) {
//                        //获取所有新闻分页信息
//                        List<Long> ids = selectByMap.stream().map(DataClassificationEntityVo::getId).collect(Collectors.toList());
//                        if (CollectionUtils.isNotEmpty(ids)) {
//                            list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), ids, page);
//                        }
//                        if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
//                            informationViewVO.setPreInformationId(list.get(0).getId());
//                            informationViewVO.setPreInformationName(list.get(0).getFileName());
//                            if (null != list.get(0).getLinkUrl()) {
//                                informationViewVO.setPreUrl(list.get(0).getLinkUrl());
//                            }
//                            if (null != listNo) {
//                                informationViewVO.setPreListNO(listNo - 1);
//                            }
//
//                        }
//                        list.clear();
//                        page = new Page<>(listNo + 1, 1);
//                        if (CollectionUtils.isNotEmpty(selectByMap)) {
//                            //获取所有新闻分页信息
//                            if (CollectionUtils.isNotEmpty(ids)) {
//                                list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), ids, page);
//                            }
//                        }
//                        if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
//                            informationViewVO.setSuffixInformationId(list.get(0).getId());
//                            informationViewVO.setSuffixInformationName(list.get(0).getFileName());
//                            if (null != list.get(0).getLinkUrl()) {
//                                informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
//                            }
//                            if (null != listNo) {
//                                informationViewVO.setSuffixListNO(listNo + 1);
//                            }
//
//                        }
//                    }
                    //获取所有新闻分页信息
                    list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setPreInformationId(list.get(0).getId());
                        informationViewVO.setPreInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setPreListNO(listNo - 1);
                        }

                    }
                    list.clear();
                    page = new Page<>(listNo + 1, 1);
                    //获取所有新闻分页信息
                    list = informationMapper.informationPcPageList(SiteConstant.PORTALNEWS, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setSuffixInformationId(list.get(0).getId());
                        informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setSuffixListNO(listNo + 1);
                        }

                    }
                }
            } else if (idOneVO.getTypeName().equals(SiteConstant.PCANNOUNCEMENT)) {
                //如果是公告,从所有公告列表中查出上/下一条
                if (listNo == 1) {
                    //将每条信息分成一页
                    page = new Page<>(2, 1);
                    list = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setSuffixInformationId(list.get(0).getId());
                        informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setSuffixListNO(listNo + 1);
                        }

                    }
                } else if (listNo.equals(total)) {
                    //如果是最后一页最后一条数据只查上一条
                    page = new Page<>(listNo - 1, 1);
                    list = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setPreInformationId(list.get(0).getId());
                        informationViewVO.setPreInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setPreListNO(listNo - 1);
                        }

                    }
                } else {
                    //其他的都查上一条,下一条
                    page = new Page<>(listNo - 1, 1);
                    list = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setPreInformationId(list.get(0).getId());
                        informationViewVO.setPreInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setPreUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setPreListNO(listNo - 1);
                        }

                    }
                    list.clear();
                    page = new Page<>(listNo + 1, 1);
                    list = informationMapper.informationPageList(SiteConstant.ANNOUNCEMENT, siteId, idOneVO.getTypeOne(), page);
                    if (CollectionUtils.isNotEmpty(list) && null != list.get(0)) {
                        informationViewVO.setSuffixInformationId(list.get(0).getId());
                        informationViewVO.setSuffixInformationName(list.get(0).getFileName());
                        if (null != list.get(0).getLinkUrl()) {
                            informationViewVO.setSuffixUrl(list.get(0).getLinkUrl());
                        }
                        if (null != listNo) {
                            informationViewVO.setSuffixListNO(listNo + 1);
                        }

                    }
                }
            }

        }
        if (null != idOneVO.getTypeOne()) {
            informationViewVO.setTypeName(idOneVO.getTypeName());
        }
        return informationViewVO;
    }

    @Override
    public List<Information> selectInformation(Long typeTwo) {
        Information information = new Information();
        information.setTypeTwo(typeTwo);
        EntityWrapper<Information> wrapper = new EntityWrapper<Information>(information);
        return this.selectList(wrapper);
    }

    @Override
    public Page<Information> informationReleaseList(InfomationParamReleaseVO vo) {

        //查找分类;获取分类下
        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
        siteComponyIdVO.setCompanyId(vo.getCompanyId());
        siteComponyIdVO.setSiteId(vo.getSiteId());
        siteComponyIdVO.setCreateById(vo.getAccountId());
        siteComponyIdVO.setCreateByName(vo.getAccountName());
        siteComponyIdVO.setOrgId(vo.getOrgId());
        siteComponyIdVO.setSiteId(vo.getSiteId());
        List<ClassificationVO> classificationVOList = dataClassificationService.getClassification(siteComponyIdVO);
        Long typeOne = null;
        for (ClassificationVO classificationVO :
                classificationVOList) {
            if (SiteConstant.PORTALNEWS.equals(classificationVO.getName())) {
                typeOne = classificationVO.getId();

                log.info("typeOne值为:" + typeOne);
                break;
            }
        }
        vo.setTypeId(typeOne);
        DataClassification selectById = dataClassificationService.selectById(vo.getTypeId());
        if (selectById == null) {
            return null;
        }
        //获取所有上架新闻列表
        InfomationParamVO infomationParamVO = new InfomationParamVO();
        BeanUtils.copyProperties(vo,infomationParamVO);
        infomationParamVO.setState(2);
        Page<Information> page = new Page<Information>(vo.getPageNo(), vo.getPageSize());
        List<Information> list = Lists.newArrayList();
        if(vo.getTypeId()==null||vo.getTypeId()==0L){
            list = informationMapper.informationAllList(infomationParamVO, page);
        }else {
            if (selectById == null) {
                return null;
            }
            if (selectById.getName().equals(SiteConstant.ANNOUNCEMENT) && selectById.getParentId() == 0) {  //公告
                list = informationMapper.informationFirstList(infomationParamVO, page);
            } else if (selectById.getParentId() == 0) {//新闻所有列表
                list = informationMapper.informationFirstList(infomationParamVO, page);
            } else {
                DataClassification selectByParentId = dataClassificationService.selectById(selectById.getParentId());
                if (selectByParentId == null || selectByParentId.getParentId() == 0) {
                    list = informationMapper.informationTwoList(infomationParamVO, page);//新闻分类列表
                } else {
                    list = informationMapper.informationThreeList(infomationParamVO, page);//新闻分类列表
                }
            }
        }
        if (list.size() > 0 && list != null) {
            for (Information info : list) {
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
            }
        }
        page.setRecords(list);
        return page;



    }

    @Override
    public List<InformationVo> listbyIds(List<Long> idList) {
        EntityWrapper<Information> entityWrapper = new EntityWrapper<>();
        entityWrapper.in("id", idList);
        List<Information> informationList =  this.selectList(entityWrapper);
        List<InformationVo> list = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(informationList)){
            informationList.stream().forEach(info -> {
                InformationVo vo = new InformationVo();
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
                BeanUtils.copyProperties(info,vo);
                list.add(vo);
            });
        }
        return list;
    }

    @Override
    public Page<Information> informationList(InfomationParamVO vo) {
        // modify by lingye
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            if (vo.getStart() != null) {
                Date startTime = sdf.parse(sdf.format(vo.getStart()));


                Date endTime = sdf.parse(sdf.format(vo.getEnd()));

                // 查询结束时间 加一天
                Calendar c = Calendar.getInstance();
                c.setTime(endTime);
                c.add(Calendar.DAY_OF_MONTH, 1);

                Date end = c.getTime();
                log.info("开始时间：" + startTime + "；结束时间：" + end);

                vo.setStart(sdf.parse(sdf.format(vo.getStart())));
                vo.setEnd(end);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }


        Page<Information> page = new Page<Information>(vo.getPageNo(), vo.getPageSize());
        List<Information> list = null;
        if(vo.getTypeId()==null||vo.getTypeId()==0L){
            list = informationMapper.informationAllList(vo, page);
        }else {
            DataClassification selectById = dataClassificationService.selectById(vo.getTypeId());
            if (selectById == null) {
                return null;
            }
            if (selectById.getName().equals(SiteConstant.ANNOUNCEMENT) && selectById.getParentId() == 0) {  //公告
                list = informationMapper.informationFirstList(vo, page);
            } else if (selectById.getParentId() == 0) {//新闻所有列表
                list = informationMapper.informationFirstList(vo, page);
            } else {
                DataClassification selectByParentId = dataClassificationService.selectById(selectById.getParentId());
                if (selectByParentId == null || selectByParentId.getParentId() == 0) {
                    list = informationMapper.informationTwoList(vo, page);//新闻分类列表
                } else {
                    list = informationMapper.informationThreeList(vo, page);//新闻分类列表
                }
            }
        }
        if (list.size() > 0 && list != null) {
            for (Information info : list) {
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
                info.setAdmireNum(eventTrackService.getNum("event_admire_"+info.getTypeOne(),info.getId()));
                info.setFavoriteNum(eventTrackService.getNum("event_comment_"+info.getTypeOne(),info.getId()));
                info.setRelayNum(eventTrackService.getNum("event_relay_"+info.getTypeOne(),info.getId()));
                info.setReadNum(informationReadNumberService.getInformationReadCountPc(info.getId()));
                info.setReadDistinctNum(informationReadNumberService.getInformationReadDistinctCount(info.getId()));
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public Information informationView(Long id) {
        Information info = this.selectById(id);
        if (info == null) {
            return null;
        }
        if (info.getTypeOne() != null && info.getTypeOne() != 0) {
            info.setTypeOneName(findNameById(info.getTypeOne()));
        }
        if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
            info.setTypeTwoName(findNameById(info.getTypeTwo()));
        }
        if (info.getTypeThree() != null && info.getTypeThree() != 0) {
            info.setTypeThreeName(findNameById(info.getTypeThree()));
        }

        //设置资讯分类
        InformationClassify classify = new InformationClassify();
        classify.setInformationId(id);
        EntityWrapper<InformationClassify> wrapper = new EntityWrapper<InformationClassify>(classify);
        List<InformationClassify> informationClassify = informationClassifyMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(informationClassify)) {
            for(InformationClassify item : informationClassify){
                if (item.getTypeOne() != null && item.getTypeOne() != 0) {
                    item.setTypeOneName(findNameById(item.getTypeOne()));
                }
                if (item.getTypeTwo() != null && item.getTypeTwo() != 0) {
                    item.setTypeTwoName(findNameById(item.getTypeTwo()));
                }
                if (item.getTypeThree() != null && item.getTypeThree() != 0) {
                    item.setTypeThreeName(findNameById(item.getTypeThree()));
                }
            }
        }
        info.setInformationClassify(informationClassify);

        return info;
    }

    private String findNameById(Long id) {
        DataClassification selectById = dataClassificationService.selectById(id);
        if (selectById != null) {
            return selectById.getName();
        }
        return null;
    }

    @Override
    public Long insertInformation(Information information) {
       return insertInformation(information,null);
    }

    @Override
    public Long insertInformation(Information information,Long id) {
        if(id==null){
            id = idGenerator.generate();
        }
        information.setId(id);
        information.setIsTop(0L);
        // 判断时间
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        //输入新闻的发布时间
        Calendar releaseTime = Calendar.getInstance();
        if(information.getReleaseTime()!=null) {
            releaseTime.setTime(information.getReleaseTime());
        }else{
            releaseTime.setTime(new Date());
        }
        if (releaseTime.after(date)) {
            information.setState(SiteConstant.FIRST);
            this.insert(information);
            timeUpInfomation(id);
        } else {
            information.setState(SiteConstant.TWO);
            this.insert(information);

        }

        //保存资讯分类
        if (!CollectionUtils.isEmpty(information.getInformationClassify())) {
            for(InformationClassify item : information.getInformationClassify()){
                item.setId(idGenerator.generate());
                item.setInformationId(information.getId());
                item.setCreateById(information.getCreateById());
                item.setCreateByName(information.getCreateByName());
                item.setCreateTime(information.getCreateTime());
                item.setUpdateById(information.getUpdateById());
                item.setUpdateByName(information.getUpdateByName());
                item.setUpdateTime(information.getUpdateTime());

                informationClassifyMapper.insert(item);
            }
        }

        if (!StringUtils.isEmpty(information.getPdfOssUrl()) && !StringUtils.isEmpty(information.getPdfFileName())) {
            List<PdfVO> pdfVOs = new ArrayList<PdfVO>();
            PdfVO pdfVO = new PdfVO();
            pdfVO.setBizId(information.getId());
            pdfVO.setBizType(TpActivityType.TYPE_INFORMATION);
            pdfVO.setSiteId(information.getSiteId());
            pdfVO.setCreateById(information.getCreateById());
            pdfVO.setOriginalFile(information.getPdfFileName());
            pdfVO.setOriginalFileUrl(information.getPdfOssUrl());
            pdfVOs.add(pdfVO);
            try {
                if (!CollectionUtils.isEmpty(pdfVOs)) {
                    LOGGER.info("pdf解析图片发送消息："+pdfVOs.toString());
                    cloudEventPublisher.publish("pdfToPng",new EventWrapper(0L, pdfVOs));
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                LOGGER.error("pdf解析图片发送消息失败：",e);
            }
        }
        return id;
    }

    @Override
    public boolean releases(ParamVO vo) {
        List<Long> ids = vo.getIds();
        List<Information> list = new ArrayList<Information>();
        Information selectById = null;
        for (Long id : ids) {
            selectById = this.selectById(id);
            selectById.setState(2);
            list.add(selectById);
        }
        if (list.size() > 0) {
            this.updateBatchById(list);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean releaseInfomation(Long id) {
        Information information = this.selectById(id);
        information.setState(SiteConstant.TWO);
        // 新闻公告上架操作
        this.updateById(information);
        return true;
    }

    @Override
    public boolean unreleases(ParamVO vo) {
        List<Long> ids = vo.getIds();
        List<Information> list = new ArrayList<Information>();
        Information selectById = null;
        for (Long id : ids) {
            selectById = this.selectById(id);
            if(selectById!=null) {
                selectById.setState(1);
                list.add(selectById);
            }
        }
        if (list.size() > 0) {
            this.updateBatchById(list);
        }
        return true;
    }

    @Override
    public Page<InformationStudentVO> informationList(Long typeOne, Integer pageNo, Integer pageSize, Long siteId) {
        Page<InformationStudentVO> page = new Page<InformationStudentVO>(pageNo, pageSize);
        Integer state = 2;
        List<InformationStudentVO> list = informationMapper.selectInformationVO(typeOne, siteId, state, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Information getInformation(Long id, Long siteId) {
        Information information = new Information();
        information.setSiteId(siteId);
        information.setId(id);
        information.setState(2);
        EntityWrapper<Information> wrapper = new EntityWrapper<Information>(information);
        return this.selectOne(wrapper);
    }

    @Override
    public List<Information> searchInformation(Page<Information> page, Information info) {
        return informationMapper.searchInformation(page, info);
    }

    @Override
    public List<Information> listbyName(String name, Long siteId) {
        Information info = new Information();
        info.setFileName(name);
        info.setSiteId(siteId);
        info.setState(SiteConstant.TWO);
        return informationMapper.searchInformation(info);
    }

    @Override
    public Boolean top(Long id) {
        Information selectById = this.selectById(id);
        if (selectById == null) {
            return false;
        }
        Long isTop = selectById.getIsTop();
        if (isTop == 1) {
            selectById.setIsTop(0L);
        } else {
            selectById.setIsTop(1L);
        }
        return this.updateById(selectById);
    }

    @Override
    public boolean timeUpInfomation(Long id) {

//        Information information = this.selectById(id);
//
//        // 批处理时间要在当前时间前十分钟哦
//        Calendar nowTime = Calendar.getInstance();
//        nowTime.add(Calendar.MINUTE, -10);
//
//
//        try {
//            VmyJobVO job = new VmyJobVO();
//            job.setGroup(jobGroup);
//            job.setJobName(id.toString());
//            job.setJobClassName("com.yizhi.application.handle.quartz.job.InformationUpJob");
//            String cron = DateUtil.getCron(information.getReleaseTime());
//            String[] cronArr = cron.split(" ");
//            job.setSecond(cronArr[0]);
//            job.setMinute(cronArr[1]);
//            job.setHour(cronArr[2]);
//            job.setDay(cronArr[3]);
//            job.setMonth(cronArr[4]);
//            job.setWeek(cronArr[5]);
//            job.setYear(cronArr[6]);
//            jobClient.insert(job);
//        } catch (Exception e) {
//            log.error("创建任务失败,id=" + id + "错误消息={}", e);
//        }

        return true;
    }


    @Override
    public List<Information> getRelationAnnouncementPC(Long terminalId) {
        // TODO Auto-generated method stub
        return informationMapper.getRelationAnnouncementPC(terminalId);
    }


    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>"; //定义script的正则表达式
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>"; //定义style的正则表达式
        String regEx_html = "<[^>]+>"; //定义HTML标签的正则表达式

        Pattern p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll(""); //过滤script标签

        Pattern p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll(""); //过滤style标签

        Pattern p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll(""); //过滤html标签

        //过滤空格符
        String pattern = "&nbsp;";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(htmlStr);
        htmlStr = m.replaceAll("");

        return htmlStr.trim(); //返回文本字符串
    }


    @Override
    public Page<Information> getInformationByTypeOne(Long typeOne, Integer pageNo, Integer pageSize, Long siteId, List<Long> listIds) {
        LOGGER.info("参数："+listIds);
        Page<Information> page = new Page<Information>(pageNo, pageSize);
        Information information = new Information();
        information.setTypeOne(typeOne);
        information.setState(2);
        information.setSiteId(siteId);
        EntityWrapper<Information> wrapper = new EntityWrapper<Information>(information);
        if (null!=listIds&&listIds.size()>0) {
            LOGGER.info("参数长度大于0");
            wrapper.notIn("id", listIds);
        }
        return this.selectPage(page, wrapper);
    }


    @Override
    public Page<Information> getAllAnnouncementPC(Long terminalId, Integer pageNo, Integer pageSize) {
        // TODO Auto-generated method stub
        Long siteId = ContextHolder.get().getSiteId();
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("公告");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        //公告的一级信息  公告没有二级标题
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        //已经关联的公告具体信息
        List<Information> listInformations = informationMapper.getRelationAnnouncementPC(terminalId);
        List<Long> listIds = null;
        if (CollectionUtils.isNotEmpty(listInformations)) {
            listIds = new ArrayList<Long>();
            for (int i = 0; i < listInformations.size(); i++) {
                listIds.add(listInformations.get(i).getId());
            }
        }

        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();
            return getInformationByTypeOne(id, pageNo, pageSize, siteId, listIds);
        }
        return null;
    }


    @Override
    public Page<Information> getAllNewsPC(Long terminalId, Integer pageNo, Integer pageSize) {
        // TODO Auto-generated method stub
        Long siteId = ContextHolder.get().getSiteId();
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("新闻");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();
            //已经关联的新闻除外
//            Long templateId = informationMapper.informationRelationGetInformationIds(terminalId);
            List<Long> relationNnews = informationMapper.selectRelationIds(terminalId);
//            if (templateId != null) {
//                relationNnews = informationMapper.getRelationInformationIds(templateId);
//            }
            return getInformationByTypeOne(id, pageNo, pageSize, siteId, relationNnews);
        }
        return null;
    }

    @Override
    public List<Information> getRelationInformation(Long id) {
        // TODO Auto-generated method stub
        ProtalPlate plate = new ProtalPlate();
        plate.setTemplateId(id);
        plate.setState(1);//未删除
        EntityWrapper<ProtalPlate> wrapper = new EntityWrapper<ProtalPlate>(plate);
        List<ProtalPlate> listProtalPlate = protalPlateService.selectList(wrapper);
        List<Long> listInformationIds = null;
        if (CollectionUtils.isNotEmpty(listProtalPlate)) {
            listInformationIds = new ArrayList<Long>();
            for (int i = 0; i < listProtalPlate.size(); i++) {
                listInformationIds.add(listProtalPlate.get(i).getLinkContent());
            }
            if (CollectionUtils.isNotEmpty(listInformationIds)) {
                return this.selectBatchIds(listInformationIds);
            }
        }
        return null;
    }

    @Override
    public List<AnnouncementVO> getApiRelationAnnouncement(Long siteId, Integer terminalType) {
        // TODO Auto-generated method stub

        Long homeId = portalTerminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId, terminalType);
        if (homeId != null) {
            List<AnnouncementVO> list = homeAnnouncementMapper.listAnnouncementApi(homeId);
            if (CollectionUtils.isNotEmpty(list)) {
                if (list.size() > 3) {
                    list = list.subList(0, 3);  //左闭右开，截取三个
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public List<Information> listSupplyInformation(Long siteId, List<Long> ids) {
        // TODO Auto-generated method stub
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("新闻");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();

            Information information = new Information();
            information.setTypeOne(id);
            information.setState(2);
            EntityWrapper<Information> wrapperInformation = new EntityWrapper<Information>(information);
            wrapperInformation.notIn("id", ids);
            wrapperInformation.orderBy("release_time", false);
            return this.selectList(wrapperInformation);

        }
        return null;
    }

    @Override
    public List<ImageListVO> listBannerImages(InfoVO infoVO) {


        RequestContext res = ContextHolder.get();
        //轮播图
        AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
        avo.setBannerName(infoVO.getBannerName());
        avo.setTerminalName(infoVO.getTerminalName());
        avo.setSiteId(res.getSiteId());
        avo.setCompanyId(res.getCompanyId());
        avo.setOrgId(res.getOrgId());
        List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);
        return portalImageList;
    }

}

