package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.site.application.domain.International;
import com.yizhi.site.application.domain.InternationalKey;
import com.yizhi.site.application.mapper.InternationalKeyMapper;
import com.yizhi.site.application.service.IInternationalKeyService;
import com.yizhi.site.application.service.IInternationalService;
import com.yizhi.site.application.vo.site.InternationalVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 语言国际化的key表  服务实现类
 * </p>
 *
 * @author taoge123
 * @since 2020-09-17
 */
@Service
public class InternationalKeyServiceImpl extends ServiceImpl<InternationalKeyMapper, InternationalKey> implements IInternationalKeyService {


    @Autowired
    private IInternationalService internationalService;
    @Override
    public Map<String, Long> getKeyMap(Integer terminalType, String key) {
        Map<String, Long> keyMap = null;
        InternationalKey internationalKey = new InternationalKey();
        internationalKey.setDeleted(0);
        internationalKey.setType(terminalType);
        EntityWrapper<InternationalKey> wrapper = new EntityWrapper<>(internationalKey);
        if (StringUtils.isNotBlank(key)) {
            wrapper.like("international_key", key).or().like("pre_translation", key);
        }
        List<InternationalKey> internationalKeys = this.baseMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(internationalKeys)) {
            keyMap = internationalKeys.parallelStream().collect(Collectors.toMap(InternationalKey::getInternationalKey, InternationalKey::getId));
        }
        return keyMap;
    }

    @Override
    public Map<Long, InternationalKey> getKeyIdMap(Integer terminalType, String key) {
        Map<Long, InternationalKey> keyMap = null;
        InternationalKey internationalKey = new InternationalKey();
        internationalKey.setDeleted(0);
        internationalKey.setType(terminalType);
        EntityWrapper<InternationalKey> wrapper = new EntityWrapper<>(internationalKey);
        if (StringUtils.isNotBlank(key)) {
            wrapper.like("international_key", key).or().like("pre_translation", key);
        }
        List<InternationalKey> internationalKeys = this.baseMapper.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(internationalKeys)) {
            keyMap = internationalKeys.parallelStream().collect(Collectors.toMap(InternationalKey::getId, a -> a));
        }
        return keyMap;
    }

    @Override
    public Integer update(InternationalVO internationalVO) {
        InternationalKey internationalKey = new InternationalKey();
        BeanUtils.copyProperties(internationalVO,internationalKey);
        internationalKey.setId(internationalVO.getInternationalKeyId());
        return this.baseMapper.updateById(internationalKey);
    }
}
