package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.domain.MyItemConfig;
import com.yizhi.site.application.domain.MyItemConfigDefault;
import com.yizhi.site.application.mapper.MyItemConfigDefaultMapper;
import com.yizhi.site.application.mapper.MyItemConfigMapper;
import com.yizhi.site.application.service.MyItemConfigService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author hutao123
 * @since 2019-02-21
 */
@Slf4j
@Service
public class MyItemConfigServiceImpl extends ServiceImpl<MyItemConfigMapper, MyItemConfig> implements MyItemConfigService {

    @Autowired
    private MyItemConfigMapper myItemConfigmapper;
    @Autowired
    private MyItemConfigDefaultMapper myItemConfigDefaultMapper;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private RedisCache redisCache;

    @Override
    public List<MyItemConfig> queryMyitemConfigByCondition(String name, Integer showable, Integer terminalType) {
        String key = "my_item_config_init:" + ContextHolder.get().getSiteId();
        List<MyItemConfig> list = myItemConfigmapper.queryMyitemConfigByCondition(name, showable, terminalType, ContextHolder.get().getSiteId());
        if (CollectionUtils.isEmpty(list)) {
            if (redisCache.setIfAbsent(key, "init")) {
                List<MyItemConfigDefault> listTem = myItemConfigDefaultMapper.queryMyitemConfigByCondition(null, null, null, null);
                List<MyItemConfig> finalList = list;
                listTem.forEach(a -> {
                    MyItemConfig myItemConfig = new MyItemConfig();
                    BeanUtils.copyProperties(a, myItemConfig);
                    myItemConfig.setId(idGenerator.generate());
                    myItemConfig.setSiteId(ContextHolder.get().getSiteId());
                    myItemConfig.setCreateTime(new Date());
                    myItemConfig.setCreateByName(ContextHolder.get().getAccountName());
                    myItemConfig.setCreateById(ContextHolder.get().getAccountId());
                    myItemConfigmapper.insert(myItemConfig);
                    finalList.add(myItemConfig);
                });
                redisCache.delete(key);
            } else {
                list = myItemConfigmapper.queryMyitemConfigByCondition(name, showable, terminalType, ContextHolder.get().getSiteId());
            }
        } else {
            //补缺少的导航栏
            List<MyItemConfig> addList = new ArrayList<MyItemConfig>();
            List<MyItemConfigDefault> listTem = myItemConfigDefaultMapper.queryMyitemConfigByCondition(null, null, null, null);
            boolean isAdd = true;
            for (MyItemConfigDefault item : listTem) {
                isAdd = true;
                for (MyItemConfig itemConfig : list) {
                    if (item.getName().equals(itemConfig.getName())) {
                        isAdd = false;
                        break;
                    }
                }

                if (isAdd) {
                    MyItemConfig myItemConfig = new MyItemConfig();
                    BeanUtils.copyProperties(item, myItemConfig);
                    myItemConfig.setId(idGenerator.generate());
                    myItemConfig.setSiteId(ContextHolder.get().getSiteId());
                    myItemConfig.setCreateTime(new Date());
                    myItemConfig.setShowable(1);
                    myItemConfig.setCreateByName(ContextHolder.get().getAccountName());
                    myItemConfig.setCreateById(ContextHolder.get().getAccountId());
                    myItemConfigmapper.insert(myItemConfig);
                    addList.add(myItemConfig);
                }
            }
            if (addList.size() > 0) {
                list.addAll(addList);
            }
        }
        return list;
    }

    @Override
    public List<MyItemConfig> queryByAuthoity(Long siteId, List<Integer> terminalType, Integer showAble) {
        Long accountId = ContextHolder.get().getAccountId();
        if(accountId==0L){
            accountId = null;
        }else{
          List<Long> roleIds =  myItemConfigmapper.getJjXxRoleCount(accountId);
          if(CollectionUtils.isEmpty(roleIds)){
              accountId = null;
          }
        }
        log.info("我的功能列表接口查询入参 siteId:{}, terminalType:{}, showAble:{},accountId:{}", siteId, terminalType, showAble, accountId);
        return myItemConfigmapper.queryByAuthoity(siteId, terminalType, showAble,accountId);
    }

    @Override
    public Integer move(Long id, Integer type) {
        if (null == id) {
            return -1;
        }
        MyItemConfig orginMyItemConfig = myItemConfigmapper.selectById(id);

        if (null == orginMyItemConfig) {
            return -2;//数据库没有该Id
        }
        Integer orginSort = orginMyItemConfig.getSort();

        List<MyItemConfig> itemConfig = this.baseMapper.queryMyitemConfigByCondition("", null, null, ContextHolder.get().getSiteId());


        //上移
        if (type.equals(1)) {
            return upSortMyItemConfig(itemConfig, id, orginSort, orginMyItemConfig);
            //下移
        } else

            return downSortMyItemConfig(itemConfig, id, orginSort, orginMyItemConfig);
    }

    private Integer upSortMyItemConfig(List<MyItemConfig> itemConfig, Long id, Integer orginSort, MyItemConfig orginMyItemConfig) {
        Integer index = null;
        Integer upSort = null;
        Long upId = null;
        if (!CollectionUtils.isEmpty(itemConfig)) {
            for (int i = 0; i < itemConfig.size(); i++) {
                if (itemConfig.get(i).getId().equals(id)) {
                    index = i - 1;
                }
            }
            if (index < 0) {
                return -3;
            }
            upSort = itemConfig.get(index).getSort();
            upId = itemConfig.get(index).getId();

        }
        MyItemConfig upMyItemConfig = myItemConfigmapper.selectById(upId);
        upMyItemConfig.setSort(orginSort);
        Integer i = myItemConfigmapper.updateById(upMyItemConfig);

        orginMyItemConfig.setSort(upSort);
        Integer j = myItemConfigmapper.updateById(orginMyItemConfig);
        if (i == 1 && j == 1) {
            return 1;
        }
        return null;
    }

    private Integer downSortMyItemConfig(List<MyItemConfig> itemConfig, Long id, Integer orginSort, MyItemConfig orginMyItemConfig) {
        Integer index = null;
        Integer downSort = null;
        Long downId = null;
        if (!CollectionUtils.isEmpty(itemConfig)) {
            for (int i = 0; i < itemConfig.size(); i++) {
                if (itemConfig.get(i).getId().equals(id)) {
                    index = i + 1;
                }
            }
            System.out.println("" + "index____________________________" + index);
            if (index > itemConfig.size() - 1) {
                return -4;
            }
            downSort = itemConfig.get(index).getSort();
            downId = itemConfig.get(index).getId();

        }
        MyItemConfig downMyItemConfig = myItemConfigmapper.selectById(downId);
        downMyItemConfig.setSort(orginSort);
        Integer i = myItemConfigmapper.updateById(downMyItemConfig);

        orginMyItemConfig.setSort(downSort);
        Integer j = myItemConfigmapper.updateById(orginMyItemConfig);
        if (i == 1 && j == 1) {
            return 1;
        }
        return null;
    }
}
