package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.PageFooter;
import com.yizhi.site.application.mapper.PageFooterItemConfigMapper;
import com.yizhi.site.application.mapper.PageFooterItemMapper;
import com.yizhi.site.application.mapper.PageFooterMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.IPageFooterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Service
@Transactional
public class PageFooterServiceImpl extends ServiceImpl<PageFooterMapper, PageFooter> implements IPageFooterService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PageFooterServiceImpl.class);

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private PageFooterMapper pageFooterMapper;

    @Autowired
    private PageFooterItemMapper pageFooterItemMapper;

    @Autowired
    private PageFooterItemConfigMapper pageFooterItemConfigMapper;


    @Override
    public PageFooter save(PageFooter pageFooter) {

        RequestContext context = ContextHolder.get();
        PageFooter footer = new PageFooter();
        footer.setSiteId(context.getSiteId());
        footer.setDelete(0);
        // 通过SiteId 修改状态
        PageFooter pf = pageFooterMapper.selectOne(footer);
        pf.setType(pageFooter.getType());
        pf.setUpdateById(context.getAccountId());
        pf.setUpdateByName(context.getAccountName());
        pf.setUpdateTime(new Date());
        pageFooterMapper.updateById(pf);

        return pageFooter;
    }


}
