package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.album.application.feign.AlbumClassifyClient;
import com.yizhi.site.application.domain.PortalNavigate;
import com.yizhi.site.application.mapper.PortalNavigateMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.constant.SiteEnum;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.IRelationLinkService;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.service.PortalNavigateService;
import com.yizhi.course.application.feign.ClassifyClient;
import com.yizhi.site.application.vo.site.ApiPortalPCLink;
import com.yizhi.site.application.vo.site.NavigateListVO;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.enums.TerminalType;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import com.yizhi.system.application.vo.domain.Internationalization;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
public class PortalNavigateServiceImpl extends ServiceImpl<PortalNavigateMapper, PortalNavigate> implements PortalNavigateService {
	
    private static final Logger logger = LoggerFactory.getLogger(PortalNavigateServiceImpl.class);

	@Autowired
	private IdGenerator idGenerator;
	
	@Autowired
	private PortalHomeService portalHomeService;
	
	@Autowired
	private IRelationLinkService relationLinkService;
	
	@Autowired
	private PortalNavigateService portalNavigateService;
	
	@Autowired
	private PortalNavigateMapper portalNavigateMapper;
	
	@Autowired
	private PortalTerminalMapper portalTerminalMapper;
	
	@Autowired
	private ClassifyClient classifyClient;

	@Autowired
    private AlbumClassifyClient albumClassifyClient;

	@Autowired
	private InternationalizationUtil internationalizationUtil;



	@Override
	public List<NavigateListVO> navigateList(Long homeId, Integer display) {
		List<NavigateListVO> voList = new ArrayList<NavigateListVO>();
        // modify by lilingye @ 2018-7-9
        PortalNavigate portalNavigate = new PortalNavigate();
        portalNavigate.setHomeId(homeId);
        portalNavigate.setState(SiteConstant.FIRST);
//		Map<String, Object> map = new HashMap<String, Object>();
//		map.put("home_id", homeId);
		//学员端 导航栏 显示 与 不显示
		if(display == 1){
//			map.put("display", SiteConstant.FIRST);
            portalNavigate.setDisplay(SiteConstant.FIRST);
		}
//		map.put("state", SiteConstant.FIRST);
//		List<PortalNavigateEntityVo> list = this.selectByMap(map);
        EntityWrapper<PortalNavigate> wrapper = QueryUtil.condition(portalNavigate);
		wrapper.orderBy("sort",true);
        List<PortalNavigate> list = this.selectList(wrapper);
		NavigateListVO vo = null;
		for(PortalNavigate pn : list){
			vo = new NavigateListVO();
			BeanUtils.copyProperties(pn, vo, "createById", "createByName", "updateTime", "updateById", "updateByName");
			vo.setKind(SiteEnum.LIST.getValue());
			// modify by lilingye @2018-7-5 10:37:27
			if(StringUtils.isNotBlank(pn.getRelationFuncName().trim())){
				logger.info("返回的名称："+pn.getRelationFuncName());
				String valueByKey = SiteEnum.getValueByKey(pn.getRelationFuncName().trim());
				if(StringUtils.isEmpty(valueByKey)){
					valueByKey = pn.getRelationFuncCode();
				}
				vo.setType(valueByKey);
                vo.setCatname(pn.getRelationFuncName());
			}
			voList.add(vo);
		}
		return voList;
	}

	@Override
	public boolean copyNavigate(Long sourceId, Long targetId) {
		List<PortalNavigate> list = new ArrayList<PortalNavigate>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", sourceId);
		map.put("state", SiteConstant.FIRST);
		List<PortalNavigate> selectByMap = this.selectByMap(map);
		PortalNavigate p = null;
		for(PortalNavigate pn : selectByMap){
			p = new PortalNavigate();
			BeanUtils.copyProperties(pn, p);
			p.setId(idGenerator.generate());
			p.setHomeId(targetId);
			list.add(p);
		}
		if(list.size() > 0){
			this.insertBatch(list);
		}
		return true;
	}

    @Override
    public List<PortalNavigate> getNavigates(Long homeId,Integer sourceSort, Integer targetSort) {
        PortalNavigate portalNavigate = new PortalNavigate();
        portalNavigate.setHomeId(homeId);
        portalNavigate.setState(SiteConstant.FIRST);
        EntityWrapper<PortalNavigate> wrapper = QueryUtil.condition(portalNavigate);
        if (targetSort<sourceSort) {
            wrapper.where("sort <= {0}",sourceSort).andNew("sort >= {0}",targetSort);
        } else {
            wrapper.where("sort <=  {0}",targetSort).andNew("sort >= {0}",sourceSort);
        }
        wrapper.orderBy("sort",true);
        List<PortalNavigate> list = this.selectList(wrapper);

        return list;
    }
    
    /**
     * ----------------------------------------------分隔符-----------------------------------------
     */
	@Override
	public PortalNavigate updateAndInsertNavigatePc(NavigateListVO vo) {
		// TODO Auto-generated method stub
		PortalNavigate pn=new PortalNavigate();
		logger.info("传参："+vo);
		if(vo!=null&&vo.getTerminalId()!=null) {
			//根据终端ID找到homeId
			Long homeId=portalHomeService.getHomeId(vo.getTerminalId());
			Long idGenera=idGenerator.generate();
			if(homeId!=null) {
				if(vo.getId()==null) {//新增
					PortalNavigate portalNavigate=new PortalNavigate();
					portalNavigate.setId(idGenera);
					portalNavigate.setHomeId(homeId);
					portalNavigate.setSiteId(ContextHolder.get().getSiteId());
					portalNavigate.setShowName(vo.getShowName());
					//关联功能类型，系统提供的为0, 自定义的为1
					portalNavigate.setRelationFunc(vo.getRelationFunc());
					portalNavigate.setDisplay(1);
					if(vo.getPcType()==2) { //如果是下边的导航栏，加图片路径
						portalNavigate.setImgPath(vo.getImgPath());
					}
					
					Integer maxSort=portalNavigateMapper.selectMaxSortPc(homeId, vo.getPcType());
					if(maxSort!=null) {
						maxSort+=1;
					}
					else {
						maxSort=1;
					}
					portalNavigate.setSort(maxSort);
					portalNavigate.setState(1);
					if(vo.getRelationFunc()==0) {  //系统提供的
						if(vo.getRelationFuncCode()!=null) {
							portalNavigate.setRelationFuncCode(vo.getRelationFuncCode());
//							RelationLinkEntityVo relationLink=relationLinkService.getRelationLinkByCode(vo.getRelationFuncCode());
//							if(relationLink!=null) {
								portalNavigate.setRelationFuncName(vo.getRelationFuncName());
//							}
						}
					}
					if(vo.getRelationFunc()==1) {
						portalNavigate.setRelationFuncUrl(vo.getRelationFuncUrl());
					}
					
					portalNavigate.setPcType(vo.getPcType());
					portalNavigate.setCreateById(ContextHolder.get().getAccountId());
					portalNavigate.setCreateByName(ContextHolder.get().getAccountName());
					portalNavigate.setCreateTime(new Date());
					portalNavigate.setRelationId(vo.getRelationId());

					// add by lingye 2019-12-4
					portalNavigate.setRelationNum(vo.getRelationNum()!=null?vo.getRelationNum():"0");
					/**
					 * 插入信息
					 */
					boolean isTrue=portalNavigateService.insert(portalNavigate);
					/**
					 * 返回值
					 */
					if(isTrue) {
						pn.setId(idGenera);
						pn.setShowName(vo.getShowName());

						//同时添加国际化记录
						Internationalization a = new Internationalization();
						a.setName(vo.getShowName());
						a.setModuleName(ModuleType.PORTAL.getName());
						a.setModuleType(ModuleType.PORTAL.getCode());
						a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
						a.setTaskId(idGenera);
						a.setTerminalType(TerminalType.PC.getCode());
						internationalizationUtil.addInternationalization(a);
						return pn;
					}
				}
				else {   // 修改
					Long curId=vo.getId();
					PortalNavigate curMessage=this.selectById(curId);
					
					Integer curFunc=curMessage.getRelationFunc();  //当前类型关联功能类型， 自定义的为 1,系统提供的为0
					Integer nextFunc=vo.getRelationFunc();
					
					PortalNavigate portalNavigate=new PortalNavigate();
					// add by lingye 2019-12-4
					portalNavigate.setRelationNum(vo.getRelationNum()!=null?vo.getRelationNum():"0");

					if(curFunc==0&&nextFunc==0) {//系统向系统提供转换
						portalNavigate.setId(vo.getId());
						portalNavigate.setShowName(vo.getShowName());
						portalNavigate.setRelationFunc(nextFunc);
						//portalNavigateMapper.setImageNullById(curId);
						portalNavigate.setImgPath(vo.getImgPath());
						portalNavigate.setRelationFuncCode(vo.getRelationFuncCode());
//						RelationLinkEntityVo relationLink=relationLinkService.getRelationLinkByCode(vo.getRelationFuncCode());
//						if(relationLink!=null) {
							portalNavigate.setRelationFuncName(vo.getRelationFuncName());
//						}
						portalNavigate.setUpdateById(ContextHolder.get().getAccountId());
						portalNavigate.setUpdateByName(ContextHolder.get().getAccountName());
						portalNavigate.setUpdateTime(new Date());
						portalNavigate.setRelationId(vo.getRelationId());

						if (portalNavigateService.updateById(portalNavigate)){
							//同时修改国际化对应记录
							InternationalizationVo a = new InternationalizationVo();
							a.setName(vo.getShowName());
							a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
							a.setTaskId(vo.getId());
							internationalizationUtil.updateInternationalization(a);
						}
					}
					if(curFunc==0&&nextFunc==1) {//系统向自定义提供转换
						
						//删除relation_func_code和relation_func_name
						portalNavigateMapper.setCodeAndNameNullById(curId);
						
						portalNavigate.setId(curId);
						portalNavigate.setShowName(vo.getShowName());
						portalNavigate.setRelationFunc(nextFunc);
						//portalNavigateMapper.setImageNullById(curId);
						portalNavigate.setImgPath(vo.getImgPath());
						//portalNavigate.setRelationFuncCode(vo.getRelationFuncCode());
						/*RelationLinkEntityVo relationLink=relationLinkService.getRelationLinkByCode(vo.getRelationFuncCode());
						if(relationLink!=null) {
							portalNavigate.setRelationFuncName(relationLink.getName());
						}*/
						portalNavigate.setRelationFuncUrl(vo.getRelationFuncUrl());
						portalNavigate.setUpdateById(ContextHolder.get().getAccountId());
						portalNavigate.setUpdateByName(ContextHolder.get().getAccountName());
						portalNavigate.setUpdateTime(new Date());
						portalNavigate.setRelationId(vo.getRelationId());

						portalNavigateService.updateById(portalNavigate);
					}
					
                        if(curFunc==1&&nextFunc==0) {//自定义向系统提供转换
						
						//删除relation_func_code和relation_func_name
						portalNavigateMapper.setUrlNullById(curId);
						
						portalNavigate.setId(curId);
						portalNavigate.setShowName(vo.getShowName());
						portalNavigate.setRelationFunc(nextFunc);
						//portalNavigateMapper.setImageNullById(curId);
						portalNavigate.setImgPath(vo.getImgPath());
						
						portalNavigate.setRelationFuncCode(vo.getRelationFuncCode());
//						RelationLinkEntityVo relationLink=relationLinkService.getRelationLinkByCode(vo.getRelationFuncCode());
//						if(relationLink!=null) {
							portalNavigate.setRelationFuncName(vo.getRelationFuncName());
//						}
						
						portalNavigate.setUpdateById(ContextHolder.get().getAccountId());
						portalNavigate.setUpdateByName(ContextHolder.get().getAccountName());
						portalNavigate.setUpdateTime(new Date());
						portalNavigate.setRelationId(vo.getRelationId());

						portalNavigateService.updateById(portalNavigate);
					}
                        
                        if(curFunc==1&&nextFunc==1) {//自定义向自定义提供转换
    						
    						//删除relation_func_code和relation_func_name
    						//portalNavigateMapper.setUrlNullById(curId);
    						
    						portalNavigate.setId(curId);
    						portalNavigate.setShowName(vo.getShowName());
    						//portalNavigate.setRelationFunc(nextFunc);
    						//portalNavigateMapper.setImageNullById(curId);
    						portalNavigate.setImgPath(vo.getImgPath());
    						portalNavigate.setRelationFuncUrl(vo.getRelationFuncUrl());
    						
    						
    						portalNavigate.setUpdateById(ContextHolder.get().getAccountId());
    						portalNavigate.setUpdateByName(ContextHolder.get().getAccountName());
    						portalNavigate.setUpdateTime(new Date());
    						portalNavigate.setRelationId(vo.getRelationId());

    						portalNavigateService.updateById(portalNavigate);
    					}
					
					
				
					//返回信息
						pn.setId(curId);
						pn.setShowName(vo.getShowName());
						return pn;
				
				}
			}	
		}
		return pn;
	}

	@Override
	public List<PortalNavigate> getRelationListLink(Long terminalId, Integer pcType) {
		// TODO Auto-generated method stub
		List<PortalNavigate> list=null;
		Long homeId=portalHomeService.getHomeId(terminalId);
		if(homeId!=null) {
			PortalNavigate portalNavigate=new PortalNavigate();
			portalNavigate.setHomeId(homeId);
			portalNavigate.setState(1);
			portalNavigate.setPcType(pcType);
			EntityWrapper<PortalNavigate> wrapper=new EntityWrapper<PortalNavigate>(portalNavigate);
			wrapper.orderBy("sort", true);
			list=this.selectList(wrapper);
			for(PortalNavigate vo:list) {
                if ("2".equals(vo.getRelationFuncCode())) {
                    if (vo.getRelationId()!=0) {
                        String classifyName = classifyClient.getClassifyName(vo.getRelationId());
                        vo.setClassifyName(classifyName);
                    }
                } else if ("album".equals(vo.getRelationFuncCode())){
                    if (vo.getRelationId()!=0) {
                        String classifyName = albumClassifyClient.getClassifyName(vo.getRelationId());
                        vo.setClassifyName(classifyName);
                    }
                }
            }
		}
		else {
			list=new ArrayList<PortalNavigate>();
		}
		return list;
	}

	@Override
	public Boolean deleteNavigatePc(Long id) {
		// TODO Auto-generated method stub
		PortalNavigate pn=new PortalNavigate();
		pn.setId(id);
		pn.setState(0);
		boolean b = this.updateById(pn);
		if (b){
			//同时删除国际化对应记录
			InternationalizationVo a = new InternationalizationVo();
			a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
			a.setTaskId(id);
			internationalizationUtil.deletedInternationalization(a);
		}
		return b ;
	}

	@Override
	public Boolean navigateUpdateDisplay(Long terminalId, Integer display) {
		// TODO Auto-generated method stub
		PortalNavigate pn=new PortalNavigate();
		Long homeId=portalHomeService.getHomeId(terminalId);
	
		//需求
		pn.setDisplay(display);
		pn.setUpdateById(ContextHolder.get().getAccountId());
		pn.setUpdateByName(ContextHolder.get().getAccountName());
		pn.setUpdateTime(new Date());
		
		//条件
		PortalNavigate pnWrapper=new PortalNavigate();
		pnWrapper.setHomeId(homeId);
		pnWrapper.setPcType(2);
		EntityWrapper<PortalNavigate> wrapper=new EntityWrapper<PortalNavigate>(pnWrapper);
		return this.update(pn, wrapper);
	}

	@Override
	public Boolean updateSortNavigatePc(Long id, Integer isDown) {
		// TODO Auto-generated method stub
		PortalNavigate portalNavigate1=this.selectById(id);
		
		if(portalNavigate1!=null) {
			Long homeId=portalNavigate1.getHomeId();
			Integer curSort=portalNavigate1.getSort();
			Long nextId=portalNavigateMapper.getNextPortalNavigate(homeId, curSort,isDown);
			if(nextId==null) {
				return true;
			}
			else {
				PortalNavigate portalNavigate2=this.selectById(nextId);
				Integer nextSort=portalNavigate2.getSort();
				
				PortalNavigate portalNavigate3=new PortalNavigate();
				portalNavigate3.setId(id);
				portalNavigate3.setSort(nextSort);
				this.updateById(portalNavigate3);
				
				PortalNavigate portalNavigate4=new PortalNavigate();
				portalNavigate4.setId(nextId);
				portalNavigate4.setSort(curSort);
				this.updateById(portalNavigate4);
				return true;
			}
		}
		return null;
	}

	@Override
	public List<ApiPortalPCLink> listApiPortalPCLinkUp(Long siteId, Integer terminalType) {
		// TODO Auto-generated method stub
		 List<ApiPortalPCLink> listApiPortalPCLink=null;
		Long homeId=portalTerminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId, terminalType);
		if(homeId!=null) {
			PortalNavigate portalNavigate=new PortalNavigate();
			portalNavigate.setHomeId(homeId);
			portalNavigate.setSiteId(siteId);
			portalNavigate.setDisplay(1);//显示
			portalNavigate.setState(1);//上架
			portalNavigate.setPcType(1);//上边的链接
			EntityWrapper<PortalNavigate> wrapper=new EntityWrapper<PortalNavigate>(portalNavigate);
			wrapper.orderBy("sort", true);
			List<PortalNavigate> list=this.selectList(wrapper);
			if(CollectionUtils.isNotEmpty(list)) {
				listApiPortalPCLink= new ArrayList<>();
				ApiPortalPCLink apiPortalPCLink=null;
				Map<Long, String> map = null;
				RequestContext context = ContextHolder.get();
				if (StringUtils.isNotBlank(context.getLanguageType())) {
					List<Long> taskIds = list.parallelStream().map(a -> a.getId()).collect(Collectors.toList());
					map = internationalizationUtil.getMap(ClassUtils.getTableName(PortalNavigate.class), taskIds,context.getLanguageType());
				}
				for (PortalNavigate portalNavigate2 : list) {
					apiPortalPCLink=new ApiPortalPCLink();
					apiPortalPCLink.setName(portalNavigate2.getShowName());
					apiPortalPCLink.setRelationFunc(portalNavigate2.getRelationFunc());
					if(portalNavigate2.getRelationFunc()==0) {
						apiPortalPCLink.setRelationFuncCode(portalNavigate2.getRelationFuncCode());
						apiPortalPCLink.setRelationFuncName(portalNavigate2.getRelationFuncName());
					}
					apiPortalPCLink.setRelationFuncUrl(portalNavigate2.getRelationFuncUrl());
					// app by lingye @ 2019-10-13 11:20:29
					apiPortalPCLink.setRelationId(portalNavigate2.getRelationId());
					apiPortalPCLink.setRelationNum(portalNavigate2.getRelationNum());
					if (map != null) {
						String word = map.get(portalNavigate2.getId());
						if (StringUtils.isNotBlank(word)) {
							apiPortalPCLink.setName(word);
						}
					}
					listApiPortalPCLink.add(apiPortalPCLink);
				}
			}
		}
		return listApiPortalPCLink;
	}

	@Override
	public List<ApiPortalPCLink> listApiPortalPCLinkDown(Long siteId, Integer terminalType) {
		// TODO Auto-generated method stub
		 List<ApiPortalPCLink> listApiPortalPCLink=null;
		 Long homeId=portalTerminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId, terminalType);
		 if(homeId!=null) {
				PortalNavigate portalNavigate=new PortalNavigate();
				portalNavigate.setHomeId(homeId);
				portalNavigate.setSiteId(siteId);
				portalNavigate.setDisplay(1);//显示
				portalNavigate.setState(1);//上架
				portalNavigate.setPcType(2);//下边的链接
				EntityWrapper<PortalNavigate> wrapper=new EntityWrapper<PortalNavigate>(portalNavigate);
				wrapper.orderBy("sort", true);
				List<PortalNavigate> list=this.selectList(wrapper);
				
				if(CollectionUtils.isNotEmpty(list)) {
					listApiPortalPCLink=new ArrayList<ApiPortalPCLink>();
					ApiPortalPCLink apiPortalPCLink=null;
					RequestContext context = ContextHolder.get();

					Map<Long, String> map = null;
					if(StringUtils.isNotBlank(context.getLanguageType())){
						List<Long> taskIds = list.parallelStream().map(a -> a.getId()).collect(Collectors.toList());
						map = internationalizationUtil.getMap(ClassUtils.getTableName(PortalNavigate.class), taskIds, context.getLanguageType());
					}
					for (PortalNavigate portalNavigateList :list) {
						apiPortalPCLink=new ApiPortalPCLink();
						apiPortalPCLink.setName(portalNavigateList.getShowName());
						apiPortalPCLink.setRelationFunc(portalNavigateList.getRelationFunc());
						apiPortalPCLink.setRelationFuncCode(portalNavigateList.getRelationFuncCode());
						apiPortalPCLink.setRelationFuncName(portalNavigateList.getRelationFuncName());
						apiPortalPCLink.setRelationFuncUrl(portalNavigateList.getRelationFuncUrl());
						apiPortalPCLink.setImgLogo(portalNavigateList.getImgPath());
						// add by lingye 2019-10-13
						apiPortalPCLink.setRelationId(portalNavigateList.getRelationId());
						apiPortalPCLink.setRelationNum(portalNavigateList.getRelationNum());
						if (map != null) {
							String word = map.get(portalNavigateList.getId());
							if (StringUtils.isNotBlank(word)) {
								apiPortalPCLink.setName(word);
							}
						}
						listApiPortalPCLink.add(apiPortalPCLink);
					}
					return listApiPortalPCLink;
					
				}

	}
		return listApiPortalPCLink;
	}

	@Override
	public Integer navigateViewDisplay(Long terminalId) {
		// TODO Auto-generated method stub
		Long homeId= portalHomeService.getHomeId(terminalId);
		PortalNavigate portalNavigate=new PortalNavigate();
		portalNavigate.setHomeId(homeId);
		portalNavigate.setState(1);
		portalNavigate.setPcType(2);
		portalNavigate.setDisplay(1);
		EntityWrapper<PortalNavigate> wrapper=new EntityWrapper<PortalNavigate>(portalNavigate);
		List<PortalNavigate> list=this.selectList(wrapper);
		if(CollectionUtils.isNotEmpty(list)) {
			return 1;
		}
		
		return 0;
	}


    /**
     * 获取导航列表(只有1:显示的)
     * @param homeId
     * @param display
     * @return
     */
    @Override
    public List<NavigateListVO> getNavigateList(Long homeId, Integer display) {

        PortalNavigate portalNavigate = new PortalNavigate();
        portalNavigate.setHomeId(homeId);
        portalNavigate.setState(SiteConstant.FIRST);
        //学员端 导航栏 显示 与 不显示
        if(display == 1){
            portalNavigate.setDisplay(SiteConstant.FIRST);
        }
        EntityWrapper<PortalNavigate> wrapper = QueryUtil.condition(portalNavigate);
        wrapper.orderBy("sort",true);
        List<PortalNavigate> portalNavigateList = this.selectList(wrapper);
        // 初始化代码
        List<NavigateListVO> navigateListVOList = new ArrayList<NavigateListVO>();
        NavigateListVO vo = null;
        for(PortalNavigate pn : portalNavigateList){
            vo = new NavigateListVO();
            BeanUtils.copyProperties(pn, vo, "createById", "createByName", "updateTime", "updateById", "updateByName");
            // modify by lilingye @2018-7-5 10:37:27
            if ("album".equals(pn.getRelationFuncCode())) {
                if (pn.getRelationId()!=0) {
                    String classifyName = albumClassifyClient.getClassifyName(pn.getRelationId());
                    vo.setClassifyName(classifyName);
                }
            } else {
                // 课程
                if (pn.getRelationId()!=0) {
                    String classifyName = classifyClient.getClassifyName(pn.getRelationId());
                    vo.setClassifyName(classifyName);
                }
            }
            vo.setType(SiteEnum.getValueByKey(pn.getRelationFuncName()));
            vo.setCatname(pn.getRelationFuncName());
            vo.setKind(SiteEnum.LIST.getValue());
            navigateListVOList.add(vo);
        }
        return navigateListVOList;
    }

	/**
	 * 获取全部导航列表(0:不显示的,1:显示的)
	 * @param homeId
	 * @return
	 */
	@Override
	public List<NavigateListVO> getNavigateList(Long homeId) {
    	PortalNavigate portalNavigate = new PortalNavigate();
		portalNavigate.setHomeId(homeId);
		portalNavigate.setState(SiteConstant.FIRST);
		EntityWrapper<PortalNavigate> wrapper = QueryUtil.condition(portalNavigate);
		wrapper.orderBy("sort",true);
		List<PortalNavigate> portalNavigateList = this.selectList(wrapper);
		// 初始化代码
		List<NavigateListVO> navigateListVOList = new ArrayList<NavigateListVO>();
		NavigateListVO vo = null;
		for(PortalNavigate pn : portalNavigateList){
			vo = new NavigateListVO();
			BeanUtils.copyProperties(pn, vo, "createById", "createByName", "updateTime", "updateById", "updateByName");
			// modify by lilingye @2018-7-5 10:37:27
			if ("album".equals(pn.getRelationFuncCode())) {
				if (pn.getRelationId()!=0) {
					String classifyName = albumClassifyClient.getClassifyName(pn.getRelationId());
					vo.setClassifyName(classifyName);
				}
			} else {
				// 课程
				if (pn.getRelationId()!=0) {
					String classifyName = classifyClient.getClassifyName(pn.getRelationId());
					vo.setClassifyName(classifyName);
				}
			}
			vo.setType(SiteEnum.getValueByKey(pn.getRelationFuncName()));
			vo.setCatname(pn.getRelationFuncName());
			vo.setKind(SiteEnum.LIST.getValue());
			navigateListVOList.add(vo);
		}
		return navigateListVOList;
	}

	/**
	 * 获取
	 * @param siteId 站点id
	 * @param relationId 关联id
	 * @return
	 */
    @Override
    public List<PortalNavigate> getNavigateListByRelationId(Long siteId,Long relationId) {
		PortalNavigate portalNavigate = new PortalNavigate();
		portalNavigate.setSiteId(siteId);
		portalNavigate.setState(SiteConstant.FIRST);
		portalNavigate.setRelationId(relationId);
		return this.selectList(QueryUtil.condition(portalNavigate));
    }
}
