package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.HomePageCoursePageVo;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.constant.SiteEnum;
import com.yizhi.site.application.domain.PortalHome;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.domain.TemplateCourse;
import com.yizhi.site.application.enums.PortalEnum;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.site.application.mapper.PortalTemplateMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.mapper.ProtalPlateMapper;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.service.PortalTemplateService;
import com.yizhi.site.application.service.ProtalPlateService;
import com.yizhi.site.application.service.TemplateCourseService;
import com.yizhi.site.application.vo.domain.PortalTemplateVo;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.enums.TerminalType;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import com.yizhi.system.application.vo.domain.Internationalization;
import com.yizhi.wechat.application.vo.wechat.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
public class PortalTemplateServiceImpl extends ServiceImpl<PortalTemplateMapper, PortalTemplate> implements PortalTemplateService {
    private static final Logger log = LoggerFactory.getLogger(PortalTemplateServiceImpl.class);
	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private PortalTemplateMapper portalTemplateMapper;
	@Autowired
	private ProtalPlateService protalPlateService;
	@Autowired
	private TemplateCourseService templateCourseService;
	@Autowired
	CourseClient courseClient;
	@Autowired
	private ProtalPlateMapper protalPlateMapper;
	@Autowired
	private PortalTerminalMapper portalTerminalMapper;
	@Autowired
	private PortalHomeService portalHomeService;
	@Autowired
	private InternationalizationUtil internationalizationUtil;
    @Autowired
    private TaskExecutor taskExecutor;

	@Override
	public List<TemplateListVO> templateList(Long homeId) {
		List<TemplateListVO> list = new ArrayList<TemplateListVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		List<PortalTemplate> selectByMap = this.selectByMap(map);
		TemplateListVO templateListVO = null;
		for(PortalTemplate pt : selectByMap){
			templateListVO = new TemplateListVO();
			BeanUtils.copyProperties(pt, templateListVO, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
			templateListVO.setPlateList(plateList(pt.getId()));
			templateListVO.setCourseList(courseList(pt.getId()));
//			templateListVO.setPopularCourseList(courseList(pt.getId()));
			list.add(templateListVO);
		}

		return list;
	}

	private List<PopCourseListVO> courseList(Long templateId) {
		List<PopCourseListVO> list = new ArrayList<PopCourseListVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		List<TemplateCourse> selectByMap = templateCourseService.selectByMap(map);
		PopCourseListVO vo = null;
		for(TemplateCourse tc : selectByMap){
			vo = new PopCourseListVO();
			vo.setId(tc.getId());
			vo.setDisplay(tc.getDisplay());
			vo.setName(tc.getName());
			list.add(vo);
		}
		return list;
	}

	private List<PlateListVO> plateList(Long templateId) {
		List<PlateListVO> list = new ArrayList<PlateListVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		List<ProtalPlate> selectByMap = protalPlateService.selectByMap(map);
		PlateListVO vo = null;
		for(ProtalPlate pp : selectByMap){
			vo = new PlateListVO();
//			BeanUtils.copyProperties(pp, vo, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
            Long courseId = null;
            HomePageCoursePageVo homePageCoursePageVo= null;
			if (pp.getLinkContent()!=null) {
                try {
                    courseId = pp.getLinkContent();
                    log.info("课程id："+courseId);
                    vo.setLinkContent(courseId);
                    homePageCoursePageVo= courseClient.getManageCourseList(courseId,ContextHolder.get().getCompanyId(),ContextHolder.get().getSiteId());
                    log.info("返回的实体的:"+homePageCoursePageVo);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (homePageCoursePageVo!=null) {

                vo.setScore(homePageCoursePageVo.getLevel().toString());
                vo.setStudyNo(homePageCoursePageVo.getViewCount().longValue());
                vo.setViewCount(homePageCoursePageVo.getViewCount().intValue());
            }
            vo.setLinkContentName(pp.getLinkContentName());
            vo.setImgPath(pp.getImgPath());
            vo.setId(pp.getId());
            vo.setTemplateId(pp.getTemplateId());
            vo.setCourseNo(pp.getCourseNo());
            vo.setThumbnail(pp.getThumbnail());
            vo.setState(pp.getState());

			list.add(vo);
		}

		return list;
	}

	@Override
	public boolean copyTemplate(Long sourceId, Long targetId) {
		List<PortalTemplate> list = new ArrayList<PortalTemplate>();
		List<ProtalPlate> plateList = new ArrayList<ProtalPlate>();
		List<TemplateCourse> courseList = new ArrayList<TemplateCourse>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", sourceId);
		map.put("state", SiteConstant.FIRST);
		List<PortalTemplate> selectByMap = this.selectByMap(map);
		PortalTemplate p = null;
		ProtalPlate plate = null;
		TemplateCourse tc = null;
		for(PortalTemplate pt : selectByMap){
			p = new PortalTemplate();
			Long tempId = idGenerator.generate();
			BeanUtils.copyProperties(pt, p);
			p.setId(tempId);
			p.setHomeId(targetId);
			list.add(p);
			
			Map<String, Object> map1 = new HashMap<String, Object>();
			map1.put("template_id", pt.getId());
			map1.put("state", SiteConstant.FIRST);
			List<ProtalPlate> selectByMap2 = protalPlateService.selectByMap(map1);
			for(ProtalPlate pp : selectByMap2){
				plate = new ProtalPlate();
				BeanUtils.copyProperties(pp, plate);
				plate.setId(idGenerator.generate());
				plate.setTemplateId(tempId);
				plateList.add(plate);
			}
			
			List<TemplateCourse> selectByMap3 = templateCourseService.selectByMap(map1);
			for(TemplateCourse tt : selectByMap3){
				tc = new TemplateCourse();
				BeanUtils.copyProperties(tt, tc);
				tc.setId(idGenerator.generate());
				tc.setTemplateId(tempId);
				courseList.add(tc);
			}
		}
		if(list.size() > 0){
			this.insertBatch(list);
		}
		if(plateList.size() > 0){
			protalPlateService.insertBatch(plateList);
		}
		if(courseList.size() > 0){
			templateCourseService.insertBatch(courseList);
		}
		return true;
	}

	@Override
	public List<ApiTemplateMiddlerVO> templateApiList(Long homeId) {
		List<ApiTemplateMiddlerVO> list = new ArrayList<ApiTemplateMiddlerVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		List<PortalTemplate> selectByMap = this.selectByMap(map);
		selectByMap.sort((PortalTemplate p1, PortalTemplate p2) -> p1.getModuleType().compareTo(p2.getModuleType()));
		ApiTemplateMiddlerVO vo = null;
		List<TemplateNewsVO> newsList = null;
		for(PortalTemplate pt : selectByMap){
			newsList = portalTemplateMapper.listSelectedNews(pt.getId());
			for(TemplateNewsVO tn : newsList){
				tn.setKind(SiteEnum.DETAIL.getValue());
				tn.setType(SiteEnum.NEWS.getValue());
			}
			Map<String, Object> map1 = new HashMap<String, Object>();
			map1.put("template_id", pt.getId());
			map1.put("state", SiteConstant.FIRST);
			List<ProtalPlate> ppList = protalPlateService.selectByMap(map1);
			List<ProtalPlateVo> selectVoByMap=new ArrayList<>();
			for (ProtalPlate d:ppList) {
				ProtalPlateVo entityVo=new ProtalPlateVo();
				BeanUtils.copyProperties(d,entityVo);
				selectVoByMap.add(entityVo);
			}
			PortalTemplateVo pte=new PortalTemplateVo();
			BeanUtils.copyProperties(pt,pte);
			vo = new ApiTemplateMiddlerVO();

			vo.setPortalTemplate(pte);
			vo.setNewsList(newsList);
			vo.setPpList(selectVoByMap);
			vo.setPopularCourseList(courseList(pt.getId()));
			list.add(vo);
		}
		return list;
	}
	
	
	
	
	@Override
	public List<PortalTemplate> moduleListSelect(Long terminalId) {
		// TODO Auto-generated method stub
		Long homeId=portalHomeService.getHomeId(terminalId);
		PortalTemplate portalTemplate=new PortalTemplate();
		portalTemplate.setHomeId(homeId);
		portalTemplate.setState(1);//只要未删除的
		EntityWrapper<PortalTemplate> wrapper=new EntityWrapper<PortalTemplate>(portalTemplate);
		wrapper.orderBy("sort", true);
		return this.selectList(wrapper);
	}
	

	@Override
	public PortalTemplate moduleNameAdd(Long terminalId,Long currentId,Integer isDown, Integer moduleType, String moduleName) {
	    Long homeId=portalHomeService.getHomeId(terminalId);
		//初始化状态  sort默认为1
		if(currentId==null) {
			Long id=idGenerator.generate();
			PortalTemplate portalTemplate=new PortalTemplate();
			portalTemplate.setId(id);
			portalTemplate.setHomeId(homeId);
			portalTemplate.setSiteId(ContextHolder.get().getSiteId());
			portalTemplate.setModuleType(moduleType);
			portalTemplate.setModuleName(moduleName);
			portalTemplate.setState(1);
			portalTemplate.setSort(1);
			portalTemplate.setDisplay(1);//显示
			portalTemplate.setCreateById(ContextHolder.get().getAccountId());
			portalTemplate.setCreateByName(ContextHolder.get().getAccountName());
			portalTemplate.setCreateTime(new Date());
            boolean insert = this.insert(portalTemplate);
            if (insert) {
			    if(moduleType == PortalEnum.NINE.ordinal()){
			        log.info("进入新增模板");
			        addPlate(id,ContextHolder.get().getAccountId(),ContextHolder.get().getAccountName());
                }

				//同时添加国际化记录
//				Internationalization a = new Internationalization();
//				a.setName(portalTemplate.getModuleName());
//				a.setModuleName(ModuleType.PORTAL.getName());
//				a.setModuleType(ModuleType.PORTAL.getCode());
//				a.setTableType(ClassUtils.getTableName(PortalTemplateEntityVo.class));
//				a.setTaskId(id);
//				a.setTerminalType(TerminalType.PC.getCode());
//				internationalizationUtil.addInternationalization(a);
                taskExecutor.asynExecute(new AbstractTaskHandler() {
                    @Override
                    public void handle() {
                        internationalizationUtil.addInternationalizationList(portalTemplate);
                    }
                });

			}
			
			return portalTemplate;
		}
		//根据homeId 找到 最大的排序
		/*Integer maxSort=portalTemplateMapper.getMaxSortByHomeId(homeId);
		if(maxSort==null) {
			maxSort=1;
		}
		else {
			maxSort++;
		}*/
		else {
			//先更新  其他的排序  再中间添加
			PortalTemplate portalTemplate1=this.selectById(currentId);
			if(portalTemplate1!=null) {
				Integer curSort=portalTemplate1.getSort();
				Long id=idGenerator.generate();
				PortalTemplate portalTemplate=new PortalTemplate();
				portalTemplate.setId(id);
				portalTemplate.setHomeId(homeId);
				portalTemplate.setSiteId(ContextHolder.get().getSiteId());
				portalTemplate.setModuleType(moduleType);
				portalTemplate.setModuleName(moduleName);
				portalTemplate.setState(1);
				if(isDown==0) {//更新下方的
					portalTemplateMapper.updateSortBitch(homeId, curSort, isDown);
					portalTemplate.setSort(curSort+1);
				}
				if(isDown==1) {//更新带着自己的下方
					portalTemplateMapper.updateSortBitch(homeId, curSort,isDown);	
					portalTemplate.setSort(curSort);
				}
				portalTemplate.setDisplay(1);//显示
				portalTemplate.setCreateById(ContextHolder.get().getAccountId());
				portalTemplate.setCreateByName(ContextHolder.get().getAccountName());
				portalTemplate.setCreateTime(new Date());
				if (this.insert(portalTemplate)) {
                    if(moduleType == PortalEnum.NINE.ordinal()){
                        log.info("进入新增模板");
                        addPlate(id,ContextHolder.get().getAccountId(),ContextHolder.get().getAccountName());
                    }

                    //同时添加国际化记录
					Internationalization a = new Internationalization();
					a.setName(portalTemplate.getModuleName());
					a.setModuleName(ModuleType.PORTAL.getName());
					a.setModuleType(ModuleType.PORTAL.getCode());
					a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
					a.setTaskId(id);
					a.setTerminalType(TerminalType.PC.getCode());
					internationalizationUtil.addInternationalization(a);
				}
				return portalTemplate;	
			}
		}
		return null;
	}

	public ProtalPlate addPlate(Long templateId,Long accountId,String accountName){
      ProtalPlate  protalPlate=new ProtalPlate();

        protalPlate.setId(idGenerator.generate());
        protalPlate.setTemplateId(templateId);
        protalPlate.setImgPath("https://customproject.oss-cn-shanghai.aliyuncs.com/web_image/admin/luntanTripleWidth.png");
        protalPlate.setState(1);
        protalPlate.setSort(1);
        protalPlate.setThumbnail(2);
        protalPlate.setCreateById(accountId);
        protalPlate.setCreateByName(accountName);
        protalPlate.setCreateTime(new Date());

        boolean insertResult = protalPlateService.insert(protalPlate);
        log.info("返回结果："+insertResult);
        return protalPlate;
    }

	@Override
	public Boolean moduleUpdateMessage(Long id, String name, Integer state,Integer display,Integer isDown) {
		// TODO Auto-generated method stub
		if(isDown==null) {
			Date updateDate=new Date();
			PortalTemplate portalTemplate=new PortalTemplate();
			portalTemplate.setId(id);
			if(name!=null) {
				portalTemplate.setModuleName(name);
			}
			if(state!=null&&state==0) {
				//内容删除
				portalTemplate.setState(state);   //模板信息 删除，
				Long templateId=id;
				Long accountId=ContextHolder.get().getAccountId();
				String accountName=ContextHolder.get().getAccountName();
				//删除模板内容（活动）
				protalPlateMapper.updateStateByTemplateId(templateId, accountId, accountName, updateDate);
			}
			if(display!=null) {
				portalTemplate.setDisplay(display);
			}
			portalTemplate.setUpdateById(ContextHolder.get().getAccountId());
			portalTemplate.setUpdateByName(ContextHolder.get().getAccountName());
			portalTemplate.setUpdateTime(updateDate);
			if (this.updateById(portalTemplate)) {
				InternationalizationVo a = new InternationalizationVo();
				a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
				a.setTaskId(id);
				if (state != null && state == 0) {
					//同时删除国际化对应记录
					internationalizationUtil.deletedInternationalization(a);
				} else {
					//同时修改国际化对应记录
					a.setName(name);
					internationalizationUtil.updateInternationalization(a);
				}
			}
		}
		else {
			PortalTemplate portalTemplate =this.selectById(id);
			Long homeId=null;
			Integer curSort=portalTemplate.getSort();
			if(portalTemplate!=null) {
				homeId=portalTemplate.getHomeId();
			}
			Long targetId= portalTemplateMapper.getTemplateId(homeId, isDown, curSort);
			if(targetId!=null) {
				moduleUpdateSort(id, targetId);
			}
		}
		return  true;
	}

	@Override
	public Boolean moduleUpdateSort(Long sourceId, Long targetId) {
		// TODO Auto-generated method stub
		
		Date date=new Date();
		PortalTemplate portalTemplateSource=this.selectById(sourceId);
		PortalTemplate portalTemplateTarget=this.selectById(targetId);

		Integer sourceSort=portalTemplateSource.getSort();
		Integer targetSort=portalTemplateTarget.getSort();
		
		portalTemplateSource.setSort(targetSort);
		portalTemplateSource.setUpdateById(ContextHolder.get().getAccountId());
		portalTemplateSource.setUpdateByName(ContextHolder.get().getAccountName());
		portalTemplateSource.setUpdateTime(date);
		
		portalTemplateTarget.setSort(sourceSort);
		portalTemplateTarget.setUpdateById(ContextHolder.get().getAccountId());
		portalTemplateTarget.setUpdateByName(ContextHolder.get().getAccountName());
		portalTemplateTarget.setUpdateTime(date);
		
		this.updateById(portalTemplateSource);
		this.updateById(portalTemplateTarget);
		return true;
	}

	@Override
	public PortalTemplateTraining templateContentSelectContentView(Long id) {
		// TODO Auto-generated method stub
		PortalTemplate  portalTemplate=this.selectById(id);
		PortalTemplateTraining portalTemplateTraining=null;
		if(portalTemplate!=null) {
			portalTemplateTraining=new PortalTemplateTraining();
			portalTemplateTraining.setId(portalTemplate.getId());
			if(portalTemplate.getSelectProject()!=null) {
				portalTemplateTraining.setSelectProject(Long.parseLong(portalTemplate.getSelectProject()));
			}
			
			portalTemplateTraining.setNum(portalTemplate.getNum());
			List<ProtalPlate> listProtalPlate=protalPlateService.templateContentViewApi(id);
			List<ProtalPlateVo> selectVoByMap=new ArrayList<>();
			for (ProtalPlate d:listProtalPlate) {
				ProtalPlateVo entityVo=new ProtalPlateVo();
				BeanUtils.copyProperties(d,entityVo);
				selectVoByMap.add(entityVo);
			}
			portalTemplateTraining.setListProtalPlate(selectVoByMap);
			
		}
		return portalTemplateTraining;
	}

	@Override
	public List<PortalTemplate> moduleListSelectApi(Long siteId, Integer terminalType) {
		Long homeId=portalTerminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId, terminalType);
		if(homeId!=null) {
			PortalTemplate portalTemplate=new PortalTemplate();
			portalTemplate.setHomeId(homeId);
			portalTemplate.setState(1);//只要未删除的
			portalTemplate.setDisplay(1);//要显示的
			EntityWrapper<PortalTemplate> wrapper=new EntityWrapper<PortalTemplate>(portalTemplate);
			wrapper.orderBy("sort", true);
			List<PortalTemplate> portalTemplates = this.selectList(wrapper);
			if (CollectionUtils.isNotEmpty(portalTemplates)) {
				RequestContext context = ContextHolder.get();
				Map<Long, String> map = new HashMap<>();
				if (StringUtils.isNotBlank(context.getLanguageType())) {
					List<Long> taskIds = portalTemplates.parallelStream().map(a -> a.getId()).collect(Collectors.toList());
					map = internationalizationUtil.getMap(ClassUtils.getTableName(PortalTemplate.class), taskIds, context.getLanguageType());
				}
				if (map != null) {
					String word = "";
					for (PortalTemplate a : portalTemplates) {
						word = map.get(a.getId());
						if (StringUtils.isNotBlank(word)) {
							a.setModuleName(word);
						}
					}
				}
			}
			return portalTemplates;
	}
		return null;
	}

    @Override
    public List<PortalTemplate> getManageModuleList(Long terminalId) {
        PortalHome portalHome = new PortalHome();
        portalHome.setTerminalId(terminalId);
        Long homeId = null;

            try {
                homeId = portalHomeService.selectOne(QueryUtil.condition(portalHome)).getId();
            } catch (Exception e) {
                e.printStackTrace();
            }
            PortalTemplate portalTemplate=new PortalTemplate();
            portalTemplate.setHomeId(homeId);
            portalTemplate.setState( Constants.YES_FLAG);
            portalTemplate.setDisplay(Constants.YES_FLAG);
            EntityWrapper<PortalTemplate> wrapper=new EntityWrapper<PortalTemplate>(portalTemplate);
            wrapper.orderBy("sort", true);
            return this.selectList(wrapper);


    }

    @Override
    public Boolean sortTemplate(Long sourceId, Long targetId) {

        PortalTemplate portalTemplate = this.selectById(sourceId);
        Long sourceHomeId = portalTemplate.getHomeId();
	    Integer sourceSort = portalTemplate.getSort();

        portalTemplate = this.selectById(targetId);
        Long targetHomeId = portalTemplate.getHomeId();
        Integer targetSort = portalTemplate.getSort();
        if (!sourceHomeId.equals(targetHomeId)){
            log.info("homeId相同");
            return false;
        }

        List<PortalTemplate> portalTemplateList = this.getPortalImageList(sourceHomeId, sourceSort, targetSort);

        log.info("获取的导航的个数：" + portalTemplateList.size());
        log.info("操作前的列表：" + portalTemplateList);

        List<PortalTemplate> moduleList = new ArrayList<PortalTemplate>();
        for (PortalTemplate template : portalTemplateList) {

            if (targetSort > sourceSort) {
                if (template.getId().equals(sourceId)) {
                    template.setSort(targetSort);
                } else {
                    template.setSort(template.getSort() - 1);
                }

            } else {
                if (template.getId().equals(sourceId)) {
                    template.setSort(targetSort);
                } else {
                    template.setSort(template.getSort() + 1);
                }
            }
            moduleList.add(template);
        }
        log.info("操作后的列表：" + moduleList);
        // 批量修改顺序
        if (CollectionUtils.isNotEmpty(moduleList)) {
            log.info("执行批量修改.");
            this.updateBatchById(moduleList);
        }

        return true;
    }

    @Override
    public Boolean sortTemplate(Long sourceId, Integer type) {


        PortalTemplate template = new PortalTemplate();
        template.setHomeId(this.selectById(sourceId).getHomeId());
        template.setDisplay(Constants.YES_FLAG);
        EntityWrapper<PortalTemplate> condition = QueryUtil.condition(template);
        condition.orderBy("sort",true);
        List<PortalTemplate> portalTemplates = this.selectList(condition);


        // 向上移动
        try {
            List<PortalTemplate> templates = new ArrayList<PortalTemplate>(8);
            if (type==Constants.DEL_FLAG) {
                for (int i=0;i<portalTemplates.size();i++){

                    PortalTemplate p = portalTemplates.get(i);
                    Integer sourceSort = p.getSort();
                    if (sourceId.equals(p.getId())){

                        p.setSort(portalTemplates.get(i-1).getSort());
                        templates.add(p);
                        PortalTemplate pt = portalTemplates.get(i-1);
                        pt.setSort(sourceSort);
                        templates.add(pt);
                        this.updateBatchById(templates);
                        break;
                    }
                }
            } else if (type==Constants.YES_FLAG){

                for (int i=0;i<portalTemplates.size();i++){

                        PortalTemplate p = portalTemplates.get(i);
                        Integer sourceSort = p.getSort();
                        if (sourceId.equals(p.getId())){

                            p.setSort(portalTemplates.get(i+1).getSort());
                            templates.add(p);
                            PortalTemplate pt = portalTemplates.get(i+1);
                            pt.setSort(sourceSort);
                            templates.add(pt);
                            this.updateBatchById(templates);
                            break;
                        }
                    }
            }
            return true;
        } catch (Exception e) {
            log.info("返回："+e);
            return false;
        }
    }

    @Override
    public PortalTemplate getTemplateById(Long id) {
        return this.selectById(id);
    }


    /**
     * 获取对应列表
     * @param homeId
     * @param sourceSort
     * @param targetSort
     * @return
     */
    public List<PortalTemplate> getPortalImageList(Long homeId, Integer sourceSort, Integer targetSort) {

        PortalTemplate portalTemplate = new PortalTemplate();
        portalTemplate.setHomeId(homeId);
        portalTemplate.setState(SiteConstant.FIRST);
        EntityWrapper<PortalTemplate> wrapper = QueryUtil.condition(portalTemplate);
        if (targetSort<sourceSort) {
            wrapper.where("sort <= {0}",sourceSort).andNew("sort >= {0}",targetSort);
        } else {
            wrapper.where("sort <=  {0}",targetSort).andNew("sort >= {0}",sourceSort);
        }
        wrapper.orderBy("sort",true);
        List<PortalTemplate> list = this.selectList(wrapper);

        return list;
    }


}
