package com.yizhi.site.application.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.site.application.domain.ProtalContact;
import com.yizhi.site.application.mapper.ProtalContactMapper;
import com.yizhi.site.application.constant.SiteConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.ProtalContactService;
import com.yizhi.site.application.vo.site.PreviewContactVO;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
public class ProtalContactServiceImpl extends ServiceImpl<ProtalContactMapper, ProtalContact> implements ProtalContactService {
	
	@Autowired
	private IdGenerator idGenerator;

	@Override
	public List<PreviewContactVO> contactList(Long homeId) {
		List<PreviewContactVO> voList = new ArrayList<PreviewContactVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		List<ProtalContact> selectByMap = this.selectByMap(map);
		PreviewContactVO vo = null;
		for(ProtalContact pc : selectByMap){
			vo = new PreviewContactVO();
			BeanUtils.copyProperties(pc, vo, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
			voList.add(vo);
		}
		return voList;
	}

	@Override
	public boolean copyContact(Long sourceId, Long targetId) {
		List<ProtalContact> list = new ArrayList<ProtalContact>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", sourceId);
		map.put("state", SiteConstant.FIRST);
		List<ProtalContact> selectByMap = this.selectByMap(map);
		ProtalContact p = null;
		for(ProtalContact pc : selectByMap){
			p = new ProtalContact();
			BeanUtils.copyProperties(pc, p);
			p.setId(idGenerator.generate());
			p.setHomeId(targetId);
			list.add(p);
		}
		if(list.size() > 0){
			this.insertBatch(list);
		}
		return true;
	}

}
