package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.SiteConfig;
import com.yizhi.site.application.mapper.SiteConfigMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ISiteConfigService;
import com.yizhi.site.application.vo.site.SiteConfigVO;
import com.yizhi.site.application.vo.site.SystemSiteVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * <p>
 * 站点网页名称图片 服务实现类
 * </p>
 *
 * @author lilingye
 * @since 2019-07-05
 */
@Service
public class SiteConfigServiceImpl extends ServiceImpl<SiteConfigMapper, SiteConfig> implements ISiteConfigService {
    @Autowired
    IdGenerator idGenerator;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SiteConfigVO update(SiteConfigVO siteConfigVO) {
        RequestContext context = ContextHolder.get();

//        Long id = idGenerator.generate();
//        siteConfigVO.setId(id);
        SiteConfig siteConfig = new SiteConfig();
        BeanUtils.copyProperties(siteConfigVO, siteConfig);
        siteConfig.setUpdateTime(new Date());
        siteConfig.setCompanyId(context.getCompanyId());
        siteConfig.setSiteId(context.getSiteId());
        siteConfig.setUpdateById(context.getAccountId());

        this.updateById(siteConfig);
        return siteConfigVO;
    }

    @Override
    public SiteConfig get(SystemSiteVO siteVO) {
        SiteConfig siteConfig = new SiteConfig();
        siteConfig.setSiteId(siteVO.getId());
        siteConfig.setCompanyId(siteVO.getCompanyId());
        SiteConfig config = this.selectOne(QueryUtil.condition(siteConfig));

        if (config != null) {
            return config;
        } else {
            // 获取默认图片
            String headIco = this.selectById(1L).getHeadIco();
            siteConfig.setHeadIco(headIco!=null?headIco:"");
            siteConfig.setTitleName(siteVO.getName());
            siteConfig.setCreateById(siteVO.getAdminAccountId());
            siteConfig.setUpdateById(siteVO.getAdminAccountId());
            siteConfig.setId(idGenerator.generate());
            this.insert(siteConfig);

            return siteConfig;
        }
    }
}
