package com.yizhi.site.application.service.impl;

import java.util.Date;
import java.util.List;

import com.yizhi.site.application.domain.TrSearchRecorde;
import com.yizhi.site.application.mapper.TrSearchRecordemapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.TrSearchRecordeService;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author 王飞达
 * @since 2019-07-29
 */
@Service
public class TrSearchRecordeServiceImple extends ServiceImpl<TrSearchRecordemapper, TrSearchRecorde> implements TrSearchRecordeService {

	@Autowired
	private IdGenerator idGenerator;
	
	@Autowired
	TrSearchRecordemapper searchRecordemapper;
	
	@Override
	public List<String> getSearchRecorde(TrSearchRecorde trSearchRecorde) {
		// TODO Auto-generated method stub
		return searchRecordemapper.getSearchRecorde(trSearchRecorde);
	}

	@Override
	public Boolean insertTrSearchRecorde(TrSearchRecorde trSearchRecorde) {
		// TODO Auto-generated method stub
		//先判断是否存在（已经去除空格了）
		TrSearchRecorde trSearchRecordeSelect=this.selectOne(new EntityWrapper<TrSearchRecorde>(trSearchRecorde));
		//如果不存在，插入
		if(trSearchRecordeSelect==null) {
			trSearchRecorde.setId(idGenerator.generate());
			trSearchRecorde.setDeleted(0);//未删除
			trSearchRecorde.setCreateById(trSearchRecorde.getAccountId());
			trSearchRecorde.setCreateTime(new Date());
			
			
			return this.insert(trSearchRecorde);
		}
		else {
			//如果存在则不插入，更新现在词条的创建时间（提词到第一的位置）。
			Long id=trSearchRecordeSelect.getId();
			TrSearchRecorde trSearchRecordeUpdate=new TrSearchRecorde();
			trSearchRecordeUpdate.setId(id);
			trSearchRecordeUpdate.setDeleted(0);
			trSearchRecordeUpdate.setCreateTime(new Date());
			this.updateById(trSearchRecordeUpdate);
			return true;
		}
		
	}

	@Override
	public Boolean deleteTrSearchRecorde(TrSearchRecorde trSearchRecorde) {
		// TODO Auto-generated method stub
		searchRecordemapper.deleteSearchRecorde(trSearchRecorde);
		return true;
	}

}
