package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.site.application.domain.TrSiteStudent;
import com.yizhi.site.application.mapper.TrSiteStudentMapper;
import com.yizhi.site.application.service.ITrSiteStudentService;
import com.yizhi.site.application.vo.site.TrSitePageVO;
import com.yizhi.site.application.vo.site.TrSiteStudentParamsVo;
import com.yizhi.site.application.vo.site.TrSiteStudentVo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>
 * 专区（子站点）配置表 服务实现类
 * </p>
 *
 * @author taoge123
 * @since 2020-09-14
 */
@Service
public class TrSiteStudentServiceImpl extends ServiceImpl<TrSiteStudentMapper, TrSiteStudent> implements ITrSiteStudentService {

    @Autowired
    private IdGenerator idGenerator;

    private RedisCache redisCache;
    @Autowired
    private DomainConverter converter;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ITrSiteStudentService trSiteStudentService;
    @Autowired
    private TrSiteStudentMapper trSiteStudentMapper;
    //排序间隔
    private final Integer SORT_SPACE = 4;

    //上移
    private final static Integer MOVE_UP = 1;
    //下移
    private final static Integer MOVE_DOWN = 2;

    private static Logger logger = LoggerFactory.getLogger(TrSiteStudentServiceImpl.class);


    @Override
    public Integer save(List<TrSiteStudentVo> vos) {

        if (CollectionUtils.isNotEmpty(vos)) {

            List<TrSiteStudent> trSiteStudents = new ArrayList<>(vos.size());
            RequestContext context = ContextHolder.get();
            Date date = new Date();
            //获取最大的sort
            Integer sort = trSiteStudentMapper.getSort(context.getSiteId(), context.getCompanyId());
            AtomicInteger integer = new AtomicInteger(sort == null ? 0 : sort);

            for (TrSiteStudentVo a : vos) {
                TrSiteStudent siteRecord = new TrSiteStudent();
                BeanUtils.copyProperties(a,siteRecord);
                siteRecord.setId(idGenerator.generate());
                siteRecord.setDeleted(0);
                siteRecord.setCompanyId(context.getCompanyId());
                siteRecord.setSiteId(context.getSiteId());
                siteRecord.setCreateById(context.getAccountId());
                siteRecord.setCreateByName(context.getAccountName());
                siteRecord.setCreateTime(date);
                siteRecord.setSort(integer.addAndGet(SORT_SPACE));
                trSiteStudents.add(siteRecord);
            }
            if (CollectionUtils.isNotEmpty(trSiteStudents)) {
                return trSiteStudentService.insertBatch(trSiteStudents) ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public Page getPage(TrSitePageVO trSitePageVO, Page page) {
        TrSiteStudent trSiteStudent = new TrSiteStudent();
        trSiteStudent.setDeleted(0);
        trSiteStudent.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper wrapper = new EntityWrapper(trSiteStudent);
        wrapper.orderBy("sort", false).orderBy("create_time", false);
        return this.selectPage(page, wrapper);
    }

    @Override
    public Integer remove(Long id) {
        TrSiteStudent trSiteStudent = new TrSiteStudent();
        trSiteStudent.setDeleted(1);
        trSiteStudent.setId(id);
        return this.updateById(trSiteStudent) ? 1 : 0;
    }

    @Override
    @Transactional(noRollbackFor = Exception.class)
    public TrSiteStudentParamsVo move(TrSiteStudentParamsVo paramsVo) {
        RequestContext context = ContextHolder.get();

        TrSiteStudent originTrSiteStudent = this.baseMapper.selectById(paramsVo.getId());

        if (originTrSiteStudent == null) {
            paramsVo.setErrorMsg("未找到数据！");
            return paramsVo;
        } else {
            //原值
            Integer originSort = originTrSiteStudent.getSort();
            //获取目标值
            TrSiteStudent targetRelation;
            //是否上移
            if (paramsVo.getMoveUp()) {
                targetRelation = this.baseMapper.queryBySort(originSort, MOVE_UP, context.getCompanyId(), context.getSiteId());
                if (targetRelation == null){
                    paramsVo.setErrorMsg("到顶啦！");
                }
            } else {
                targetRelation = this.baseMapper.queryBySort(originSort, MOVE_DOWN, context.getCompanyId(), context.getSiteId());
                if (targetRelation == null){
                    paramsVo.setErrorMsg("到底啦！");
                }
            }
            if (targetRelation != null) {
                Integer targetSort = targetRelation.getSort();
                originTrSiteStudent.setSort(targetSort);
                targetRelation.setSort(originSort);
                try {
                    Integer tem = this.baseMapper.updateById(originTrSiteStudent);
                    Integer tem1 = this.baseMapper.updateById(targetRelation);
                    if (tem == 1 && tem1 == 1) {
                        paramsVo.setSuccess(true);
                    } else {
                        paramsVo.setErrorMsg("操作失败");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return paramsVo;
    }
}

