package com.yizhi.site.application.feign;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "ClassifyManageFeignClients")
public interface ClassifyManageFeignClients {
	
	/**
	 * 根据父类id查询子级分类
	 * @param parentId
	 * @return
	 */
	@GetMapping("/manage/classify/childnode/find")
	List<DataClassificationVo> getInformation(@RequestParam(name="parentId") Long parentId);
	
	/**
	 * 获取分类列表
	 * @param siteId
	 * @return
	 */
	@GetMapping("/manage/site/classify/list")
	List<ClassificationVO> getClassification(
			@RequestBody SiteComponyIdVO siteComponyIdVO);
	/**
	 * 新增分类
	 * @param dataClassificationEntityVo
	 * @return
	 */
	@PostMapping("/manage/site/classify/insertClassify")
	Boolean insertClassify(@RequestBody DataClassificationVo dataClassificationEntityVo);
	/**
	 * 查询所有的父节点
	 * @return
	 */
	@GetMapping("/manage/site/classify/select")
	List<DataClassificationVo> selectParent(@RequestBody RequestContext context);
	/**
	 * 修改分类资料
	 * @param
	 * @return
	 */
	@PostMapping("/manage/site/classify/updateClassify")
	public Boolean updateClassify(@RequestBody DataClassificationVo dataClassificationEntityVo);
	/**
	 * 删除分类
	 * @param id
	 */
	@PostMapping("/manage/site/classify/delete")
	public RespVO deleteClassify(@RequestBody IdOneVO vo);
	/**
	 * 查找资讯
	 * @param id
	 */
	@GetMapping("/manage/site/classify/information/select")
	public List<InformationVo> selectInformation(@RequestParam(name="typeTwo")Long typeTwo);

	/**
	 * 资讯分类拖拽排序
	 */
	@PostMapping("/manage/site/classify/dragClassify")
	Boolean dragClassify(@RequestBody IdTwoVO vo);
}
