package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.SiteLanguageVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.List;

/**
 * 国际化feign
 * 2020-8-24 17:11:14
 *
 * @author lingye
 */
@FeignClient(name = "portal", contextId = "InternationalClient")
public interface InternationalClient {
    /**
     * 国际化导入
     * @param model
     * @return
     */
    @PostMapping(value = "/international/import")
    String importInternational(@RequestBody InternationalFileUpVO model);

    /**
     * 查询国际化的管理管的列表
     *
     * @param type
     * @param languageId
     * @param keywords
     * @param state
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping("/international/page")
    Page<InternationalVO> findInternationalPage(
            @RequestParam(name = "type", required = false) Integer type,
            @RequestParam(name = "languageId", required = false) Long languageId,
            @RequestParam(name = "keywords", required = false) String keywords,
            @RequestParam(name = "state", required = false) Integer state,
            @RequestParam(name = "pageNo", required = false) Integer pageNo,
            @RequestParam(name = "pageSize", required = false) Integer pageSize);

    /**
     * 接口列表
     * @param type
     * @param languageId
     * @param keywords
     * @param state
     * @return
     */
    @GetMapping("/international/list")
    List<InternationalVO> findInternationalList(
            @RequestParam(name = "type", required = false) Integer type,
            @RequestParam(name = "languageId", required = false) Long languageId,
            @RequestParam(name = "keywords", required = false) String keywords,
            @RequestParam(name = "state", required = false) Integer state
    );

    /**
     * 修改国际化实体
     *
     * @param internationalVO
     * @return
     */
    @PostMapping("/international/update")
    InternationalVO updateInternational(
            @RequestBody InternationalVO internationalVO);


    /**
     * 国际化导出
     *
     * @param model
     * @return
     */
    @PostMapping(value = "/international/import")
    String importInternational(@RequestBody FileUploadModel model);

    /**
     * 列表
     *
     * @param pageNo
     * @param pageSize
     * @param status
     * @return
     */

    @GetMapping("/siteLanguage/list")
    Page<SiteLanguageVO> getList(
            @RequestParam(name = "pageNo") Integer pageNo,
            @RequestParam(name = "pageSize") Integer pageSize,
            @RequestParam(name = "status",required = false) Integer status
    );
    /**
     * 上移下移语言
     * @param sortVO
     * @return
     */
    @PostMapping("/siteLanguage/sort")
    Boolean sortLanguage(@RequestBody PortalTemplateVO sortVO);

    /**
     * 停用启用
     * @param siteLanguage
     * @return
     */
    @PostMapping("/siteLanguage/update")
    Boolean update(@RequestBody SiteLanguageVo siteLanguage);

    /**
     * 初始化语言json redis
     */
    @GetMapping(value = "/international/language/init")
    void initLanguage();
    /**
     * 获取语言json
     * @param type
     * @param languageCode
     * @return
     */
    @GetMapping("/international/language/get")
    HashMap<String, String> getLanguage(@RequestParam(name = "type",required = true) Integer type, @RequestParam(name = "languageCode",required = true) String languageCode);

}
