package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.site.TrSitePageVO;
import com.yizhi.site.application.vo.site.TrSiteStudentParamsVo;
import com.yizhi.site.application.vo.site.TrSiteStudentVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author admin
 */
@FeignClient(name = "portal", contextId = "TrSiteStudentFeignClients")
public interface TrSiteStudentFeignClients {

    /**
     * 保存配置的站点
     *
     * @param vos
     * @return
     */
    @PostMapping("/trSiteStudent/save")
    public Integer save(@ApiParam("vos") @RequestBody List<TrSiteStudentVo> vos);

    /**
     * 查询配置的列表
     *
     * @param trSitePageVO
     * @return
     */
    @PostMapping("/trSiteStudent/getPage")
    public Page<TrSiteStudentVo> getPage(@RequestBody TrSitePageVO trSitePageVO);

    /**
     * 删除已配置的数据
     *
     * @param id
     * @return
     */
    @GetMapping("/trSiteStudent/remove")
    public Integer remove(@RequestParam("id") Long id);

    /**
     * 上移下移
     *
     * @param paramsVo
     * @return
     */
    @PostMapping("/trSiteStudent/move")
    public TrSiteStudentParamsVo move(@RequestBody TrSiteStudentParamsVo paramsVo);

    /**
     * 判断对应终端是否发布  1:发布了   0：未发布
     * @param type
     * @return
     */
    @GetMapping("/trSiteStudent/canVisit")
    public Integer canVisit(@RequestParam("type") Integer type);

}
