package com.yizhi.site.application.vo.site;

import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "PreviewImformationVO", description = "公告预览")
@Data
public class PreviewImformationVO {
	
	@ApiModelProperty(value = "主鍵")
    private Long id;
    
    @ApiModelProperty(value = "封面logo")
    private String logoPath;
    
    @ApiModelProperty(value = "编号")
    private String number;
    
    @ApiModelProperty(value = "文章名称")
    private String fileName;
    
    @ApiModelProperty(value = "文章父类型  1： 新闻   2: 公告")
    private Long typeOne;
    
    @ApiModelProperty(value = "文章子类型")
    @TableField("type_two")
    private Long typeTwo;
    
    @ApiModelProperty(value = "作者")
    private String author;
    
    @ApiModelProperty(value = "发布时间")
    private Date releaseTime;
    
    @ApiModelProperty(value = "内容")
    private String content;
    
    @ApiModelProperty(value = "原文链接")
    private String linkUrl;
    
    @ApiModelProperty(value = "自定义关键字")
    private String keyWords;
    
    @ApiModelProperty(value = "置顶状态, 0: 未置顶 1:置顶")
    private Integer isTop;
    
    @ApiModelProperty(value = "状态 0 删除 1 未发布 2 发布")
    private Integer state;

}
