package com.yizhi.site.application.controller;


import com.yizhi.site.application.domain.PageFooter;
import com.yizhi.site.application.service.IPageFooterItemService;
import com.yizhi.site.application.service.IPageFooterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@RestController
@RequestMapping("/manage/page")
public class PageFooterController {

    private static Logger Log = LoggerFactory.getLogger(PageFooterController.class);

    @Autowired
    private IPageFooterService pageFooterService;

    @Autowired
    private IPageFooterItemService pageFooterItemService;


    /**
     * 编辑页底信息
     *
     * @param pageFooter
     * @return
     */
    @PostMapping("/pageFooter/save")
    public PageFooter pageFooterSave(@RequestBody PageFooter pageFooter){

        return pageFooterService.save(pageFooter);
    }


}

