package com.yizhi.site.application.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.controller.api.FunctionDisplayConfigApiController;
import com.yizhi.site.application.domain.FunctionDisplayConfig;
import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.domain.SiteLanguage;
import com.yizhi.site.application.service.IFunctionDisplayConfigService;
import com.yizhi.site.application.enums.FunctionTypeCode;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ISiteDicService;
import com.yizhi.site.application.service.ISiteLanguageService;
import com.yizhi.site.application.vo.site.PortalTemplateVO;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * (SiteLanguageEntityVo)表控制层
 *
 * @author lingye
 * @since 2020-08-26 14:50:46
 */
@RestController
@RequestMapping("/siteLanguage")
@Log4j2
public class SiteLanguageController {
    /**
     * 服务对象
     */
    @Resource
    private ISiteLanguageService siteLanguageService;

    /**
     * 获取列表
     *
     * @return 列表
     */
    @GetMapping("/list")
    public Page<SiteLanguageVO> getList(
            @RequestParam(name = "pageNo") Integer pageNo,
            @RequestParam(name = "pageSize") Integer pageSize,
            @RequestParam(name = "status",required = false) Integer status
    ) {
        Page<SiteLanguageVO> page = siteLanguageService.getList(status,pageNo,pageSize);
        return page;
    }

    /**
     * 修改/上下架
     *
     * @param siteLanguage
     * @return
     */
    @PostMapping("/update")
    public Boolean update(@RequestBody SiteLanguage siteLanguage) {

        return siteLanguageService.updateById(siteLanguage);
    }

    /**
     * @param sortVO
     * @return
      */
    @PostMapping("/sort")
    public Boolean sortLanguage(@RequestBody PortalTemplateVO sortVO) {
        // 1 上移 0 下移
        return siteLanguageService.sortLanguage(sortVO);
    }
}