package com.yizhi.site.application.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.service.ITrSiteStudentService;
import com.yizhi.site.application.service.PortalTerminalService;
import com.yizhi.site.application.vo.site.TrSitePageVO;
import com.yizhi.site.application.vo.site.TrSiteStudentParamsVo;
import com.yizhi.site.application.vo.site.TrSiteStudentVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 专区（子站点）配置表 前端控制器
 * </p>
 *
 * @author taoge123
 * @since 2020-09-14
 */
@RestController
@RequestMapping("/trSiteStudent")
public class TrSiteStudentController {

    private static Logger logger = LoggerFactory.getLogger(TrSiteStudentController.class);

    @Autowired
    private ITrSiteStudentService trSiteStudentService;
    @Autowired
    private PortalTerminalService portalTerminalService;

    @PostMapping("/save")
    @ApiOperation(value = "保存配置的站点")
    public Integer save(@ApiParam("vos") @RequestBody List<TrSiteStudentVo> vos) {

        return trSiteStudentService.save(vos);
    }

    @PostMapping("/getPage")
    @ApiOperation(value = "查询配置的列表")
    public Page<TrSiteStudentVo> getPage(@RequestBody TrSitePageVO trSitePageVO) {
        Page page = new Page(trSitePageVO.getPageNo(), trSitePageVO.getPageSize());
        return trSiteStudentService.getPage(trSitePageVO, page);
    }

    @GetMapping("/remove")
    @ApiOperation(value = "删除")
    public Integer remove(@RequestParam("id") Long id) {
        return trSiteStudentService.remove(id);
    }

    @PostMapping("/move")
    @ApiOperation(value = "上移下移")
    public TrSiteStudentParamsVo move(@RequestBody TrSiteStudentParamsVo paramsVo) {
        return trSiteStudentService.move(paramsVo);
    }

    @GetMapping("/canVisit")
    @ApiOperation(value = "判断对应终端是否发布")
    public Integer canVisit(@RequestParam("type") Integer type) {
        return portalTerminalService.canVisit(type);
    }
}

