package com.yizhi.site.application.controller.api;


import cn.hutool.json.JSONUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.MyItemConfig;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.domain.MyItemConfigDefault;
import com.yizhi.site.application.service.MyItemConfigDefaultService;
import com.yizhi.site.application.service.MyItemConfigService;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 我的配置 前端控制器
 * </p>
 *
 * @author hutao123
 * @since 2019-02-21
 */
@Slf4j
@Api(tags = "显示端-我的配置", description = "我的配置")
@RestController
@RequestMapping("/myItemConfig/api")
public class MyItemConfigApiComtroller {
    public static final Integer OPERATION_FAIL = 0;
    public static final Integer OPERATION_SUCCESS = 1;
    public static final Integer ID_NOT_EXSIT = -1;
    @Autowired
    MyItemConfigService myItemConfigService;
    @Autowired
    MyItemConfigDefaultService myItemConfigDefaultService;
    @Autowired
    IdGenerator idGenerator;


    @GetMapping("/queryByAuthoity")
    public List<MyItemConfigVO> queryByAuthoity(@RequestParam(value = "terminalType",required = false) List<Integer> terminalType) {
        RequestContext context = ContextHolder.get();
        List<MyItemConfig> itemConfigs = myItemConfigService.queryByAuthoity(context.getSiteId(), terminalType, 1);
        log.info("我的功能列表查询返回 itemConfigs :{}", JSONUtil.toJsonStr(itemConfigs));
        List<MyItemConfigVO> voList = new ArrayList<>();
        if (CollectionUtils.isEmpty(itemConfigs)) {
            //我的配置若还没有数据则取默认数据
            List<MyItemConfigDefault> defaultItemConfigs = myItemConfigDefaultService.queryByAuthoity(context.getSiteId(), terminalType);
            if (!CollectionUtils.isEmpty(defaultItemConfigs)){
                defaultItemConfigs.forEach(a -> {
                    MyItemConfigVO vo = new MyItemConfigVO();
                    BeanUtils.copyProperties(a, vo);
                    voList.add(vo);
                });
            }
        }else {
            itemConfigs.forEach(a -> {
                MyItemConfigVO vo = new MyItemConfigVO();
                BeanUtils.copyProperties(a, vo);
                voList.add(vo);
            });
        }
        return voList;
    }

}