package com.yizhi.site.application.controller.api;

import com.alibaba.fastjson.JSON;
import com.yizhi.site.application.domain.TrPortalBlock;
import com.yizhi.site.application.enums.BlockTypeCode;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.ITrPortalBlockService;
import com.yizhi.site.application.vo.site.BottomMenuVO;
import com.yizhi.site.application.vo.site.PortalBlockVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 16:09 2018/7/24
 * @Modified By
 */
@RestController
@RequestMapping("/portalBlock")
public class PortalBlockController {

    public static final List<BottomMenuVO> defaultBottomMenu = Arrays.asList(
            new BottomMenuVO(1L,"首页",true),
            new BottomMenuVO(2L,"活动",true),
            /*new BottomMenuVO(3L,"课程",true),
            new BottomMenuVO(4L,"营销",true),
            new BottomMenuVO(6L,"社群",false),*/
            new BottomMenuVO(5L,"我的",true));

    public static List<BottomMenuVO> copyList(List<BottomMenuVO> src){
        if(CollectionUtils.isEmpty(src)){
            return null;
        }
        List<BottomMenuVO> tager=new ArrayList<>();
        for(BottomMenuVO item : src){
            tager.add((BottomMenuVO)item.clone());
        }

        return tager;
    }

    private static final Logger LOGGER = LoggerFactory.getLogger(PortalBlockController.class);

    // 获取全部的枚举对象
    private static final BlockTypeCode[] blockTypeCodes = BlockTypeCode.values();

    @Autowired
    ITrPortalBlockService portalBlockService;

    @Autowired
    private IdGenerator idGenerator;

    @RequestMapping(value = "/status/change",method = RequestMethod.POST)
    public PortalBlockVO displayChange(@RequestBody PortalBlockVO portalBlockVO){

        /*for(BlockTypeCode item : blockTypeCodes){
            if(item.getCode().equals(portalBlockVO.getBlockType())){

            }
        }*/
        LOGGER.info("**********************修改显示状态的处理开始*************************");
        LOGGER.info("**********************请求参数="+ JSON.toJSONString(portalBlockVO));
        TrPortalBlock portalBlock = new TrPortalBlock();
        BeanUtils.copyProperties(portalBlockVO,portalBlock);
        List<BottomMenuVO> bottomMenuVOS =  portalBlockVO.getBottomMenuVOS();
        if(CollectionUtils.isNotEmpty(bottomMenuVOS)){
            String menus = bottomMenuVOS.stream().filter(item->item.getChecked()).map(obj->obj.getId().toString()).collect(Collectors.joining(","));
            portalBlock.setBottomMenu(menus);
        }
        if(portalBlockVO.getId()==null){
            // 新增
            portalBlock.setId(idGenerator.generate());
            portalBlock.setCreateTime(new Date());
            portalBlock.setCreateById(portalBlockVO.getOptionId());
            portalBlock.setCreateByName(portalBlockVO.getOptionName());


            portalBlockService.insert(portalBlock);
            portalBlockVO.setId(portalBlock.getId());
        } else {
            // 修改
            portalBlock.setUpdateTime(new Date());
            portalBlock.setUpdateById(portalBlockVO.getOptionId());
            portalBlock.setUpdateByName(portalBlockVO.getOptionName());
            portalBlockService.updateById(portalBlock);
        }
        LOGGER.info("**********************修改显示状态的处理结束，返回值="+ JSON.toJSONString(portalBlockVO));
        return portalBlockVO;
    }

    @RequestMapping(value = "/terminalId/get",method = RequestMethod.GET)
    public PortalBlockVO getByTerminalId(@RequestParam(value = "terminalId") Long terminalId,
                                         @RequestParam(value = "blockType") Integer blockType,
                                         @RequestParam("optionId") Long optionId,
                                         @RequestParam("optionName") String optionName){
        LOGGER.info("**********************获取区块状态信息开始,返回JSON格式*************************");
        TrPortalBlock portalBlock = new TrPortalBlock();
        portalBlock.setTerminalId(terminalId);
        portalBlock.setBlockType(blockType);

        if(terminalId == null){
            return null;
        }
        PortalBlockVO vo = new PortalBlockVO();
        try {
            TrPortalBlock portalBlockRet = portalBlockService.selectOne(QueryUtil.condition(portalBlock));
            // 如果没有查询到数据，初始化该数据
            // 如果数据表中没有数据返回，则返回null；如果返回多条数据，则会抛出异常
            LOGGER.info("**********************获取区块状态信息数据="+JSON.toJSONString(portalBlockRet));
            if(portalBlockRet == null){
                portalBlockRet = new TrPortalBlock();
                // 新增
                portalBlockRet.setTerminalId(terminalId);
                portalBlockRet.setBlockType(blockType);
                portalBlockRet.setDisplay(1);
                portalBlockRet.setId(idGenerator.generate());
                portalBlockRet.setCreateTime(new Date());
                portalBlockRet.setCreateById(optionId);
                portalBlockRet.setCreateByName(optionName);
                portalBlockRet.setBottomMenu("1,2,3,4,5");

                portalBlockService.insert(portalBlockRet);
                LOGGER.info("**********************无区块信息，新增一条信息为："+JSON.toJSONString(portalBlockRet));
            }
            String bottomStr = portalBlockRet.getBottomMenu();

            BeanUtils.copyProperties(portalBlockRet,vo);

            List<BottomMenuVO> destList= copyList(defaultBottomMenu);
            if(StringUtils.isNotBlank(bottomStr)){
                destList.forEach(
                        item->{
                            if(StringUtils.indexOf(bottomStr,item.getId().toString()) >= 0){
                                item.setChecked(true);
                            }else {
                                item.setChecked(false);
                            }
                        }
                );
            }

            LOGGER.info("查询菜单信息="+JSON.toJSONString(destList));
            vo.setBottomMenuVOS(destList);



        } catch (Exception e) {
            LOGGER.info("************************处理发生异常{}",e);
            return null;
        }
        return vo;
    }

}
