package com.yizhi.site.application.controller.api;


import com.yizhi.site.application.domain.RelationLink;
import com.yizhi.site.application.service.IRelationLinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 默认图片的修改
 * @author: lly
 * @date: 2019-01-21 12:45
 **/
@RestController
@RequestMapping("/relation")
public class RelationLinkController {
    public static final Logger LOGGER = LoggerFactory.getLogger(RelationLinkController.class);
    @Autowired
    private IRelationLinkService relationLinkService;

    /**
     * 根据用code 获取默认图片
     * @param code
     * @return
     */
    @GetMapping("/get")
    public RelationLink getRelationLink(@RequestParam(name = "code") Integer code){
        return relationLinkService.getRelationLinkByCode(code);
    }


}
