package com.yizhi.site.application.mapper;

import java.util.List;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.site.application.domain.DataClassification;
import org.apache.ibatis.annotations.Param;

import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.site.ClassificationVO;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface DataClassificationMapper extends BaseMapper<DataClassification> {

	List<ClassificationVO> selectSonClassification(@Param("siteId") Long siteId);

	Long selectMaxSort(@Param("parentId") Long parentId);

	/**
	 * 获得所有新闻二级分类(没有内容的筛除)
	 * @param siteId
	 * @param typeOne
	 * @return
	 */
	List<DataClassification> getSubcategories(@Param("siteId") Long siteId,@Param("typeOne") Long typeOne);
	
	/**
	 * 获取新闻的分类
	 * @param siteId
	 * @param parentId
	 * @return
	 */
	List<DataClassificationVo> selectClassification(@Param("siteId") Long siteId, @Param("parentId") Long parentId);
}
