package com.yizhi.site.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.site.application.domain.HomeAnnouncement;
import com.yizhi.site.application.mapper.HomeAnnouncementMapper;
import com.yizhi.site.application.service.HomeAnnouncementService;
import com.yizhi.site.application.constant.SiteConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.vo.site.AnnouncementVO;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-02
 */
@Transactional
@Service
public class HomeAnnouncementServiceImpl extends ServiceImpl<HomeAnnouncementMapper, HomeAnnouncement> implements HomeAnnouncementService {
	
	@Autowired
	private IdGenerator idGenerator;
	
	 @Autowired
	  private PortalHomeService portalHomeService;
	 
	 @Autowired
	 private HomeAnnouncementMapper homeAnnouncementMapper;


	@Override
	public boolean copyAnnouncement(Long sourceId, Long targetId) {
		List<HomeAnnouncement> list = new ArrayList<HomeAnnouncement>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", sourceId);
		map.put("state", SiteConstant.FIRST);
		List<HomeAnnouncement> selectByMap = this.selectByMap(map);
		HomeAnnouncement p = null;
		for(HomeAnnouncement pn : selectByMap){
			p = new HomeAnnouncement();
			BeanUtils.copyProperties(pn, p);
			p.setId(idGenerator.generate());
			p.setHomeId(targetId);
			list.add(p);
		}
		if(list.size() > 0){
			this.insertBatch(list);
		}
		return true;
	}
	
	
	
	
	@Override
	public Boolean insertUpdateRelationAnnouncementPC(AnnouncementVO announcementVO) {
		// TODO Auto-generated method stub
		List<Long>  announcementIds=announcementVO.getAnnouncementIds();
		Long homeId=portalHomeService.getHomeId(announcementVO.getTerminalId());
		//插入公告列表
		if(CollectionUtils.isNotEmpty(announcementIds)&&homeId!=null&&announcementVO.getDisplay()==null) {
			HomeAnnouncement announcement=new HomeAnnouncement();
			Date createDate=new Date();
			Integer maxSort=homeAnnouncementMapper.maxSortByHomeId(homeId);
			if(maxSort==null) {
				maxSort=1;
			}
			for (int i = 0; i < announcementIds.size(); i++) {
				maxSort++;
				Long informationId=announcementIds.get(i);
				announcement.setId(idGenerator.generate());
				announcement.setHomeId(homeId);
				announcement.setInformationId(informationId);
				announcement.setDisplay(1);//公告显示
				announcement.setState(1);
				announcement.setSort(maxSort);
				announcement.setCreateByName(ContextHolder.get().getAccountName());
				announcement.setCreateById(ContextHolder.get().getCompanyId());
				announcement.setCreateTime(createDate);
				this.insert(announcement);
			}
		}
		
		//模块状态改变
		if(announcementVO.getDisplay()!=null&&CollectionUtils.isEmpty(announcementIds)) {
			HomeAnnouncement announcement=new HomeAnnouncement();
			announcement.setDisplay(announcementVO.getDisplay());
			/**
			 * 条件
			 */
			HomeAnnouncement announcement2=new HomeAnnouncement();
			announcement2.setHomeId(homeId);
			announcement2.setState(1);
			EntityWrapper<HomeAnnouncement> wrapper=new EntityWrapper<HomeAnnouncement>(announcement2);
			this.update(announcement, wrapper);
			}
		
		//删除公告
		if(announcementVO.getAnnouncementId()!=null) {
			HomeAnnouncement announcement=new HomeAnnouncement();
			announcement.setState(0);//删除公告
			announcement.setUpdateById(ContextHolder.get().getAccountId());
			announcement.setUpdateByName(ContextHolder.get().getAccountName());
			announcement.setUpdateTime(new Date());
			/**
			 * 条件
			 */
			HomeAnnouncement announcement2=new HomeAnnouncement();
			announcement2.setHomeId(homeId);
			announcement2.setInformationId(announcementVO.getAnnouncementId());
			EntityWrapper<HomeAnnouncement> wrapper=new EntityWrapper<HomeAnnouncement>(announcement2);
			this.update(announcement, wrapper);
		}
		return true;
	}




	/**
	 * 浪费内存，为了赶进度，没办法。
	 */
	@Override
	public Boolean updateDetailsAnnouncementPC(Long terminalId,Long currentId, Integer isDown) {
		// TODO Auto-generated method stub
		Long homeId=portalHomeService.getHomeId(terminalId);
		HomeAnnouncement homeAnnouncementSource=new HomeAnnouncement();
		homeAnnouncementSource.setHomeId(homeId);
		homeAnnouncementSource.setInformationId(currentId);
		homeAnnouncementSource.setState(1);
		EntityWrapper<HomeAnnouncement> wrapperSource=new EntityWrapper<HomeAnnouncement>(homeAnnouncementSource);
		homeAnnouncementSource=this.selectOne(wrapperSource);
		
		Integer curSort=homeAnnouncementSource.getSort();
		Long targetId=homeAnnouncementMapper.getTargetId(homeId, curSort, isDown);//主键
		
		if(targetId!=null) {
			HomeAnnouncement homeAnnouncementTarget=new HomeAnnouncement();
			homeAnnouncementTarget.setHomeId(homeId);
			homeAnnouncementTarget.setInformationId(targetId);
			homeAnnouncementTarget.setState(1);
			EntityWrapper<HomeAnnouncement> wrapperTarget=new EntityWrapper<HomeAnnouncement>(homeAnnouncementTarget);
			homeAnnouncementTarget=this.selectOne(wrapperTarget);
			
			Long sId=homeAnnouncementSource.getId();
			Integer sSort=homeAnnouncementSource.getSort();
			Long tId=homeAnnouncementTarget.getId();
			Integer tSort=homeAnnouncementTarget.getSort();
			
			HomeAnnouncement homeSource=new HomeAnnouncement();
			homeSource.setId(sId);
			homeSource.setSort(tSort);
			
			System.out.println(homeSource);
			
			HomeAnnouncement homeTarget=new HomeAnnouncement();
			homeTarget.setId(tId);
			homeTarget.setSort(sSort);
			
			System.out.println(homeSource);
			
			this.updateById(homeSource);
			this.updateById(homeTarget);
		}
		
		
		return true;
	}




	@Override
	public Integer announcementViewDisplay(Long terminalId) {
		// TODO Auto-generated method stub
		Long homeId=portalHomeService.getHomeId(terminalId);
		HomeAnnouncement entity=new HomeAnnouncement();
		entity.setHomeId(homeId);
		entity.setState(1);
		entity.setDisplay(1);
		EntityWrapper<HomeAnnouncement> wrapper=new EntityWrapper<HomeAnnouncement>(entity);
		List<HomeAnnouncement> list=this.selectList(wrapper);
		if(CollectionUtils.isNotEmpty(list)) {
			return 1;
		}
		return 0;
	}

    /**
     * 获取公告列表
     * @param id
     * @date 2019-2-26
     * @return
     */
    @Override
    public List<AnnouncementVO> getAnnouncementList(Long id){
        return homeAnnouncementMapper.listAnnouncement(id);
    }

}
