package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.PageFooter;
import com.yizhi.site.application.domain.PageFooterItem;
import com.yizhi.site.application.domain.PageFooterItemConfig;
import com.yizhi.site.application.mapper.PageFooterItemConfigMapper;
import com.yizhi.site.application.mapper.PageFooterItemMapper;
import com.yizhi.site.application.mapper.PageFooterMapper;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.IPageFooterItemConfigService;
import com.yizhi.site.application.vo.site.LinkVo;
import com.yizhi.site.application.vo.site.PageFooterItemConfigVo;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.enums.TerminalType;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.domain.Internationalization;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Service
@Transactional
public class PageFooterItemConfigServiceImpl extends ServiceImpl<PageFooterItemConfigMapper, PageFooterItemConfig> implements IPageFooterItemConfigService {

    @Autowired
    private PageFooterItemConfigMapper pageFooterItemConfigMapper;

    @Autowired
    private PageFooterItemMapper pageFooterItemMapper;

    @Autowired
    private PageFooterMapper pageFooterMapper;

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private InternationalizationUtil internationalizationUtil;


    /**
     * 链接表单保存
     *
     * @param pageFooterItemConfigVo
     * @return
     */
    @Override
    public PageFooterItemConfigVo save(PageFooterItemConfigVo pageFooterItemConfigVo) {

        Date date = new Date();

        RequestContext context = ContextHolder.get();
        PageFooter footer = new PageFooter();
        footer.setSiteId(context.getSiteId());
        footer.setDelete(0);

        // 通过SiteId 查询 PageFooter表
        PageFooter pf = pageFooterMapper.selectOne(footer);
        PageFooterItem footerItem = new PageFooterItem();
        PageFooterItemConfig footerItemConfig = new PageFooterItemConfig();

        // 修改pageFooter表单
        pf.setType(1);
        pf.setUpdateById(context.getAccountId());
        pf.setUpdateByName(context.getAccountName());
        pf.setUpdateTime(date);
        pageFooterMapper.updateById(pf);
        //  PageType  0文案 / 1链接
        if (pageFooterItemConfigVo.getPageType() == 0) {
            footerItem.setOfficialDocumentContent(pageFooterItemConfigVo.getContent());

            Long pageFooterItemId = idGenerator.generate();
            footerItem.setId(pageFooterItemId);
            footerItem.setPageFooterId(pf.getId());
            //  PageType  0文案 / 1链接
            footerItem.setPageType(pageFooterItemConfigVo.getPageType());
            //0文字连接,1图片链接
            footerItem.setType(pageFooterItemConfigVo.getType());
            footerItem.setDelete(0);
            footerItem.setSiteId(context.getSiteId());
            footerItem.setCompanyId(context.getCompanyId());
            footerItem.setOrgId(context.getOrgId());
            footerItem.setCreateTime(date);
            footerItem.setCreateById(context.getAccountId());
            footerItem.setCreateByName(context.getAccountName());

            // 排序
            PageFooterItem pageFooterItemEx = new PageFooterItem();
            pageFooterItemEx.setDelete(0);
            pageFooterItemEx.setCompanyId(context.getCompanyId());
            pageFooterItemEx.setSiteId(context.getSiteId());

            EntityWrapper<PageFooterItem> enw = new EntityWrapper<>(pageFooterItemEx);
            enw.orderBy("sort", false);
            PageFooterItem item = pageFooterItemEx.selectOne(enw);
            if (null != item) {
                footerItem.setSort(item.getSort() + 1);
            } else {
                footerItem.setSort(1);
            }
            if (pageFooterItemMapper.insert(footerItem) > 0) {
                //同时添加国际化记录
                Internationalization a = new Internationalization();
                a.setName(pageFooterItemConfigVo.getContent());
                a.setModuleName(ModuleType.PORTAL.getName());
                a.setModuleType(ModuleType.PORTAL.getCode());
                a.setTableType(ClassUtils.getTableName(PageFooterItem.class));
                a.setTaskId(pageFooterItemId);
                a.setTerminalType(TerminalType.PC.getCode());
                internationalizationUtil.addInternationalization(a);
            }

        } else {
            footerItem.setName(pageFooterItemConfigVo.getName());
            footerItem.setShowable(pageFooterItemConfigVo.getShowable());
            //  PageType  0文案 / 1链接
            footerItem.setPageType(pageFooterItemConfigVo.getPageType());
            //0文字连接,1图片链接
            footerItem.setType(pageFooterItemConfigVo.getType());

            Long pageFooterItemId = idGenerator.generate();
            footerItem.setId(pageFooterItemId);
            footerItem.setPageFooterId(pf.getId());
            footerItem.setDelete(0);
            footerItem.setSiteId(context.getSiteId());
            footerItem.setCompanyId(context.getCompanyId());
            footerItem.setOrgId(context.getOrgId());
            footerItem.setCreateTime(date);
            footerItem.setCreateById(context.getAccountId());
            footerItem.setCreateByName(context.getAccountName());

            // 排序
            PageFooterItem pageFooterItemEx = new PageFooterItem();
            pageFooterItemEx.setDelete(0);
            pageFooterItemEx.setCompanyId(context.getCompanyId());
            pageFooterItemEx.setSiteId(context.getSiteId());

            EntityWrapper<PageFooterItem> enw = new EntityWrapper<>(pageFooterItemEx);
            enw.orderBy("sort", false);
            PageFooterItem item = pageFooterItemEx.selectOne(enw);
            if (null != item) {
                footerItem.setSort(item.getSort() + 1);
            } else {
                footerItem.setSort(1);
            }
            if (pageFooterItemMapper.insert(footerItem) > 0) {
                //同时添加国际化记录
                Internationalization a = new Internationalization();
                a.setName(pageFooterItemConfigVo.getName());
                a.setModuleName(ModuleType.PORTAL.getName());
                a.setModuleType(ModuleType.PORTAL.getCode());
                a.setTableType(ClassUtils.getTableName(PageFooterItem.class));
                a.setTaskId(pageFooterItemId);
                a.setTerminalType(TerminalType.PC.getCode());
                internationalizationUtil.addInternationalization(a);
            }
        }

        List<LinkVo> linkVos = pageFooterItemConfigVo.getLinkVos();


        if (pageFooterItemConfigVo.getType() != null) {

            if (CollectionUtils.isNotEmpty(linkVos)) {
                if (pageFooterItemConfigVo.getType() == 0) {
                    for (LinkVo linkVo : linkVos) {
                        //如果type为0,则保存文字链接信息
                        Long generate = idGenerator.generate();
                        footerItemConfig.setId(generate);
                        footerItemConfig.setPageFooterItemId(footerItem.getId());
                        footerItemConfig.setCharaterTag(linkVo.getCharaterTag());
                        footerItemConfig.setLink(linkVo.getLink());
                        footerItemConfig.setDelete(0);
                        footerItemConfig.setCreateTime(date);
                        footerItemConfig.setCompanyId(context.getCompanyId());
                        footerItemConfig.setOrgId(context.getOrgId());
                        footerItemConfig.setSiteId(context.getSiteId());
                        footerItemConfig.setCreateById(context.getAccountId());
                        footerItemConfig.setCreateByName(context.getAccountName());

                        // 保存排序

                        PageFooterItemConfig pageFooterItemConfigEx = new PageFooterItemConfig();
                        pageFooterItemConfigEx.setDelete(0);
                        pageFooterItemConfigEx.setCompanyId(context.getCompanyId());
                        pageFooterItemConfigEx.setSiteId(context.getSiteId());

                        EntityWrapper<PageFooterItemConfig> ew = new EntityWrapper<>(pageFooterItemConfigEx);
                        ew.orderBy("sort", false);
                        PageFooterItemConfig lastBrother = pageFooterItemConfigEx.selectOne(ew);
                        if (null != lastBrother) {
                            footerItemConfig.setSort(lastBrother.getSort() + 1);
                        } else {
                            footerItemConfig.setSort(1);
                        }

                        if (pageFooterItemConfigMapper.insert(footerItemConfig)>0){
                            //同时添加国际化记录
                            Internationalization a = new Internationalization();
                            a.setName(linkVo.getCharaterTag());
                            a.setModuleName(ModuleType.PORTAL.getName());
                            a.setModuleType(ModuleType.PORTAL.getCode());
                            a.setTableType(ClassUtils.getTableName(PageFooterItemConfig.class));
                            a.setTaskId(generate);
                            a.setTerminalType(TerminalType.PC.getCode());
                            internationalizationUtil.addInternationalization(a);
                        }
                    }
                } else {
                    //如果type为1,则保存图片链接信息
                    for (LinkVo linkVo : linkVos){
                        footerItemConfig.setId(idGenerator.generate());
                        footerItemConfig.setPageFooterItemId(footerItem.getId());
                        footerItemConfig.setImgOssUrl(linkVo.getImgOssUrl());
                        footerItemConfig.setLink(linkVo.getLink());
                        footerItemConfig.setDelete(0);
                        footerItemConfig.setCreateTime(date);
                        footerItemConfig.setCompanyId(context.getCompanyId());
                        footerItemConfig.setOrgId(context.getOrgId());
                        footerItemConfig.setSiteId(context.getSiteId());
                        footerItemConfig.setCreateById(context.getAccountId());
                        footerItemConfig.setCreateByName(context.getAccountName());

                        // 保存排序
                        PageFooterItemConfig pageFooterItemConfigEx = new PageFooterItemConfig();
                        pageFooterItemConfigEx.setDelete(0);
                        pageFooterItemConfigEx.setCompanyId(context.getCompanyId());
                        pageFooterItemConfigEx.setSiteId(context.getSiteId());

                        EntityWrapper<PageFooterItemConfig> ew = new EntityWrapper<>(pageFooterItemConfigEx);
                        ew.orderBy("sort", false);
                        PageFooterItemConfig lastBrother = pageFooterItemConfigEx.selectOne(ew);
                        if (null != lastBrother) {
                            footerItemConfig.setSort(lastBrother.getSort() + 1);
                        } else {
                            footerItemConfig.setSort(1);
                        }

                        pageFooterItemConfigMapper.insert(footerItemConfig);
                    }
                }

            }
        }

        return pageFooterItemConfigVo;
    }

    @Override
    public List<Long> getIds(Long footerItemId) {
        PageFooterItemConfig footerItemConfig = new PageFooterItemConfig();
        footerItemConfig.setPageFooterItemId(footerItemId);
        List<PageFooterItemConfig> pageFooterItemConfigs = this.selectList(new EntityWrapper<>(footerItemConfig));
        if (CollectionUtils.isNotEmpty(pageFooterItemConfigs)){
          return   pageFooterItemConfigs.parallelStream().map(a->a.getId()).collect(Collectors.toList());
        }

        return new ArrayList<>();
    }
}
