package com.yizhi.site.application.service.impl;

import com.yizhi.site.application.domain.RelationLink;
import com.yizhi.site.application.mapper.RelationLinkMapper;
import com.yizhi.site.application.service.IRelationLinkService;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.StringUtils;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author fulan123
 * @since 2018-12-13
 */
@Service
public class RelationLinkServiceImpl extends ServiceImpl<RelationLinkMapper, RelationLink> implements IRelationLinkService {

	@Autowired
	private RelationLinkMapper relationLinkMapper;
	
	@Override
	public List<RelationLink> getAllListLink(String name,Integer type) {
		// TODO Auto-generated method stub
		RelationLink relationLink=new RelationLink();
		relationLink.setState(1);//因为现在学员端有些功能还没做，因此现在有的只要上架的状态
		EntityWrapper<RelationLink> wrapper=new EntityWrapper<RelationLink>(relationLink);
		if(!StringUtils.isEmpty(name)) {
			wrapper.like("name", name);
		}
		if(type==1) {  //前100对应各个模块  101-200对应默认图片
			wrapper.ge("id", 0);   //>=0
			wrapper.le("id", 100);//<=100
		}
		else if(type==2) {
			wrapper.ge("id", 101);//>=101
			wrapper.le("id", 200);//<=200
		}
		wrapper.orderBy("id", true);
		
		return relationLinkMapper.selectList(wrapper);
	}

	@Override
	public RelationLink getRelationLinkByCode(Integer code) {
		// TODO Auto-generated method stub
		RelationLink relationLink=new RelationLink();
		relationLink.setCode(code);
		return relationLinkMapper.selectOne(relationLink);
	}

}
