package com.yizhi.training.application.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.domain.TpStudentEnrollPassed;
import com.yizhi.training.application.domain.TrainingProject;
import com.yizhi.training.application.mapper.TpStudentEnrollPassedMapper;
import com.yizhi.training.application.mapper.TpViewRecordMapper;
import com.yizhi.training.application.mapper.TrainingProjectMapper;
import com.yizhi.training.application.service.ITpStudentEnrollPassedService;
import com.yizhi.training.application.service.ITrainingProjectService;

@RestController
@RequestMapping("/TpStudentEnrollPassed")
public class TpStudentEnrollPassedController {

    @Autowired
    ITpStudentEnrollPassedService studentEnrollPassedService;

    @Autowired
    private IdGenerator idGenerator;
    
    @Autowired
    private TpStudentEnrollPassedMapper tpStudentEnrollPassedMapper;
    
    @Autowired
    private TrainingProjectMapper trainingProjectMapper;
    
    @Autowired
    private ITrainingProjectService trainingProjectService;
    
    @Autowired
    private TpViewRecordMapper tpViewRecordMapper;
    
    @Autowired
    private RedisCache redisCache;
    
    @GetMapping("/selectTpIdByCondition")
    Long selectTpIdByCondition(@RequestParam(value = "tpProjrctId")Long tpProjrctId){
        RequestContext context = ContextHolder.get();
        return studentEnrollPassedService.selectTpIdByCondition(tpProjrctId,context.getAccountId(),context.getSiteId());
    }
    
    @RequestMapping(value="/insertTpStudentEnrollPassed", method=RequestMethod.GET)
    Long insertTpStudentEnrollPassed(@RequestParam(value = "projrctId") Long projrctId, @RequestParam(value = "enrollId") Long enrollId) {

		RequestContext requestContext = ContextHolder.get();
		
		TrainingProject tp = trainingProjectMapper.selectById(projrctId);
		if (null != tp) {
			TpStudentEnrollPassed tep = new TpStudentEnrollPassed();
	        tep.setId(idGenerator.generate());
	        tep.setTrainingProjectId(projrctId);
	        tep.setEnrollId(enrollId);
	        tep.setAccountId(requestContext.getAccountId());
	        tep.setStartTime(tp.getStartTime());
	        tep.setEndTime(tp.getEndTime());
	        tep.setJoinTime(new Date());
	        tep.setSiteId(requestContext.getSiteId());
	        Integer count = tpStudentEnrollPassedMapper.insert(tep);
	        //参加人数添加到缓存
	        if(count > 0){
	        	try {
	        		String key = "tp:page:joinNumber:count:" + tp.getCompanyId();
					String item = tp.getSiteId() + tp.getId().toString();
					if (tp.getVisibleRange() == 1) {
						count = tpViewRecordMapper.getEnrollViewNum(tp);
					} else {
						count = tpViewRecordMapper.getEnrollViewNumRange(tp);
					}
					redisCache.hset(key, item, count + "", 86400);
	        	} catch(Exception e){
	        		e.printStackTrace();
	        	}
	        }
	        
	        //判断是否要签到，不要签到就完成项目
	        if(tp.getEnableSign() == 0){
	        	trainingProjectService.trainingProjectFinished(projrctId, requestContext.getSiteId(), requestContext.getAccountId());
	        }
	        return tep.getId();
		}
		
		return null;
	}
}
