package com.yizhi.training.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.yizhi.util.application.sensitive.annotation.SensitiveWords;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 留言管理
 * </p>
 *
 * @author yanglang
 * @since 2025-01-03
 */
@Data
@Api(tags = "LeaveWord", description = "留言管理")
@TableName("leave_word")
public class LeaveWord extends Model<LeaveWord> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "标题")
    @TableField("name")
    private String name;

    @SensitiveWords
    @ApiModelProperty(value = "你的问题建议")
    private String content;

    @ApiModelProperty(value = "图片地址，多个以逗号分隔")
    @TableField("oss_url")
    private String ossUrl;

    @ApiModelProperty(value = "接受时间")
    @TableField("accept_time")
    private Date acceptTime;

    @ApiModelProperty(value = "创建者id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "修改者id")
    @TableField(value = "update_by_id", fill = FieldFill.UPDATE)
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    @TableField(value = "update_by_name", fill = FieldFill.UPDATE)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "组织id")
    @TableField("group_id")
    private Long groupId;

    @ApiModelProperty(value = "支部名称")
    @TableField(exist = false)
    private String groupName;

    @ApiModelProperty(value = "部室名称")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "企业id")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "业务类型:1-功能异常、2-体验问题、3-产品建议、4-其他")
    private Integer bizType;
    
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @ApiModelProperty("提交状态1-待接收，2-已接受")
    @TableField("state")
    private Integer state;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
    @TableLogic
    private Integer deleted;

    @ApiModelProperty(value = "视频链接地址")
    @TableField("oss_video_url")
    private String ossVideoUrl;

    @ApiModelProperty(value = "图片链接地址")
    @TableField("oss_pic_url")
    private String ossPicUrl;

    @ApiModelProperty("是否匿名 0 否 1 是")
    @TableField("anonymous_flag")
    private Integer anonymousFlag;
}
