package com.yizhi.training.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.training.application.domain.TpStudentActivityRecord;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 学员完成活动记录（这里无论有没有被设置成别的活动的开启条件，都记录） Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-29
 */
public interface TpStudentActivityRecordMapper extends BaseMapper<TpStudentActivityRecord> {

    /**
     * 查询学员已经完成的
     *
     * @param accountId
     * @param relationIds
     * @param finished    1:完成，0:未完成
     * @return 返回已经完成的活动relationId（该id指课程、考试等的id）
     */
    List<Long> selectFinished(@Param("accountId") Long accountId, @Param("relationIds") List<Long> relationIds, @Param("finished") Integer finished);

    /**
     * 活动id
     *
     * @param relationIds
     * @return
     */
    List<Long> getAccountIdByRelationIds(@Param("relationIds") List<Long> relationIds);

    /**
     * 查询活动完成数
     *
     * @param relationIds
     * @param accountId
     * @param siteId
     * @return
     */
    Integer getFinishedCountByRelationIds(@Param("relationIds") List<Long> relationIds, @Param("accountId") Long accountId,
                                          @Param("siteId") Long siteId);


    /**
     * 按部门统计-实际参加人数
     *
     * @param startDate
     * @param endDate
     * @param accountIdList
     * @return
     */
    Integer selectCountFactJoinNumTrainingProjectOrgGroup(@Param("startDate") Date startDate, @Param("endDate") Date endDate, @Param("accountIdList") List<Long> accountIdList);

    List<Long> getRecordeAllWorkId();
    
    List<TpStudentActivityRecord> getAllRecordeByTimeLimit(@Param(value="startDate")String startDate, @Param(value="endDate")String endDate, @Param("relationId")Long relationId);

}
