package com.yizhi.training.application.service.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

import cn.hutool.json.JSONUtil;
import com.google.gson.JsonNull;
import com.yizhi.training.application.util.LegacyDateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.hierarchicalauthorization.HQueryUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.TaskParamsEnums;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.course.application.feign.RecordeClient;
import com.yizhi.enroll.application.feign.EnrollFeignClient;
import com.yizhi.enroll.application.vo.ProjectAccountVO;
import com.yizhi.enroll.application.vo.domain.Enroll;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.sign.application.feign.SignRecordApiClient;
import com.yizhi.site.application.feign.PortalManageFeignClients;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.domain.TpAuthorizationRange;
import com.yizhi.training.application.domain.TpPlan;
import com.yizhi.training.application.domain.TpPlanActivity;
import com.yizhi.training.application.domain.TpStudentEnrollPassed;
import com.yizhi.training.application.domain.TpStudentProjectRecord;
import com.yizhi.training.application.domain.TpViewRecord;
import com.yizhi.training.application.domain.TrainingProject;
import com.yizhi.training.application.domain.TrainingProjectDetailsImage;
import com.yizhi.training.application.enums.TrEnrollStatusEnum;
import com.yizhi.training.application.mapper.TpAuthorizationRangeMapper;
import com.yizhi.training.application.mapper.TpClassificationMapper;
import com.yizhi.training.application.mapper.TpPlanActivityConditionPostMapper;
import com.yizhi.training.application.mapper.TpPlanActivityConditionPreMapper;
import com.yizhi.training.application.mapper.TpPlanActivityMapper;
import com.yizhi.training.application.mapper.TpPlanConditionPostMapper;
import com.yizhi.training.application.mapper.TpPlanConditionPreMapper;
import com.yizhi.training.application.mapper.TpPlanMapper;
import com.yizhi.training.application.mapper.TpPlanRemindMapper;
import com.yizhi.training.application.mapper.TpRemindMapper;
import com.yizhi.training.application.mapper.TpStudentActivityRecordMapper;
import com.yizhi.training.application.mapper.TpStudentEnrollPassedMapper;
import com.yizhi.training.application.mapper.TpStudentProjectRecordMapper;
import com.yizhi.training.application.mapper.TpViewRecordMapper;
import com.yizhi.training.application.mapper.TrainingProjectDetailsImageMapper;
import com.yizhi.training.application.mapper.TrainingProjectMapper;
import com.yizhi.training.application.model.BaseModel;
import com.yizhi.training.application.param.PaidTrainingProjectQO;
import com.yizhi.training.application.service.ITpAuthorizationRangeService;
import com.yizhi.training.application.service.ITpClassificationService;
import com.yizhi.training.application.service.ITpPlanActivityService;
import com.yizhi.training.application.service.ITrainingProjectService;
import com.yizhi.training.application.util.DeleteActivityAdvice;
import com.yizhi.training.application.util.TrainingEvenSendMessage;
import com.yizhi.training.application.vo.api.ActivityTypeVo;
import com.yizhi.training.application.vo.api.HotEnrollListVo;
import com.yizhi.training.application.vo.api.HotEnrollParamVo;
import com.yizhi.training.application.vo.api.MyPageVO;
import com.yizhi.training.application.vo.api.PaidTrainingProjectVO;
import com.yizhi.training.application.vo.api.TrainingProjectContentVo;
import com.yizhi.training.application.vo.api.TrainingProjectDetailVo;
import com.yizhi.training.application.vo.api.TrainingProjectDetailsImageVO;
import com.yizhi.training.application.vo.api.TrainingProjectIntroductionVo;
import com.yizhi.training.application.vo.api.TrainingProjectListVo;
import com.yizhi.training.application.vo.api.TrainingProjectMyParamVo;
import com.yizhi.training.application.vo.api.TrainingProjectParamVo;
import com.yizhi.training.application.vo.api.TrainingProjectProgressVo;
import com.yizhi.training.application.vo.api.TrainingProjectVoPortalVo;
import com.yizhi.training.application.vo.domain.TrainingActivityVO;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.training.application.vo.manage.MessageRemindVo;
import com.yizhi.training.application.vo.manage.RelationIdVo;
import com.yizhi.training.application.vo.manage.TpRemindVo;
import com.yizhi.training.application.vo.manage.TrainingProjectStepThreeVo;
import com.yizhi.training.application.vo.manage.VisibleRangeExport;
import com.yizhi.training.application.vo.manage.VisibleRangeVo;
import com.yizhi.util.application.clazz.ClassUtil;
import com.yizhi.util.application.date.DateUtil;

/**
 * <p>
 * 培训项目主体表（报名、签到 是在报名签到表中记录项目id，论坛是单独的关系表） 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Service
@Transactional
public class TrainingProjectServiceImpl extends ServiceImpl<TrainingProjectMapper, TrainingProject> implements ITrainingProjectService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingProjectServiceImpl.class);

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private TrainingProjectMapper trainingProjectMapper;
    @Autowired
    private TpStudentEnrollPassedMapper tpStudentEnrollPassedMapper;
    @Autowired
    private TpPlanMapper tpPlanMapper;
    @Autowired
    private TpPlanActivityMapper tpPlanActivityMapper;
    @Autowired
    private TpStudentActivityRecordMapper tpStudentActivityRecordMapper;
    @Autowired
    private TpAuthorizationRangeMapper tpAuthorizationRangeMapper;
    @Autowired
    private TpRemindMapper tpRemindMapper;
    @Autowired
    private TpStudentProjectRecordMapper tpStudentProjectRecordMapper;
    @Autowired
    private TpPlanConditionPreMapper tpPlanConditionPreMapper;
    @Autowired
    private TpPlanConditionPostMapper tpPlanConditionPostMapper;
    @Autowired
    private TpPlanRemindMapper tpPlanRemindMapper;
    @Autowired
    private TpPlanActivityConditionPreMapper tpPlanActivityConditionPreMapper;
    @Autowired
    private TpPlanActivityConditionPostMapper tpPlanActivityConditionPostMapper;
    @Autowired
    private TpViewRecordMapper tpViewRecordMapper;
    @Autowired
    private ITpAuthorizationRangeService tpAuthorizationRangeService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private SignRecordApiClient signRecordApiClient;
    @Autowired
    private TrainingEvenSendMessage trainingEvenSendMessage;
    @Autowired
    private ITpPlanActivityService tpPlanActivityService;
    @Autowired
    private ITpClassificationService tpClassificationService;
    @Autowired
    private RecordeClient recordeClient;
    @Autowired
    private TpContentStudentStatusServiceUsing tpContentStudentStatusServiceUsing;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private EnrollFeignClient enrollFeignClient;
    @Autowired
    private DeleteActivityAdvice deleteActivityAdvice;

    @Autowired
    private PortalManageFeignClients portalManageFeignClients;

    @Autowired
    ResearchClient researchClient;

    @Autowired
    private TrainingProjectDetailsImageMapper trainingProjectDetailsImageMapper;

    @Autowired
    private TpClassificationMapper tpClassificationMapper;

    /**
     * 业务类型:1活动服务
     */
    private static final Integer PROJECT_BIZ_TYPE = 1;

    @Override
    public Page<TrainingProject> searchPage(String name, Long tpClassificationId,
                                            Integer status, Long companyId, Long siteId, List<Long> orgId, int pageNo, int pageSize) {
        HQueryUtil.startHQ(TrainingProject.class);
        Page<TrainingProject> page = new Page<TrainingProject>(pageNo, pageSize);
        List<TrainingProject> trainingProjects = this.baseMapper.searchPage(name, tpClassificationId, status, companyId, siteId, new RowBounds(page.getOffset(), page.getLimit()));
        page.setRecords(trainingProjects);
        page.setTotal(this.baseMapper.searchPageCount(name, tpClassificationId, status, companyId, siteId));
        return page;
    }

    @Override
    public Page<com.yizhi.training.application.vo.domain.TrainingProjectVo> searchPageV2(String name, Long tpClassificationId,
                                                                                         Integer status, Integer enrollStatus, Long companyId, Long siteId, List<Long> orgId, int pageNo, int pageSize) {
        HQueryUtil.startHQ(TrainingProject.class);
        Page<com.yizhi.training.application.vo.domain.TrainingProjectVo> page = new Page<>(pageNo, pageSize);
        Integer enableEnroll = null;
        Integer enablePay = null;
        if (TrEnrollStatusEnum.NO_ENROLL.getCode().equals(enrollStatus)){
            //无需报名
            enableEnroll = 0;
        }else if (TrEnrollStatusEnum.FREE_ENROLL.getCode().equals(enrollStatus)){
            //免费报名
            enableEnroll = 1;
            enablePay = 0;
        }else if (TrEnrollStatusEnum.PAY_ENROLL.getCode().equals(enrollStatus)){
            //付费报名
            enableEnroll = 1;
            enablePay = 1;
        }

        List<com.yizhi.training.application.vo.domain.TrainingProjectVo> trainingProjects = this.baseMapper.searchPageV2(name, tpClassificationId, status,enableEnroll,enablePay
                , companyId, siteId, page);
        page.setRecords(trainingProjects);
        return page;
    }

    @Override
    public TrainingProject save(TrainingProject trainingProject) {
        trainingProject.setId(idGenerator.generate());
        trainingProjectMapper.insert(trainingProject);

        //保存项目图片
        if (!CollectionUtils.isEmpty(trainingProject.getDetailsImage())) {
            TrainingProjectDetailsImage saveImg = new TrainingProjectDetailsImage();
            int sort = 0;
            for(TrainingProjectDetailsImageVO item : trainingProject.getDetailsImage()){
                item.setId(idGenerator.generate());
                item.setTrainingId(trainingProject.getId());
                item.setCreateById(trainingProject.getCreateById());
                item.setCreateByName(trainingProject.getCreateByName());
                item.setCreateTime(trainingProject.getCreateTime());
                item.setUpdateById(trainingProject.getCreateById());
                item.setUpdateByName(trainingProject.getCreateByName());
                item.setUpdateTime(trainingProject.getCreateTime());
                item.setSort(++sort);
                BeanUtils.copyProperties(item, saveImg);

                trainingProjectDetailsImageMapper.insert(saveImg);
            }
        }

        return trainingProject;
    }

    @Override
    public TrainingProject update(TrainingProject trainingProject) throws Exception {
        TrainingProject old = trainingProjectMapper.selectById(trainingProject.getId());
        if (old.getStatus().equals(ProjectConstant.PROJECT_STATUS_ENABLE)) {
            throw new Exception("只有草稿、下架状态可以被修改");
        }
        trainingProjectMapper.updateById(trainingProject);
        //判断报名开关是否开启；如果关闭；则删除报名配置信息
        Integer enableEnroll = trainingProject.getEnableEnroll();
        Long trainingProjectId = trainingProject.getId();
        if (null != enableEnroll && enableEnroll.equals(0)){
            //报名关闭;查询并删除
            Enroll enroll = enrollFeignClient.selectByProjectId(trainingProjectId);
            if (null != enroll){
                ProjectAccountVO vo = new ProjectAccountVO();
                vo.setProjectId(trainingProjectId);
                Integer result = enrollFeignClient.deleteEnrollByProjectId(vo);
                LOGGER.info("删除项目报名结果;1成功；-1失败: projectId = {} , result = {}",trainingProject,result);
            }
        }

        //保存项目图片
        if (!CollectionUtils.isEmpty(trainingProject.getDetailsImage())) {
            TrainingProjectDetailsImage saveImg = new TrainingProjectDetailsImage();
            Integer sort = trainingProjectDetailsImageMapper.selectMaxSort(trainingProject.getId());
            if(sort==null){
                sort = 1;
            }
            for(TrainingProjectDetailsImageVO item : trainingProject.getDetailsImage()){
                if(item.getId() == null){
                    item.setId(idGenerator.generate());
                    item.setTrainingId(trainingProject.getId());
                    item.setCreateById(trainingProject.getUpdateById());
                    item.setCreateByName(trainingProject.getUpdateByName());
                    item.setCreateTime(trainingProject.getUpdateTime());
                }

                item.setUpdateById(trainingProject.getUpdateById());
                item.setUpdateByName(trainingProject.getUpdateByName());
                item.setUpdateTime(trainingProject.getUpdateTime());
                item.setSort(++sort);
                BeanUtils.copyProperties(item, saveImg);
                saveImg.setTrainingId(trainingProjectId);
                trainingProjectDetailsImageMapper.insert(saveImg);
            }

            //删除不存在的项目图片
            RequestContext context = ContextHolder.get();
            List<TrainingProjectDetailsImageVO> oldImgs = trainingProjectDetailsImageMapper.selectTrainingProjectDetailsImage(trainingProject.getId());
            if (!CollectionUtils.isEmpty(oldImgs)) {
                boolean isDel = true;
                for(TrainingProjectDetailsImageVO oldItem : oldImgs){
                    isDel = true;
                    for(TrainingProjectDetailsImageVO item : trainingProject.getDetailsImage()){
                        if(oldItem.getId().equals(item.getId())){
                            isDel = false;
                            break;
                        }
                    }
                    if(isDel){
                        trainingProjectDetailsImageMapper.deleImg(oldItem.getId(), context.getAccountId(), context.getAccountName());
                    }
                }
            }
        } else {
            //删除不存在的项目图片
            RequestContext context = ContextHolder.get();
            List<TrainingProjectDetailsImageVO> oldImgs = trainingProjectDetailsImageMapper.selectTrainingProjectDetailsImage(trainingProject.getId());
            if (!CollectionUtils.isEmpty(oldImgs)) {
                for(TrainingProjectDetailsImageVO oldItem : oldImgs){
                    trainingProjectDetailsImageMapper.deleImg(oldItem.getId(), context.getAccountId(), context.getAccountName());
                }
            }
        }

        TrainingProject project =  trainingProjectMapper.selectById(trainingProject.getId());
        project.setDetailsImage(trainingProject.getDetailsImage());


        return project;
    }

    @Override
    public Integer saveStepThree(BaseModel<TrainingProjectStepThreeVo> model) throws Exception {
        Long tpId = model.getObj().getTrainingProjectId();
        TrainingProject trainingProject = trainingProjectMapper.selectById(tpId);

        TpPlan tpPlan = new TpPlan();
        tpPlan.setTrainingProjectId(trainingProject.getId());
        tpPlan.setDeleted(0);
        EntityWrapper wrapper = new EntityWrapper(tpPlan);
        List<TpPlan> tpPlans = tpPlanMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(tpPlans)) {
            for (TpPlan plan : tpPlans) {
                if (DateUtils.ceiling(trainingProject.getStartTime(), Calendar.DATE).getTime()
                        > DateUtils.ceiling(plan.getStartTime(), Calendar.DATE).getTime()
                        || DateUtils.ceiling(trainingProject.getEndTime(), Calendar.DATE).getTime()
                        < DateUtils.ceiling(plan.getEndTime(), Calendar.DATE).getTime()) {
                    return 4000;
                }
            }

        }

        if (null == trainingProject) {
            throw new Exception("没有查询到培训项目，查询id：" + model.getObj().getTrainingProjectId());
        }
        RequestContext context = model.getContext();
        TrainingProjectStepThreeVo vo = model.getObj();
        Date now = model.getDate();
        int result = 0;
        TpRemindVo tpRemindVo = vo.getRemindVo();
        if (tpRemindVo != null) {
            //此处不可删
            trainingProject.setEnableRemindApp(vo.getRemindVo().getEnableApp());
        } else {
            LOGGER.info("remindVo为空！！！");
        }

        //填充积分
        trainingProject.setPoint(vo.getPoint());
        trainingProject.setEnableTask(vo.getEnableTask());
        trainingProject.setEnableQueue(vo.getEnableQueue());
        LOGGER.info("trainingProjectId = {},enableQueue={}",trainingProject.getId(),vo.getEnableQueue());
        trainingProject.updateById();

        //这里是为了把计划的可见范围与培训项目的可见范围同步
        if (trainingProject != null) {
            this.trPlanUpdateStatus(tpPlans, trainingProject, context, true);
        }
        try {
            if (trainingProject != null && vo.getMessageRemindVo() != null) {
                //发消息告知提醒有变化
                taskExecutor.asynExecute(new AbstractTaskHandler() {
                    @Override
                    public void handle() {
                        MessageRemindVo mrv=vo.getMessageRemindVo();
                        MessageRemindVo mrvs=new MessageRemindVo();
                        BeanUtils.copyProperties(mrv,mrvs);
                        trainingEvenSendMessage.systemSendMessage(trainingProject, null, mrvs, context);
                    }
                });
            }
        } catch (Exception e) {
            LOGGER.error("项目保存saveStepThree异常: ",e);
        }
        return result;
    }

    /**
     * 计划更新消息那边的业务状态或者可见范围
     *
     * @param tpPlans
     * @param trainingProject
     * @param context
     */
    @Override
    public void trPlanUpdateStatus(List<TpPlan> tpPlans, TrainingProject trainingProject, RequestContext context, Boolean updateVisibleRange) {
        if (!CollectionUtils.isEmpty(tpPlans)) {
            MessageRemindVo messageRemindVo = new MessageRemindVo();
            if (updateVisibleRange) {
                messageRemindVo.setVisibleRangeUpdate(true);
            } else {
                messageRemindVo.setTaskStatusUpdate(true);
            }
            for (TpPlan plan : tpPlans) {
                if (plan.getEnableRemindApp() == 1) {
                    try {
                        taskExecutor.asynExecute(new AbstractTaskHandler() {
                            @Override
                            public void handle() {
                                trainingEvenSendMessage.systemSendMessage(trainingProject, plan.getId(), messageRemindVo, context);
                            }
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
        }
    }

    @Override
    public com.yizhi.training.application.vo.domain.TrainingProjectVo getProjectDescription(Long projectId) {
        com.yizhi.training.application.vo.domain.TrainingProjectVo vo= trainingProjectMapper.getProjectDesc(projectId);
        return vo;
    }

    @Override
    public TrainingProjectStepThreeVo stepThreeView(Long id) {
        TrainingProject tp = trainingProjectMapper.selectById(id);
        if (tp != null) {
            TrainingProjectStepThreeVo vo = new TrainingProjectStepThreeVo();
            vo.setTrainingProjectId(id);
            //填充积分设置
            vo.setPoint(tp.getPoint());
            // 组装提醒

            //回显日历任务设vo置
            vo.setEnableTask(tp.getEnableTask());

            TpRemindVo tpRemindVo = new TpRemindVo();
            tpRemindVo.setAppTemplateId(tp.getAppRemindTemplateId());
//            tpRemindVo.setContent(tp.getRemindContent());
            tpRemindVo.setEnableApp(tp.getEnableRemindApp());
            tpRemindVo.setEnableMail(tp.getEnableRemindMail());
            vo.setRemindVo(tpRemindVo);
            //设置默认不显示‘项目列表显示’参数
            vo.setEnableQueue(0);
            Integer enableEnroll = tp.getEnableEnroll();
            if (null != enableEnroll && enableEnroll.equals(1)){
                Enroll enroll = enrollFeignClient.selectByProjectId(id);
                if (null != enroll){
                    Integer enablePay = enroll.getEnablePay();
                    if (null != enablePay && enablePay.equals(1)){
                        //启动报名配置,才显示项目列表参数
                        vo.setEnableQueue(tp.getEnableQueue());
                    }
                }
            }

            // 组装可见范围
            TpAuthorizationRange range = new TpAuthorizationRange();
            range.setBizId(id);
            range.setDeleted(ProjectConstant.DELETED_NO);
            List<TpAuthorizationRange> ranges = tpAuthorizationRangeMapper.selectList(new EntityWrapper<>(range));
            if (!CollectionUtils.isEmpty(ranges)) {
                VisibleRangeVo rangeVo = new VisibleRangeVo();
                List<RelationIdVo> idVos = new ArrayList<>(ranges.size());
                for (TpAuthorizationRange tpRange : ranges) {
                    RelationIdVo idVo = new RelationIdVo();
                    idVo.setName(tpRange.getName());
                    idVo.setRelationId(tpRange.getRelationId());
                    idVo.setType(tpRange.getType());
                    idVos.add(idVo);
                }
                vo.setVisibleRangeVo(rangeVo);
            }
            return vo;
        }
        return null;
    }

    @Override
    public Integer batchDelete(BaseModel<List<Long>> model) {
        List<Long> ids = model.getObj();
        if (!CollectionUtils.isEmpty(ids)) {
            int num = trainingProjectMapper.batchDelete(ids, model.getContext().getAccountId(), model.getContext().getAccountName(), model.getDate());
            // 再删除培训项目提醒
            tpRemindMapper.batchDeleteByTpIds(ids);
            // 再删除计划
            List<Long> tpPlanIds = tpPlanMapper.getIdsByTpIds(model.getObj());
            if (!CollectionUtils.isEmpty(tpPlanIds)) {
                tpPlanMapper.deleteByIds(tpPlanIds, model.getContext().getAccountId(), model.getContext().getAccountName(), model.getDate());
                // 再删除计划条件
                tpPlanConditionPreMapper.deleteByPlanIds(tpPlanIds);
                tpPlanConditionPostMapper.deleteByPlanIds(tpPlanIds);
                // 再删除计划提醒
                tpPlanRemindMapper.batchDeleteByTpPlanIds(tpPlanIds);
                // 再删除活动
                List<Long> activityIds = tpPlanActivityMapper.getIdsByTpPlanIds(tpPlanIds);
                if (!CollectionUtils.isEmpty(activityIds)) {
                    //删除活动 触发通知需要的业务删除关联关系
                    deleteActivityAdvice.deletedActivityAdvice(ids,model.getContext(),model.getDate());
                    // 再删除活动条件
                    tpPlanActivityConditionPreMapper.deleteByActivityIds(activityIds);
                    tpPlanActivityConditionPostMapper.deleteByActivityIds(activityIds);
                }
            }
            return num;
        }
        return null;
    }

    @Override
    public Page<TrainingProjectListVo> apiPageList(BaseModel<TrainingProjectParamVo> model) throws IOException {
        RequestContext context = model.getContext();
        TrainingProjectParamVo paramVo = model.getObj();
        Integer enablePay = paramVo.getEnablePay();
        if (null != enablePay && enablePay.equals(1)){
            enablePay = 1;
        }else {
            enablePay = 0;
        }
        // 可见范围
        List<Long> relationIds = context.getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(relationIds)) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, context.getSiteId());
        }
        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(context.getAccountId());

        Page<TrainingProjectListVo> page = new Page<>(paramVo.getPageNo(), paramVo.getPageSize());
        List<TrainingProjectListVo> pageList = new ArrayList<>();
        if(paramVo.getNow()!=null) {
            LOGGER.info("查询活动时间{}",DateUtil.toDay(paramVo.getNow()));
        }
        List<com.yizhi.training.application.vo.domain.TrainingProjectVo> list = trainingProjectMapper.apiPageList(visiableTpIds, passEnrollTpIds, paramVo.getNow(), context.getSiteId(), paramVo.getKeyword(),enablePay,
                paramVo.getBizType(),paramVo.getActivityType(),page);
        List<Long> finishedTpIds = tpStudentProjectRecordMapper.getByAccountId(context.getAccountId());

        if (!CollectionUtils.isEmpty(list)) {
        	/*Date date = new Date();
            List<Long> tpIdsForJoinNum = null;
            List<Long> relationIdsForJoinNum = null;*/
            for (com.yizhi.training.application.vo.domain.TrainingProjectVo tr : list) {
                TrainingProjectListVo vo = new TrainingProjectListVo();
                vo.setEndTime(tr.getEndTime());
                vo.setId(tr.getId());
                vo.setLogoImg(tr.getLogoImg());
                vo.setName(tr.getName());
                vo.setStartTime(tr.getStartTime());
                vo.setFinished(finishedTpIds.contains(vo.getId()));
                // 参加人数 浏览人次（同一人只算一次）
                vo.setJoinNumber(getJoinNumberV2(tr));
                //是否付费标签
                vo.setEnablePay(tr.getEnablePay());
                vo.setCanNumber(tr.getCanNumber());
                vo.setCreateTime(tr.getCreateTime());
                vo.setCreatebyName(tr.getCreateByName());
                vo.setActivityName(tr.getActivityCode());

                /**
                 * 设置活动状态：
                 * 1、先根据项目的开始和结束时间设置活动状态
                 */
                TrEnrollStatusEnum state = compareTime(tr.getStartTime(), tr.getEndTime());
                vo.setActivityStateCode(state.getCode());
                vo.setActivityStateName(state.getValue());
                //活动没结束
                if (tr.getBizType().equals(PROJECT_BIZ_TYPE) && state != TrEnrollStatusEnum.ACT_END) {
                    //2、活动要报名和签到
                    if((tr.getEnableEnroll() == 1 && tr.getEnableSign() == 1) || tr.getEnableEnroll() == 1){
                        //判断学员是否报名了该项目
                        if (CollectionUtils.isEmpty(passEnrollTpIds) || !passEnrollTpIds.contains(tr.getId())) {
                            //没有报名：判断活动状态是未报名还是报名，默认待报名
                            vo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_ENROLL.getCode());
                            vo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_ENROLL.getValue());

                          /* 报名时间就报名时间不去管签到时间  //根据报名开始时间和签到开始时间设置报名活动状态
                            Date endTime = tr.getStartTime();
                            if(endTime == null){
                                endTime = tr.getEnrollEndTime();
                            } else {
                                //判断签到开始时间是否和报名的开始时间和结束时间重合，重合取报名结束时间
                                Date s = tr.getEnrollStartTime();
                                Date e = tr.getEnrollEndTime();
                                if((endTime.after(s) || s.equals(endTime)) && (endTime.before(e) || e.equals(endTime))){
                                    endTime = e;
                                }
                            }*/
                            state = compareTime(tr.getEnrollStartTime(), tr.getEnrollEndTime());
                            if(state == TrEnrollStatusEnum.ACT_RUN){
                                vo.setActivityStateCode(TrEnrollStatusEnum.ACT_ENROLL.getCode());
                                vo.setActivityStateName(TrEnrollStatusEnum.ACT_ENROLL.getValue());
                            } else if(state == TrEnrollStatusEnum.ACT_END){
                                vo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_ENROLL.getCode());
                                vo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_ENROLL.getValue());
                            }
                        } else if(tr.getEnableSign() == 1) {
                            //查询签到记录
                            List<Long> passSignTpIds = tpStudentEnrollPassedMapper.selectSignTpIds(context.getAccountId());
                            if (CollectionUtils.isEmpty(passSignTpIds) || !passSignTpIds.contains(tr.getId())) {
                                //没有签到：判断活动状态是签到还是未签到，默认待签到
                                vo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_SIGN.getCode());
                                vo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_SIGN.getValue());

                                //根据签到开始时间和签到结束时间设置活动状态
                                state = compareTime(tr.getSignStartTime(), tr.getSignEndTime());
                                if(state == TrEnrollStatusEnum.ACT_RUN){
                                    vo.setActivityStateCode(TrEnrollStatusEnum.ACT_SIGN.getCode());
                                    vo.setActivityStateName(TrEnrollStatusEnum.ACT_SIGN.getValue());
                                } else if(state == TrEnrollStatusEnum.ACT_END){
                                    vo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_SIGN.getCode());
                                    vo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_SIGN.getValue());
                                }
                            }
                        }
                    } else if(tr.getEnableEnroll() == 0 && tr.getEnableSign() == 1){
                        //3、活动要签到
                        //查询签到记录
                        List<Long> passSignTpIds = tpStudentEnrollPassedMapper.selectSignTpIds(context.getAccountId());
                        if (CollectionUtils.isEmpty(passSignTpIds) || !passSignTpIds.contains(tr.getId())) {
                            //没有签到：判断活动状态是签到还是未签到，默认待签到
                            vo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_SIGN.getCode());
                            vo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_SIGN.getValue());

                            //根据签到开始时间和签到结束时间设置活动状态
                            state = compareTime(tr.getSignStartTime(), tr.getSignEndTime());
                            if(state == TrEnrollStatusEnum.ACT_RUN){
                                vo.setActivityStateCode(TrEnrollStatusEnum.ACT_SIGN.getCode());
                                vo.setActivityStateName(TrEnrollStatusEnum.ACT_SIGN.getValue());
                            } else if(state == TrEnrollStatusEnum.ACT_END){
                                vo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_SIGN.getCode());
                                vo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_SIGN.getValue());
                            }
                        }
                    }
                }

                pageList.add(vo);
            }
        }

        //page.setTotal(trainingProjectMapper.apiPageListCount(visiableTpIds, passEnrollTpIds, paramVo.getNow(), context.getSiteId(), paramVo.getKeyword()));
        page.setRecords(pageList);
        return page;
    }

    @Override
    public Page<HotEnrollListVo> apiHotPageList(BaseModel<HotEnrollParamVo> model) {

        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(model.getContext().getAccountId());
        // 指定范围的可见
        LOGGER.trace("apiHotPageList-RequestContext={}", JSONObject.toJSONString(model.getContext()));
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(model.getContext().getRelationIds())) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(model.getContext().getRelationIds(), model.getContext().getSiteId());
        }
        //前端筛选是否付费条件；付费为1；全部设置为0
        Integer enablePay = model.getObj().getEnablePay();
        if (null != enablePay && enablePay.equals(1)){
            enablePay = 1;
        }else {
            enablePay = 0;
        }
        Page<HotEnrollListVo> page = new Page<>(model.getObj().getPageNo(), model.getObj().getPageSize());
        page.setRecords(trainingProjectMapper.apiHotPageList(model.getContext().getSiteId(), passEnrollTpIds, visiableTpIds, new Date(),enablePay, model.getObj().getBizType(), page));
        //page.setTotal(trainingProjectMapper.apiHotPageListNum(model.getContext().getSiteId(), passEnrollTpIds, visiableTpIds, new Date()));
        return page;
    }

    @Override
    public Page<TrainingProjectListVo> apiMyPageList(BaseModel<TrainingProjectMyParamVo> model) throws Exception {
        Long accountId = model.getContext().getAccountId();
        Long siteId = model.getContext().getSiteId();
        Date now = model.getDate();
        TrainingProjectMyParamVo vo = model.getObj();

        // 可见范围授权id
        List<Long> relationIds = model.getContext().getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = new ArrayList<>();
        if(relationIds!=null){
             visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, siteId);

        }
        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(model.getContext().getAccountId());
        // 已经完成的
        List<Long> finishedIds = tpStudentProjectRecordMapper.getByAccountId(accountId);

        List<TrainingProject> trainingProjects = null;
        List<TrainingProjectListVo> trainingProjectListVos = new ArrayList<>();

        Page<TrainingProjectListVo> page = new Page<>(vo.getPageNo(), vo.getPageSize());
        // 未开始
        // 开始时间大于当前时间 且 可见范围内
        if (vo.getType() == 1) {
            trainingProjects = trainingProjectMapper.selectMyCommingPage(now, siteId, vo.getKeyword(), visiableTpIds, new RowBounds(page.getOffset(), page.getLimit()));

            page.setTotal(trainingProjectMapper.selectMyCommingPageNum(now, siteId, vo.getKeyword(), visiableTpIds));
        }
        // 已开始
        // 开始时间小于当前时间，结束时间大于当前时间
        else if (vo.getType() == 2) {
            trainingProjects = trainingProjectMapper.selectMyJoinedPage(now, siteId, vo.getKeyword(), visiableTpIds, finishedIds, new RowBounds(page.getOffset(), page.getLimit()));
            page.setTotal(trainingProjectMapper.selectMyJoinedPageNum(now, siteId, vo.getKeyword(), visiableTpIds, finishedIds));
        }
        // 已结束
        else if (vo.getType() == 3) {
            trainingProjects = trainingProjectMapper.selectMyFinishedPage(accountId, siteId, visiableTpIds, new RowBounds(page.getOffset(), page.getLimit()));
            page.setTotal(trainingProjectMapper.selectMyFinishedPageNum(accountId, siteId, visiableTpIds));
        }
        // 已过期
        else if (vo.getType() == 4) {
            trainingProjects = trainingProjectMapper.selectMyExpiredPage(siteId, now, visiableTpIds, finishedIds, new RowBounds(page.getOffset(), page.getLimit()));
        } else {
            throw new Exception("未知的列表类型 - " + vo.getType() + "，请检查：列表类型，1：未开始，2：已开始，3：已完成");
        }
        if (!CollectionUtils.isEmpty(trainingProjects)) {
            List<Long> relationIdsForJoinNum = null;
            for (TrainingProject trainingProject : trainingProjects) {
                TrainingProjectListVo v = new TrainingProjectListVo();
                v.setId(trainingProject.getId());
                v.setName(trainingProject.getName());
                v.setLogoImg(trainingProject.getLogoImg());
                v.setStartTime(trainingProject.getStartTime());
                v.setEndTime(trainingProject.getEndTime());
                // 参加人数 浏览人次（同一人只算一次）
                v.setJoinNumber(getJoinNumber(trainingProject));

                //新增项目包含的活动数 除证书外
                Long trainingProjectId = trainingProject.getId();
                TpPlanActivity tpa = new TpPlanActivity();
                tpa.setTrainingProjectId(trainingProjectId);
                tpa.setDeleted(0);//未被删除
                EntityWrapper<TpPlanActivity> wrapper = new EntityWrapper<TpPlanActivity>(tpa);
                wrapper.ne("type",6);
                Integer activitieNum = tpPlanActivityMapper.selectCount(wrapper);
                v.setActivitieNum(activitieNum);

                trainingProjectListVos.add(v);
            }
        }
        page.setRecords(trainingProjectListVos);
        return page;
    }

    @Override
    public Page<TrainingProject> apiPageListNoCondition(BaseModel<Page> model) {
        Page page = model.getObj();
        List<Long> relationIds = model.getContext().getRelationIds();
        Long accountId = model.getContext().getAccountId();
        relationIds.add(accountId);
        List<Long> visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, model.getContext().getSiteId());
        // 防止外部调用未使用构造函数初始化page，到时 offset 和 limit 为空
        page = new Page(page.getCurrent(), page.getSize());
        page.setRecords(trainingProjectMapper.apiPageListNoCondition(visiableTpIds, model.getContext().getSiteId(), model.getDate(), new RowBounds(page.getOffset(), page.getLimit())));
        return page;
    }

    @Override
    public TrainingProjectDetailVo getTpDetail(Long trainingProjectId, RequestContext context, Date now, Boolean containStatistics) throws ParseException {
        Long accountId = context.getAccountId();
        TrainingProject project = trainingProjectMapper.selectById(trainingProjectId);
        if (null != project) {
            TrainingProjectIntroductionVo introductionVo = getTpIntroduction(project, accountId, context.getSiteId());
            TrainingProjectContentVo contentVo = tpContentStudentStatusServiceUsing.getTpContent(project, accountId);
            TrainingProjectDetailVo vo = new TrainingProjectDetailVo();
            vo.setContentVo(contentVo);
            vo.setIntroductionVo(introductionVo);

            //获取详情图片
            List<TrainingProjectDetailsImageVO> detailsImage = trainingProjectMapper.selectTrainingProjectDetailsImage(trainingProjectId);
            introductionVo.setDetailsImage(detailsImage);

            if (containStatistics) {
                TrainingProjectProgressVo progressVo = getProgress(project, accountId, now, context);
                vo.setProgressVo(progressVo);
            }
            addViewRecord(accountId, context, project, now);

            //获取投票ID和名称
            TpPlanActivity tpPlanActivity = new TpPlanActivity();
            tpPlanActivity.setDeleted(0);
            tpPlanActivity.setType(2);
            tpPlanActivity.setTrainingProjectId(trainingProjectId);
            EntityWrapper<TpPlanActivity> wrapper = new EntityWrapper<TpPlanActivity>(tpPlanActivity);
            List<TpPlanActivity> planActivitys = tpPlanActivityMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(planActivitys)){
                introductionVo.setResearchId(planActivitys.get(0).getRelationId());
                introductionVo.setResearchName(planActivitys.get(0).getName());
            }

            /**
             * 设置活动状态： 1、先根据项目的开始和结束时间设置活动状态
             */
            com.yizhi.training.application.vo.domain.TrainingProjectVo tr = trainingProjectMapper.selectTrainingProjectTime(context.getSiteId(), trainingProjectId);
            if(tr == null){
            	return null;
            }
            TrEnrollStatusEnum state = compareTime(tr.getStartTime(), tr.getEndTime());
            introductionVo.setActivityStateCode(state.getCode());
            introductionVo.setActivityStateName(state.getValue());
            //活动结束了返回
            if (state == TrEnrollStatusEnum.ACT_END) {
                return vo;
            }

            // 2、活动要报名和签到
            if (project.getBizType().equals(PROJECT_BIZ_TYPE) && (tr.getEnableEnroll() == 1 && tr.getEnableSign() == 1) || tr.getEnableEnroll() == 1) {

                // 报名通过的
                List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(context.getAccountId());
                LOGGER.info("查询活动{}详情,报名成功id:{},账号:{}",tr.getId(), passEnrollTpIds, context.getAccountId());
                // 判断学员是否报名了该项目
                if (CollectionUtils.isEmpty(passEnrollTpIds) || !passEnrollTpIds.contains(tr.getId())) {
                    // 没有报名：判断活动状态是未报名还是报名，默认待报名
                    introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_ENROLL.getCode());
                    introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_ENROLL.getValue());

                    //根据报名开始时间和签到开始时间设置报名活动状态
                   /* Date endTime = tr.getSignStartTime();
                    if(endTime == null){
                        endTime = tr.getEnrollEndTime();
                    } else {
                        //判断签到开始时间是否和报名的开始时间和结束时间重合，重合取报名结束时间
                        Date s = tr.getEnrollStartTime();
                        Date e = tr.getEnrollEndTime();
                        if((endTime.after(s) || s.equals(endTime)) && (endTime.before(e) || e.equals(endTime))){
                            endTime = e;
                        }
                    }*/
                    state = compareTime(tr.getEnrollStartTime(), tr.getEnrollEndTime());
                    if (state == TrEnrollStatusEnum.ACT_RUN) {
                        introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_ENROLL.getCode());
                        introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_ENROLL.getValue());
                    } else if (state == TrEnrollStatusEnum.ACT_END) {
                        introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_ENROLL.getCode());
                        introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_ENROLL.getValue());
                    }
                } else if(tr.getEnableSign() == 1) {
                    // 查询签到记录
                    List<Long> passSignTpIds = tpStudentEnrollPassedMapper.selectSignTpIds(context.getAccountId());
                    LOGGER.info("查询活动{}详情,查询签到记录:{},账号:{}",tr.getId(), passSignTpIds, context.getAccountId());
                    if (CollectionUtils.isEmpty(passSignTpIds) || !passSignTpIds.contains(tr.getId())) {
                        // 没有签到：判断活动状态是签到还是未签到，默认待签到
                        introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_SIGN.getCode());
                        introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_SIGN.getValue());

                        // 根据签到开始时间和签到结束时间设置活动状态
                        state = compareTime(tr.getSignStartTime(), tr.getSignEndTime());
                        LOGGER.info("查询活动{}详情,判断签到状态:{},账号:{}",tr.getId(), state, context.getAccountId());
                        if (state == TrEnrollStatusEnum.ACT_RUN) {
                            introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_SIGN.getCode());
                            introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_SIGN.getValue());
                        } else if (state == TrEnrollStatusEnum.ACT_END) {
                            introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_SIGN.getCode());
                            introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_SIGN.getValue());
                        }
                    }
                }
            } else if (project.getBizType().equals(PROJECT_BIZ_TYPE) && tr.getEnableEnroll() == 0 && tr.getEnableSign() == 1) {
                // 3、活动要签到
                // 查询签到记录
                List<Long> passSignTpIds = tpStudentEnrollPassedMapper.selectSignTpIds(context.getAccountId());
                if (CollectionUtils.isEmpty(passSignTpIds) || !passSignTpIds.contains(tr.getId())) {
                    // 没有签到：判断活动状态是签到还是未签到，默认待签到
                    introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_WAIT_SIGN.getCode());
                    introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_WAIT_SIGN.getValue());

                    // 根据签到开始时间和签到结束时间设置活动状态
                    state = compareTime(tr.getSignStartTime(), tr.getSignEndTime());
                    if (state == TrEnrollStatusEnum.ACT_RUN) {
                        introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_SIGN.getCode());
                        introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_SIGN.getValue());
                    } else if (state == TrEnrollStatusEnum.ACT_END) {
                        introductionVo.setActivityStateCode(TrEnrollStatusEnum.ACT_NO_SIGN.getCode());
                        introductionVo.setActivityStateName(TrEnrollStatusEnum.ACT_NO_SIGN.getValue());
                    }
                }
            }

            Long signTimeId = tpStudentEnrollPassedMapper.selectSignTimeId(project.getId());
            introductionVo.setSignTimeId(signTimeId);
            introductionVo.setSignType(0);
            LOGGER.info("查询活动{}详情,返回:{}",tr.getId(), JSONUtil.toJsonStr(vo));
            return vo;
        }
        return null;
    }

    @Override
    public Integer getMyTrainingProjectCountNum(BaseModel<TrainingProjectParamVo> model) {

        RequestContext context = model.getContext();
        TrainingProjectParamVo paramVo = model.getObj();
        // 可见范围
        List<Long> relationIds = context.getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(relationIds)) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, context.getSiteId());
        }

        TpStudentProjectRecord record = new TpStudentProjectRecord();
        record.setAccountId(context.getAccountId());
        record.setFinished(1);
        List<TpStudentProjectRecord> records = tpStudentProjectRecordMapper.selectList(new EntityWrapper<>(record));
        List<Long> finishedIds = null;
        if (!CollectionUtils.isEmpty(records)) {
            finishedIds = new ArrayList<>();
            for (TpStudentProjectRecord r : records) {
                finishedIds.add(r.getTrainingProjectId());
            }
        }

        Date date = model.getDate() == null ? new Date() : model.getDate();
        return trainingProjectMapper.getMyTrainingProjectCountNum(date, visiableTpIds, finishedIds, context.getSiteId());
    }

    @Override
    public Integer setVisibleRange(VisibleRangeVo vo, Long accountId, String accountName, Long siteId, Date now) throws Exception {
        if (null == vo.getTrainingProjectId()) {
            throw new Exception("培训项目id不能为空");
        }
        TrainingProject tp = trainingProjectMapper.selectById(vo.getTrainingProjectId());
        if (null == tp) {
            throw new Exception("未查询到培训过项目--id：" + vo.getTrainingProjectId());
        }

        List<RelationIdVo> relationIdVos = vo.getList();
        tp.setUpdateById(accountId);
        tp.setUpdateByName(accountName);
        tp.setUpdateTime(now);

        // 删除以前的
        TpAuthorizationRange oldRange = new TpAuthorizationRange();
        oldRange.setSiteId(siteId);
        oldRange.setBizId(vo.getTrainingProjectId());
        tpAuthorizationRangeMapper.delete(new EntityWrapper<>(oldRange));

        if (CollectionUtils.isEmpty(relationIdVos)) {
            tp.setVisibleRange(ProjectConstant.PROJECT_VISIBLE_RANGE_SITE);
            tp.updateById();
        } else {
            tp.setVisibleRange(ProjectConstant.PROJECT_VISIBLE_RANGE_ACCOUNT);
            if (tp.updateById()) {
                List<TpAuthorizationRange> ranges = new ArrayList<>();

                for (RelationIdVo idVo : relationIdVos) {
                    TpAuthorizationRange range = new TpAuthorizationRange();
                    range.setBizId(vo.getTrainingProjectId());
                    range.setId(idGenerator.generate());
                    range.setRelationId(idVo.getRelationId());
                    range.setType(idVo.getType());
                    range.setName(idVo.getName());
                    ranges.add(range);
                }
                return tpAuthorizationRangeMapper.batchInsert(ranges);
            }
        }
        return null;
    }

    /**
     * 查询培训项目详情
     *
     * @param trainingProject
     * @param accountId
     * @return
     */
    private TrainingProjectIntroductionVo getTpIntroduction(TrainingProject trainingProject, Long accountId, Long siteId) {
        TrainingProjectIntroductionVo vo = null;
        vo = new TrainingProjectIntroductionVo();
        vo.setId(trainingProject.getId());
        vo.setLogoImg(trainingProject.getLogoImg());
        vo.setName(trainingProject.getName());
        vo.setDescription(trainingProject.getDescription());
        vo.setStartTime(trainingProject.getStartTime());
        vo.setEndTime(trainingProject.getEndTime());
        vo.setEnablePosition(trainingProject.getEnableSign().equals(1)?trainingProject.getEnablePosition():0);
        vo.setActivityAddress(trainingProject.getActivityAddress());
        vo.setTips(trainingProject.getTips());
        vo.setOther(trainingProject.getOther());
        vo.setOrganizer(trainingProject.getOrganizer());
        vo.setCoOrganizer(trainingProject.getCoOrganizer());
        vo.setVideoUrl(trainingProject.getVideoUrl());
        Boolean finished = false;
        // 如果需要报名，查看是否已经报名
        if (trainingProject.getEnableEnroll() == 1) {
            vo.setNeedEnroll(true);
            TpStudentEnrollPassed example = new TpStudentEnrollPassed();
            example.setAccountId(accountId);
            example.setTrainingProjectId(trainingProject.getId());
            EntityWrapper wrapper = new EntityWrapper(example);
            // 如果已经报名
            if (!CollectionUtils.isEmpty(tpStudentEnrollPassedMapper.selectList(wrapper))) {
                vo.setHasEnrolled(true);
            }
        }
        // 判断项目是否已经完成
        Integer finishedIdsNum = tpStudentProjectRecordMapper.projectIsFinish(accountId, trainingProject.getId(), siteId);
        if (finishedIdsNum > 0) {
            finished = true;
        }
        vo.setHasFinished(finished);
        //判断是否显示积分数量
        Integer point = trainingProject.getPoint();
        vo.setPoint(point == null ? 0 : point);
        return vo;
    }

    /**
     * 查询学习统计
     *
     * @param project
     * @param accountId
     * @param now
     * @return
     */
    private TrainingProjectProgressVo getProgress(TrainingProject project, Long accountId, Date now, RequestContext context) throws ParseException {
        TrainingProjectProgressVo progressVo = new TrainingProjectProgressVo();
        //*********************************************************统计各类型活动的总数量*******************
        TpPlanActivity activity = new TpPlanActivity();
        activity.setTrainingProjectId(project.getId());
        activity.setDeleted(0);
        activity.setSiteId(context.getSiteId());
        activity.setCompanyId(context.getCompanyId());
        EntityWrapper wrapper = new EntityWrapper(activity);
        List<TpPlanActivity> planActivities = tpPlanActivityMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(planActivities)){
            return progressVo;
        }
        List<Long> courseIds = new ArrayList<>();
        List<Long> activityRelationIds = new ArrayList<>(planActivities.size());
        for (TpPlanActivity a : planActivities) {
            activityRelationIds.add(a.getRelationId());
            switch (a.getType()) {
                case 0:
                    progressVo.setTotalCourse(progressVo.getTotalCourse() + 1);
                    courseIds.add(a.getRelationId());
                    break;
                case 1:
                    progressVo.setTotalExam(progressVo.getTotalExam() + 1);
                    break;
                case 2:
                    progressVo.setTotalResearch(progressVo.getTotalResearch() + 1);
                    break;
                case 4:
                    progressVo.setTotalVote(progressVo.getTotalVote() + 1);
                    break;
                case 5:
                    progressVo.setTotalAssignment(progressVo.getTotalAssignment() + 1);
                    break;
                default:
                    break;
            }
        }
        //查询签到的数量
        try {
            Integer finishedCount = signRecordApiClient.selectCountByTrainingProjectId(project.getId(), accountId);
            progressVo.setTotalSign(null == finishedCount ? 0 : finishedCount);
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("培训统计查询签到数据异常");
        }

        //如果有课程就查询学习时间
        Long seconds = 0L;
        if (!CollectionUtils.isEmpty(courseIds)) {
            try {
                seconds = recordeClient.countStudyDurationByIds(accountId, context.getSiteId(), courseIds);
            } catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("培训统计查询课程学习数据异常");
            }
            seconds = seconds == null ? 0L : seconds;
        }
        progressVo.setTotalStudySeconds(seconds);
        progressVo.setTotalStudyHours(seconds / 3600 + "时" + (seconds % 3600) / 60 + "分" + (seconds % 3600) % 60 + "秒");
        //*****************************************************************************************************
//        if (!CollectionUtils.isEmpty(activityRelationIds)) {
//            TpStudentActivityRecord activityRecord = new TpStudentActivityRecord();
//            activityRecord.setAccountId(accountId);
//            activityRecord.setFinished(1);
//            EntityWrapper<TpStudentActivityRecord> ew = new EntityWrapper<>(activityRecord);
//            ew.in("relation_id", activityRelationIds);
//            List<TpStudentActivityRecord> records = tpStudentActivityRecordMapper.selectList(ew);
//            if (!CollectionUtils.isEmpty(records)) {
//                Map<String, Long> dateCourseTime = new HashMap<>();
//                String today = DateFormatUtils.format(now, "yyyyMMdd");
//                List<TrainingProjectCourseRecentVo> recentVos = new ArrayList<>();
//                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
//                Calendar c = Calendar.getInstance();
//                for (int i = 0; i <= 6; i++) {
//                    TrainingProjectCourseRecentVo recentVo = new TrainingProjectCourseRecentVo();
//                    recentVo.setDate(sdf.parse(today));
//                    recentVo.setSeconds(dateCourseTime.get(today) == null ? 0L : dateCourseTime.get(today));
//                    recentVos.add(recentVo);
//                    // 往前查一天
//                    c.setTime(sdf.parse(today));
//                    c.add(Calendar.DAY_OF_MONTH, -1);
//                    today = DateFormatUtils.format(c.getTime(), "yyyyMMdd");
//                }
//                progressVo.setCourseRecentVos(recentVos);
//            }
//        }
        return progressVo;
    }

    /**
     * 记录一次浏览记录
     *
     * @param accountId
     * @param context
     * @param now
     */
    private void addViewRecord(long accountId, RequestContext context, TrainingProject project, Date now) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                TpViewRecord record = new TpViewRecord();
                record.setAccountId(accountId);
                record.setId(idGenerator.generate());
                record.setTime(now);
                record.setTrainingProjectId(project.getId());
                record.setCompanyId(context.getCompanyId());
                record.setOrgId(context.getOrgId());
                record.setSiteId(context.getSiteId());
                if (project.getVisibleRange()!=1) {
                    List<Long> relationList  = new ArrayList<Long>();
                    List<TpAuthorizationRange> list = tpAuthorizationRangeService.listByBizId(project.getId());
                    list.forEach(e->relationList.add(e.getRelationId()));
                    for(Long relationId:context.getRelationIds()) {
                        if (relationList.contains(relationId)) {
                            tpViewRecordMapper.insert(record);
                            break;
                        }
                    }
                }else {
                    tpViewRecordMapper.insert(record);
                }
            }
        });
    }

    @Override
    public VisibleRangeExport vsibleRangeExport(Long trainingProjectId) {
        VisibleRangeExport visibleRangeExport = new VisibleRangeExport();
        List<Long> accountIds = new ArrayList<Long>();
        List<Long> orgIds = new ArrayList<Long>();

        TrainingProject trainingProject = trainingProjectMapper.selectById(trainingProjectId);
        if (trainingProject != null) {
            visibleRangeExport.setBizId(trainingProject.getId());
            visibleRangeExport.setBizName(trainingProject.getName());
        }

        List<TpAuthorizationRange> listStudent = tpAuthorizationRangeService.listByBizId(trainingProjectId);
        if (listStudent != null && listStudent.size() > 0) {
            TpAuthorizationRange tpAuthorizationRange = null;
            for (int i = 0; i < listStudent.size(); i++) {
                tpAuthorizationRange = listStudent.get(i);
                if (tpAuthorizationRange != null && tpAuthorizationRange.getType() != null) {
                    if (tpAuthorizationRange.getType() == 2) {
                        accountIds.add(tpAuthorizationRange.getRelationId());
                    }
                    if (tpAuthorizationRange.getType() == 1) {
                        orgIds.add(tpAuthorizationRange.getRelationId());
                    }
                }
                visibleRangeExport.setAccountIds(accountIds);
                visibleRangeExport.setOrgIds(orgIds);
            }
        }
        return visibleRangeExport;
    }

    @Override
    public MyPageVO getTrainingCount(BaseModel<TrainingProjectMyParamVo> model) {

        MyPageVO pageVO = new MyPageVO();

        RequestContext context = ContextHolder.get();
        Long siteId = context.getSiteId();
        Long accountId = context.getAccountId();
        Date now = model.getDate();
        TrainingProjectMyParamVo vo = model.getObj();

        // 可见范围授权id
        List<Long> relationIds = model.getContext().getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, siteId);
        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(model.getContext().getAccountId());
        // 已经完成的
        List<Long> finishedIds = tpStudentProjectRecordMapper.getByAccountId(accountId);

        List<TrainingProject> trainingProjects = null;
        List<TrainingProjectListVo> trainingProjectListVos = new ArrayList<>();

        // 未开始
        // 开始时间大于当前时间 且 可见范围内
        Integer unStartCount = trainingProjectMapper.selectMyCommingCount(now, siteId, vo.getKeyword(), visiableTpIds);
        pageVO.setUnStartRecords(unStartCount);
        // 已开始
        // 开始时间小于当前时间，结束时间大于当前时间
        Integer processCount = trainingProjectMapper.selectMyJoinedCount(now, siteId, vo.getKeyword(), visiableTpIds, finishedIds);
        pageVO.setProcessRecords(processCount);
        // 已结束
        Integer finishedCount = trainingProjectMapper.selectMyFinishedCount(accountId, siteId);
        LOGGER.info("已完成的数量是多少：" + finishedCount);
        pageVO.setFinishRecords(finishedCount);

        return pageVO;
    }


    @Override
    public List<TrainingProject> getTrainingList(List<Long> ids) {

        RequestContext context = ContextHolder.get();
        List<Long> relationIds = context.getRelationIds();
        Long accountId = context.getAccountId();
        relationIds.add(accountId);

        List<Long> visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, context.getSiteId());


        List<Long> proIds = ids.parallelStream().map(id -> {
            Integer visibleRange = this.selectById(id).getVisibleRange();
            if (visibleRange == 1) {
                return id;
            } else {
                return null;
            }
        }).collect(Collectors.toList());

        visiableTpIds.addAll(proIds);

        List<TrainingProject> trainingProjectList = new ArrayList<>();

        if (visiableTpIds.size() > 3) {
            trainingProjectList = trainingProjectMapper.getTrainingList(visiableTpIds.subList(0, 4), context.getSiteId(), new Date());
        } else {
            trainingProjectList = trainingProjectMapper.getTrainingList(visiableTpIds, context.getSiteId(), new Date());
        }

        LOGGER.info("返回的培训list：" + trainingProjectList);
        return trainingProjectList;
    }

    @Override
    public List<TrainingProject> getCaseLibraryRangeProjects(RequestContext res) {

        Date date = new Date();


        // 可见范围
        List<Long> relationIds = res.getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(relationIds)) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, res.getSiteId());
        }
        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(res.getAccountId());

        List<TrainingProject> projects = trainingProjectMapper.getCaseLibraryRangeProjects(visiableTpIds, passEnrollTpIds, date, res.getSiteId());

        return projects;
    }


    @Override
    public List<TrainingProjectVoPortalVo> getTrainingListByIds(List<Long> ids) {
        // TODO Auto-generated method stub
        List<TrainingProject> listTrainingProject = this.selectBatchIds(ids);
        List<TrainingProjectVoPortalVo> listTrainingProjectPortalVo = null;
        TrainingProjectVoPortalVo tppv = null;
        if (!CollectionUtils.isEmpty(listTrainingProject)) {
            listTrainingProjectPortalVo = new ArrayList<TrainingProjectVoPortalVo>();
            for (int i = 0; i < listTrainingProject.size(); i++) {
                Long id = listTrainingProject.get(i).getId();
                // 项目启用的状态和未被删除的状态操作 add 2019-10-9 10:50
                if (listTrainingProject.get(i).getStatus() == 1 && listTrainingProject.get(i).getDeleted() == 0) {
                    List<Long> courseIds = tpPlanActivityService.getcourseIdsByTrainingProjectId(id);
                    tppv = new TrainingProjectVoPortalVo();
                    BeanUtils.copyProperties(listTrainingProject.get(i), tppv);
                    tppv.setListCourseIds(courseIds);//copy完bean，把课程的ids也放在目标对象里边
                    if (courseIds != null) {
                        tppv.setActivityNum(courseIds.size());
                    }
                    listTrainingProjectPortalVo.add(tppv);
                }
            }
        }
        return listTrainingProjectPortalVo;
    }


    @Override
    public Page<TrainingProject> listNotIds(List<Long> ids, String name, Long siteId, Integer pageNo, Integer pageSize) {
        // TODO Auto-generated method stub
        Page<TrainingProject> page = new Page<TrainingProject>(pageNo, pageSize);
        TrainingProject tp = new TrainingProject();
        tp.setSiteId(siteId);
        tp.setStatus(1);
        tp.setDeleted(0);
        EntityWrapper<TrainingProject> wrapper = new EntityWrapper<TrainingProject>(tp);
        wrapper.orderBy("create_time", false);
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper.notIn("id", ids);
        }
        if (StringUtils.isNotEmpty(name)) {
            wrapper.like("name", name);
        }
        return this.selectPage(page, wrapper);
    }


    @Override
    public List<TrainingProject> getTrainingListByRelationIds(List<Long> relationIds, Integer num, List<Long> listIds) {
        Long siteId = ContextHolder.get().getSiteId();
        List<TrainingProject> list = trainingProjectMapper.queryTrainingListByRelationIds(relationIds, num, siteId, listIds);
        return list;

    }

    @Override
    public Page<com.yizhi.training.application.vo.domain.TrainingProjectVo> getPageToCalendar(Date date, Page<TrainingProject> page) {
        RequestContext context = ContextHolder.get();
        Page<com.yizhi.training.application.vo.domain.TrainingProjectVo> page1=new Page<>();
        BeanUtils.copyProperties(page,page1);
        List<Long> ids = trainingProjectMapper.getIdsByDate(date, context.getSiteId());
        if (CollectionUtils.isEmpty(ids)) {
            return page1;
        }

        //根据可见范围获取培训ids
        List<Long> trIds = tpAuthorizationRangeMapper.getUsefulIds(ids, context.getRelationIds(), context.getSiteId());
        //获取已完成的培训ids
        List<Long> finishTrIds = tpStudentProjectRecordMapper.getFinshIdsByIds(ids, context.getAccountId(), context.getSiteId());
        List<TrainingProject> list=trainingProjectMapper.getPageToCalendar(finishTrIds, trIds, date, context.getSiteId(), page);
        List<com.yizhi.training.application.vo.domain.TrainingProjectVo> list1=new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)){
            for (TrainingProject tr:list
            ) {
                com.yizhi.training.application.vo.domain.TrainingProjectVo trainingProjectVo=new com.yizhi.training.application.vo.domain.TrainingProjectVo();
                BeanUtils.copyProperties(tr,trainingProjectVo);
                list1.add(trainingProjectVo);
            }
        }

        page1.setRecords(list1);
        page1.setTotal(trainingProjectMapper.getPageToCalendarNum(finishTrIds, trIds, date, context.getSiteId()));
        return page1;
    }

    @Override
    public Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page) {
        if (StringUtils.isBlank(field)) {
            LOGGER.info("列名不能为空！");
            return page;
        }
        if (field.equalsIgnoreCase(TaskParamsEnums.CLASSIFY.getCode())) {
            field = "name";
            page = tpClassificationService.getClassifyNameByDrools(field, value, page);
        } else {
            if (field.equalsIgnoreCase(TaskParamsEnums.NAME.getCode())) {
                return getPage(field, value, page);
            } else if (field.equalsIgnoreCase(TaskParamsEnums.KEYWORD.getCode())) {
                field = "key_words";
                return getPage(field, value, page);
            }
        }
        return page;
    }

    public Page getPage(String field, String value, Page<DroolsVo> page) {
        RequestContext requestContext = ContextHolder.get();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();

        TrainingProject trainingProject = new TrainingProject();
        trainingProject.setSiteId(siteId);
        trainingProject.setCompanyId(companyId);
        trainingProject.setDeleted(0);
        trainingProject.setStatus(1);
        EntityWrapper wrapper = new EntityWrapper(trainingProject);
        wrapper.setSqlSelect("distinct(" + field + ")," + "id ")
                .isNotNull(field)
                .like(field, value)
                .addFilter(field + "!=''")
                .orderBy("create_time", false);

        String upperField = ClassUtil.getFieldName(field);
        List<DroolsVo> voList = null;
        List<TrainingProject> list = this.baseMapper.selectPage(page, wrapper);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            voList = new ArrayList<>(list.size());
            for (TrainingProject a : list) {
                DroolsVo vo = new DroolsVo();
                vo.setTaskId(a.getId());
                vo.setTaskFieldValue(ClassUtil.invokeMethod(a, upperField));
                vo.setTaskParamsType(field);
                voList.add(vo);
            }
            page.setRecords(voList);
        }
        return page;
    }

    /**
     * 获取参与人数
     *
     * @param tr
     * @return
     */
    private Integer getJoinNumber(TrainingProject tr) {
        RequestContext context = ContextHolder.get();
        String key = "tp:page:joinNumber:count:" + context.getCompanyId();
        String item = context.getSiteId() + tr.getId().toString();
        Object obj = redisCache.hget(key, item);
        int count = 0;
        if (obj != null) {
            return Integer.parseInt(String.valueOf(obj));
        }
//        if (tr.getVisibleRange()==1) {
//        	count = tpViewRecordMapper.getViewNum(tr);
//		}else {
//			count = tpViewRecordMapper.getViewNumRange(tr);
//		}
//
//        redisCache.hset(key, item, count + "", 600);
        return count;
    }

    /**
     * 获取参与人数 版本2
     */
    private Integer getJoinNumberV2(com.yizhi.training.application.vo.domain.TrainingProjectVo tr) {
        RequestContext context = ContextHolder.get();
        String key = "tp:page:joinNumber:count:" + context.getCompanyId();
        String item = context.getSiteId() + tr.getId().toString();
        Object obj = redisCache.hget(key, item);
        int count = 0;
        if (obj != null) {
            return Integer.parseInt(String.valueOf(obj));
        }
        return count;
    }

    /**
     * 获取精品内容付费项目
     * @param qo
     * @return
     */
    @Override
    public List<PaidTrainingProjectVO> getPaidTrainingProject(PaidTrainingProjectQO qo) {
        RequestContext context = ContextHolder.get();
        // 可见范围
        List<Long> relationIds = context.getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(relationIds)) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, context.getSiteId());
        }
        List<PaidTrainingProjectVO> list = trainingProjectMapper.apiPaidPageList(visiableTpIds, new Date(),  qo.getSiteId(), qo.getKeyword(), qo.getOrderField(), qo.getOrder());
        return list;
    }

    /**
     * 比较活动的开始时间和结束时间，返回活动状态
     * @param start
     * @param end
     * @return
     */
    private TrEnrollStatusEnum compareTime(Date start, Date end) {
        Date curDate = new Date();
        if(end!=null) {
            if (end.before(curDate)) {
                return TrEnrollStatusEnum.ACT_END;
            }
        }

        if(start!=null) {
            if (start.before(curDate) || start.equals(curDate)) {
                return TrEnrollStatusEnum.ACT_RUN;
            }
        }

        return TrEnrollStatusEnum.ACT_WAIT_START;
    }

    @Override
    public TrainingActivityVO getTrainingActivity(Integer bizType, String startDate, String endDate) {
        RequestContext context = ContextHolder.get();
        TrainingActivityVO item = new TrainingActivityVO();

        //根据活动的可见范围显示日历
        // 可见范围
        List<Long> relationIds = context.getRelationIds();
        // 指定范围的可见
        List<Long> visiableTpIds = null;
        if (!CollectionUtils.isEmpty(relationIds)) {
            visiableTpIds = tpAuthorizationRangeMapper.selectBizIdByRelationId(relationIds, context.getSiteId());
        }
        // 报名通过的
        List<Long> passEnrollTpIds = tpStudentEnrollPassedMapper.selectTpIds(context.getAccountId());
        
        List<TrainingProjectVo> trainingProjectVos = trainingProjectMapper.apiPageListCount(visiableTpIds, passEnrollTpIds, context.getSiteId(), null, bizType);
        if(!CollectionUtils.isEmpty(trainingProjectVos)){
            List<String> list = new ArrayList<String>(1);
            trainingProjectVos.stream().forEach(trainingProjectVo -> {
                if(trainingProjectVo!=null&&trainingProjectVo.getStartTime()!=null&&trainingProjectVo.getEndTime()!=null){
                    List<String> dateList = LegacyDateUtils.getDatesBetween(trainingProjectVo.getStartTime(),trainingProjectVo.getEndTime());
                    dateList.stream().forEach(date->{
                        if(!list.contains(date)){
                            list.add(date);
                        }
                    });
                }

            });
            item.setTheDay(list);

        }

        //获取活动栏
        List<ActivityTypeVo> activityType = trainingProjectMapper.selectActivityType(context.getCompanyId(), context.getSiteId());
        item.setActivityType(activityType);

        return item;
    }

    @Override
    public List<TrainingProjectVo> getTop(Long siteId) {
        return trainingProjectMapper.getTop(siteId);
    }

    @Override
    public Boolean trainingProjectFinished(Long trainingProjectId, Long siteId, Long accountId) {

        TpStudentProjectRecord entity = new TpStudentProjectRecord();
        entity.setId(idGenerator.generate());
        entity.setSiteId(siteId);
        entity.setAccountId(accountId);
        entity.setTrainingProjectId(trainingProjectId);
        entity.setFinishDate(new Date());
        entity.setFinished(1);
        Integer count = tpStudentProjectRecordMapper.insert(entity);

        return count == 0 ? false : true;
    }
}
