package com.yizhi.training.application.service;

import java.util.List;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.training.application.domain.TpStudentProjectRecord;
import com.yizhi.training.application.vo.api.TpStudentProjectRecordVoVO;

/**
 * <p>
 * 培训项目完成情况，由学习计划完成记录计算得出 服务类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-04-09
 */
public interface ITpStudentProjectRecordService extends IService<TpStudentProjectRecord> {






	/**
	 * 实际完成数量
	 * @param accountId
	 * @return
	 */
	Integer getFactNumByAccountId(Long accountId);







	TpStudentProjectRecord getTpStudentProjectRecord(Long accountId,Long projectId);




	/**
	 * 根据培训项目id和完成时间筛选项目完成情况
	 * @param tpId
	 * @param startTime
	 * @param endTime
	 * @return
	 */
	List<TpStudentProjectRecord> getTpStudentProjectRecordByTpIdAndTime(Long tpId,String startTime,String endTime);

	/**
	 * 复旦mini mba项目获取项目完成情况
	 * @param projectIds
	 * @return
	 */
	List<TpStudentProjectRecordVoVO> getProjectsStatus(List<Long> projectIds);

	/**
	 * 复旦mini mba项目获取正在学习人数
	 * @param projectIds
	 * @return
	 */
	Integer getProjectsStudyingNum(List<Long> projectIds);

	/**
	 * 复旦mini mba项目获取学习记录
	 * @param projectIds
	 * @return
	 */
	List<TpStudentProjectRecordVoVO> getProjectsStudyingRecords(List<Long> projectIds);
}
