package com.yizhi.training.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.vo.manage.SearchProjectVo;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/23 22:20
 */
@FeignClient(name = "trainingProject", contextId = "TpProjectClient")
public interface TpProjectClient {

    @GetMapping(value = "/trainingProject/list")
    Page<TrainingProjectVo> list(@RequestBody SearchProjectVo searchProjectVo);

    /**
     * 查询项目列表  版本2
     * 对比版本1 新增筛选条件查询：无需报名；免费报名；收费报名
     * @param searchProjectVo 入参
     */
    @GetMapping(value = "/trainingProject/list/v2")
    Page<TrainingProjectVo> listV2(@RequestBody SearchProjectVo searchProjectVo);

    @PostMapping("/trainingProject/up")
    Integer up(@RequestBody Map<String, Long> map);

    @PostMapping("/trainingProject/down")
    Boolean down(@RequestBody Map<String, Long> map);


    /**
     * 王飞达
     *
     * @param searchProjectVo
     * @return
     */
    @GetMapping(value = "/trainingProject/list/notIds")
    Page<TrainingProjectVo> listNotIds(@RequestBody SearchProjectVo searchProjectVo);


    /**
     * 自定义项目h5接口培训项目验证用户权限
     *
     * @return
     */
    @GetMapping("/trainingProject/getCustomProjectRange")
    Integer getCustomProjectRange(@RequestParam("projectId") Long projectId);

    /**
     * 案例库获取培训项目信息
     *
     * @param idList
     * @return
     * @author ding
     */
    @GetMapping("/trainingProject/getCaseLibraryProject")
    Map<Long, TrainingProjectVo> getCaseLibraryProject(@RequestParam("idList") List<Long> idList);

    /**
     * 我的案例获取可见范围id
     *
     * @param res
     * @return
     */
    @PostMapping("/trainingProject/caseLibrary/getRangeProjects")
    List<TrainingProjectVo> getCaseLibraryRangeProjects(@RequestBody RequestContext res);
}
