package com.yizhi.training.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.yizhi.util.application.sensitive.annotation.SensitiveWords;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 留言管理
 * </p>
 *
 * @author yanglang
 * @since 2025-01-03
 */
@Data
@Api(tags = "LeaveWordVo", description = "留言管理表")
public class LeaveWordVo extends Model<LeaveWordVo> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "标题")
    private String name;

    @SensitiveWords
    @ApiModelProperty(value = "你的问题建议")
    private String content;

    @ApiModelProperty(value = "图片地址，多个以逗号分隔")
    private String ossUrl;

    @ApiModelProperty(value = "接受时间")
    private Date acceptTime;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "组织id")
    private Long groupId;

    @ApiModelProperty(value = "部室名称")
    private String groupName;

    @ApiModelProperty(value = "支部名称")
    private String orgName;

    @ApiModelProperty(value = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "业务类型:1-功能异常、2-体验问题、3-产品建议、4-其他")
    private Integer bizType;
    
    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "图片链接地址")
    private String ossPicUrl;

    @ApiModelProperty(value = "视频链接地址")
    private String ossVideoUrl;
    
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @ApiModelProperty("提交状态1-待接收，2-已接受")
    private Integer state;

    @ApiModelProperty("是否匿名 0 否 1 是")
    private Integer anonymousFlag;
}
