package com.yizhi.training.application.controller;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.cache.distributedlock.impl.RedisDistributedLock;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.domain.TpAuthorizationRange;
import com.yizhi.training.application.domain.TpPlan;
import com.yizhi.training.application.domain.TpPlanActivity;
import com.yizhi.training.application.domain.TrainingProject;
import com.yizhi.training.application.job.Process2PlatTrainingProject;
import com.yizhi.training.application.job.ProcessFinishedRecordCacheJob;
import com.yizhi.training.application.mapper.TpPlanMapper;
import com.yizhi.training.application.mapper.TpViewRecordMapper;
import com.yizhi.training.application.mapper.TrainingProjectDetailsImageMapper;
import com.yizhi.training.application.model.BaseModel;
import com.yizhi.training.application.param.PaidTrainingProjectQO;
import com.yizhi.training.application.param.TrainingProjectParam;
import com.yizhi.training.application.service.*;
import com.yizhi.training.application.util.TrainingEvenSendMessage;
import com.yizhi.training.application.vo.api.*;
import com.yizhi.training.application.vo.domain.TpAuthorizationRangeVo;
import com.yizhi.training.application.vo.domain.TrainingActivityVO;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.training.application.vo.manage.*;
import com.yizhi.util.application.domain.BizResponse;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 培训项目主体表（报名、签到 是在报名签到表中记录项目id，论坛是单独的关系表） 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@RestController
@RequestMapping("/trainingProject")
public class TrainingProjectController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingProjectController.class);

    @Autowired
    private ITrainingProjectService trainingProjectService;
    @Autowired
    private ITpAuthorizationRangeService tpAuthorizationRangeService;
    @Autowired
    private ITpPlanActivityService tpPlanActivityService;
    @Autowired
    private ITrainingProjectPcService trainingProjectPcService;
    @Autowired
    private ProcessFinishedRecordCacheJob processFinishedRecordCacheJob;
    @Autowired
    private Process2PlatTrainingProject process2PlatTrainingProject;
    @Autowired
    private ReportClient reportClient;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ITpPlanService tpPlanService;
    @Autowired
    private TrainingEvenSendMessage trainingEvenSendMessage;
    @Autowired
    private TpPlanMapper tpPlanMapper;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private TpViewRecordMapper tpViewRecordMapper;
    public static String VISIBLE_RANGE_KEY = "tp:visible:rangee";
    @Autowired
    private RedisDistributedLock redisDistributedLock;
    
    @Autowired
    private TrainingProjectDetailsImageMapper trainingProjectDetailsImageMapper;

    @GetMapping(value = "/list")
    public Page<TrainingProject> list(@RequestBody SearchProjectVo searchProjectVo) {
        Page<TrainingProject> page = trainingProjectService
                .searchPage(searchProjectVo.getName(), searchProjectVo.getTpClassificationId(), searchProjectVo.getStatus()
                        , searchProjectVo.getCompanyId(), searchProjectVo.getSiteId(), searchProjectVo.getOrgId(), searchProjectVo.getPageNo(),
                        searchProjectVo.getPageSize());
        return page;
    }

    /**
     * 查询项目列表  版本2
     * 对比版本1 新增筛选条件查询：无需报名；免费报名；收费报名
     * @param searchProjectVo 入参
     */
    @GetMapping(value = "/list/v2")
    public Page<TrainingProjectVo> listV2(@RequestBody SearchProjectVo searchProjectVo) {

        Page<TrainingProjectVo> page = trainingProjectService.searchPageV2(
                searchProjectVo.getName(), searchProjectVo.getTpClassificationId(), searchProjectVo.getStatus(),searchProjectVo.getEnrollStatus()
                , searchProjectVo.getCompanyId(), searchProjectVo.getSiteId(), searchProjectVo.getOrgId(), searchProjectVo.getPageNo(), searchProjectVo.getPageSize());

        return page;
    }

    @PostMapping(value = "/up")
    public Integer up(@RequestBody Map<String, Long> map){
        Long id = map.get("id");
        /*//活动不是必添加项目，注释2025-1-20
        // 检查是否有学习活动
        TpPlanActivity activity = new TpPlanActivity();
        activity.setTrainingProjectId(id);
        activity.setDeleted(
                ProjectConstant.DELETED_NO);
        if (tpPlanActivityService.selectCount(new EntityWrapper<>(activity)) < 1) {
            LOGGER.error("没有添加学习活动，不能上架！");
            return -1;
        }*/
        
        TrainingProject trainingProject = trainingProjectService.selectById(id);
        if (trainingProject.getStatus() == 0 || trainingProject.getStatus() == 2) {
            trainingProject.setStatus(1);
            trainingProject.setReleaseTime(new Date());
            if (trainingProjectService.updateById(trainingProject)) {
                RequestContext context = ContextHolder.get();
                //判断项目开启了提醒功能需要更新消息那边的状态
                TrainingProjectVo trp=new TrainingProjectVo();
                BeanUtils.copyProperties(trainingProject,trp);
                trainingUpdateStatus(trp,context);
                //开启了提醒功能需要更新消息那边计划的状态
                updatePlanMessageStatus(trp, context);
            }
            return 1;
        }
        return 0;
    }

    @PostMapping("/down")
    public Boolean down(@RequestBody Map<String, Long> map) {
        Long id = map.get("id");
        TrainingProject trainingProject = trainingProjectService.selectById(id);
        TrainingProjectVo trp=new TrainingProjectVo();
        BeanUtils.copyProperties(trainingProject,trp);
        if (trainingProject.getStatus() == 1) {
            trainingProject.setStatus(2);
            if (trainingProjectService.updateById(trainingProject)) {
                RequestContext context = ContextHolder.get();
                //开启了提醒功能需要更新消息那边项目的状态
                trainingUpdateStatus(trp, context);
                //开启了提醒功能需要更新消息那边计划的状态
                updatePlanMessageStatus(trp,context);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /**
     * 更新计划消息那边的业务状态
     *
     * @param trainingProject
     * @param context
     */
    public void updatePlanMessageStatus(TrainingProjectVo trainingProject, RequestContext context) {

        TpPlan tpPlan = new TpPlan();
        tpPlan.setTrainingProjectId(trainingProject.getId());
        tpPlan.setDeleted(0);
        EntityWrapper wrapper = new EntityWrapper(tpPlan);
        List<TpPlan> tpPlans = tpPlanMapper.selectList(wrapper);
        if (!CollectionUtils.isEmpty(tpPlans)) {
            TrainingProject trp=new TrainingProject();
            BeanUtils.copyProperties(trainingProject,trp);
            trainingProjectService.trPlanUpdateStatus(tpPlans, trp, context, false);
        }
    }

    /**
     * 发消息告知业务状态改变
     *
     * @param trainingProject
     * @param context
     */
    public void trainingUpdateStatus(TrainingProjectVo trainingProject, RequestContext context) {
        try { //发消息告知业务状态有变化
            if (trainingProject != null) {
                if (trainingProject.getEnableRemindApp() == 1) {
                    MessageRemindVo remindVo = new MessageRemindVo();
                    remindVo.setTaskStatusUpdate(true);
                    taskExecutor.asynExecute(new AbstractTaskHandler() {
                        @Override
                        public void handle() {
                            TrainingProject trp=new TrainingProject();
                            BeanUtils.copyProperties(trainingProject,trp);
                            trainingEvenSendMessage.systemSendMessage(trp, null, remindVo, context);
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 新增培训项目--基本信息
     *
     * @param trainingProject
     * @return
     */
    @PostMapping("/save")
    public TrainingProject save(@RequestBody TrainingProjectVo trainingProject) {
        if (trainingProject==null) {
            return null;
        }
            TrainingProject t = new TrainingProject();
            BeanUtils.copyProperties(trainingProject, t);
            return trainingProjectService.save(t);
    }

    /**
     * 新增培训项目--第三步：可见范围、提醒
     *
     * @param model
     * @return
     */
    @PostMapping("/step/three/save")
    public Integer save(@RequestBody BaseModel<TrainingProjectStepThreeVo> model) throws Exception {
        return trainingProjectService.saveStepThree(model);
    }

    /**
     * 新增培训项目--第三步：可见范围、提醒，查看
     *
     * @param id
     * @return
     */
    @GetMapping("/step/three/view")
    public TrainingProjectStepThreeVo sepThreeView(@RequestParam("id") Long id) {
        return trainingProjectService.stepThreeView(id);
    }

    /**
     * 修改培训项目--基本信息
     *
     * @param trainingProject
     * @return
     * @throws Exception
     */
    @PostMapping("/update")
    public TrainingProject update(@RequestBody TrainingProjectVo trainingProject) throws Exception {
        TrainingProject trainingProject1 = new TrainingProject();
        BeanUtils.copyProperties(trainingProject,trainingProject1);
        return trainingProjectService.update(trainingProject1);
    }

    @PostMapping("/batch/delete")
    public Integer batchDelete(@RequestBody BaseModel<List<Long>> model) {
        return trainingProjectService.batchDelete(model);
    }

    /**
     * 设置可见范围
     *
     * @param model
     * @return
     */
    @PostMapping("/visibleRange/set")
    public Integer setVisibleRange(@RequestBody BaseModel<VisibleRangeVo> model) {
        String[] s = new String[1];
        s[0] = String.valueOf(model.getObj().getTrainingProjectId());
        redisCache.hdel(VISIBLE_RANGE_KEY, s);
        return tpAuthorizationRangeService.batchInsert(model);
    }

    /**
     * 新增可见范围
     *
     * @param model
     * @return
     */
    @PostMapping("/visibleRange/insert")
    public Boolean insertVisibleRange(@RequestBody List<TpAuthorizationRangeVo> tpAuthorizationRanges) {
        List<TpAuthorizationRange> list=new ArrayList<>();
        if (!CollectionUtils.isEmpty(tpAuthorizationRanges)) {
            for (TpAuthorizationRangeVo tr:tpAuthorizationRanges
                 ) {
                TpAuthorizationRange t=new TpAuthorizationRange();
                BeanUtils.copyProperties(tr,t);
                list.add(t);
            }
            String[] s = new String[1];
            s[0] = String.valueOf(tpAuthorizationRanges.get(0).getBizId());
            redisCache.hdel(VISIBLE_RANGE_KEY, s);
        }
        return tpAuthorizationRangeService.insertVisibleRange(list);
    }

    /**
     * 查看可见范围
     *
     * @param trainingProjectId
     * @return
     */
    @GetMapping("/visibleRange/view")
    public List<TpAuthorizationRange> VisibleRange(@RequestParam("trainingProjectId") Long trainingProjectId) {
        String item = String.valueOf(trainingProjectId);
        Object obj = redisCache.hget(VISIBLE_RANGE_KEY, item);
        if (obj != null) {
            String s = (String) obj;
            List<TpAuthorizationRange> list = JSON.parseArray(s, TpAuthorizationRange.class);
            return list;
        }
        TpAuthorizationRange range = new TpAuthorizationRange();
        range.setBizId(trainingProjectId);
        List<TpAuthorizationRange> list = tpAuthorizationRangeService.selectList(new EntityWrapper<>(range));
        String s = JSON.toJSONString(list);
        redisCache.hset(VISIBLE_RANGE_KEY, item, s, 600);
        return list;
    }

    /**
     * 根据参数查询
     *
     * @param param
     * @return
     */
    @GetMapping("/param/list")
    public List<TrainingProject> listByParam(@RequestBody TrainingProjectParam param) {
        TrainingProject example = new TrainingProject();
        example.setOrgId(param.getOrgId());
        example.setCompanyId(param.getCompanyId());
        example.setSiteId(param.getSiteId());
        example.setDeleted(0);
        if (null != param.getStatus()) {
            example.setStatus(param.getStatus().getCode());
        }
        EntityWrapper<TrainingProject> entityWrapper = new EntityWrapper<>(example);
        entityWrapper.like("name", param.getName());
        return trainingProjectService.selectList(entityWrapper);
    }

    // *************************************************************************

    /**
     * 学员端分页列表 -- 培训项目首页
     *
     * @param model
     * @return
     */
    @PostMapping("/api/page/list")
    public Page<TrainingProjectListVo> apiPageList(@RequestBody BaseModel<TrainingProjectParamVo> model) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Page<TrainingProjectListVo> page = trainingProjectService.apiPageList(model);
        List<TrainingProjectListVo> list = page.getRecords();
        for (TrainingProjectListVo vo : list) {
            vo.setStartTimeString(sdf.format(vo.getStartTime()));//时间格式化
            vo.setEndTimeString(sdf.format(vo.getEndTime()));
            Integer activityNum = tpPlanActivityService.getExcCertificateActivityNumByTpId(vo.getId());
            List<Long> courseIds = tpPlanActivityService.getAllCourseIdByTrainingProjectId(vo.getId());
            vo.setListCourseIds(null == courseIds ? new ArrayList<>() : courseIds);
            vo.setActivitieNum((null == activityNum ? 0 : activityNum));

        }
        return page;
    }

    /**
     * 火热报名列表
     *
     * @param model
     * @return
     */
    @GetMapping("/api/hot/page/list")
    public Page<HotEnrollListVo> apiHotPageList(@RequestBody BaseModel<HotEnrollParamVo> model) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Page<HotEnrollListVo> page = trainingProjectService.apiHotPageList(model);
        List<HotEnrollListVo> listVo = page.getRecords();
        if (null != listVo && listVo.size() > 0) {
            for (HotEnrollListVo vo : listVo) {
                vo.setEnrollStartTimeString(sdf.format(vo.getEnrollStartTime()));//对时间格式化
                vo.setEnrollEndTimeString(sdf.format(vo.getEnrollEndTime()));
                Integer activityNum = tpPlanActivityService.getactivityNumByTrainingProjectId(vo.getTrainingProjectId());
                List<Long> courseIds = tpPlanActivityService.getAllCourseIdByTrainingProjectId(vo.getTrainingProjectId());

                vo.setListCourseIds(null == courseIds ? new ArrayList<>() : courseIds);
                vo.setActivitieNum((null == activityNum ? 0 : activityNum));

            }
        }
        return page;
    }

    /**
     * 火热报名列表 v2 版本
     * 修改点： 活动个数（除了证书之外的活动）
     */
    @GetMapping("/api/v2/hot/page/list")
    public Page<HotEnrollListVo> apiHotPageListV2(@RequestBody BaseModel<HotEnrollParamVo> model) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Page<HotEnrollListVo> page = trainingProjectService.apiHotPageList(model);
        List<HotEnrollListVo> listVo = page.getRecords();
        if (null != listVo && listVo.size() > 0) {
            for (HotEnrollListVo vo : listVo) {
                vo.setEnrollStartTimeString(sdf.format(vo.getEnrollStartTime()));//对时间格式化
                vo.setEnrollEndTimeString(sdf.format(vo.getEnrollEndTime()));
                Integer activityNum = tpPlanActivityService.getExcCertificateActivityNumByTpId(vo.getTrainingProjectId());
                List<Long> courseIds = tpPlanActivityService.getAllCourseIdByTrainingProjectId(vo.getTrainingProjectId());

                vo.setListCourseIds(null == courseIds ? new ArrayList<>() : courseIds);
                vo.setActivitieNum((null == activityNum ? 0 : activityNum));
            }
        }
        return page;
    }

    /**
     * 学员端分页列表 -- 培训项目首页
     *
     * @param model
     * @return
     */
    @PostMapping("/api/page/noCondition/list")
    public Page<TrainingProject> apiPageListNoCondition(@RequestBody BaseModel<Page> model) {
        model.setDate(new Date());
        return trainingProjectService.apiPageListNoCondition(model);
    }

    /**
     * 分页列表 -- 我的培训项目
     *
     * @param model
     * @return
     * @throws Exception
     */
    @PostMapping("/api/page/my/list")
    public Page<TrainingProjectListVo> apiMyPageList(@RequestBody BaseModel<TrainingProjectMyParamVo> model) throws Exception {
        return trainingProjectService.apiMyPageList(model);
    }

    /**
     * 获取培训条数
     *
     * @param model
     * @return
     * @throws Exception
     */
    @PostMapping("/api/page/my/list/count")
    public MyPageVO apiMyPageListCount(@RequestBody BaseModel<TrainingProjectMyParamVo> model) throws Exception {
        return trainingProjectService.getTrainingCount(model);
    }


    /**
     * 将以上两个接口合并
     * 查询培训过详情
     *
     * @param model
     * @return
     */
    @PostMapping("/api/detail/get")
    public TrainingProjectDetailVo getTpDetail(@RequestBody BaseModel<Long> model) throws ParseException {
        TrainingProjectDetailVo vo = trainingProjectService.getTpDetail(model.getObj(), model.getContext(), model.getDate(), false);
        if (null != vo.getIntroductionVo().getEnroll()) {
            vo.getIntroductionVo().setEnrollLimit(vo.getIntroductionVo().getEnroll().getLimit());
        }
        return vo;
    }

    /**
     * 我的培训，添加上培训学习统计
     * 查询培训过详情
     *
     * @param model
     * @return
     */
    @PostMapping("/api/detail/progress/get")
    public TrainingProjectDetailVo getTpDetailWithProgress(@RequestBody BaseModel<Long> model) throws ParseException {
        TrainingProjectDetailVo vo = trainingProjectService.getTpDetail(model.getObj(), model.getContext(), model.getDate(), true);
        if (vo != null && null != vo.getIntroductionVo().getEnroll()) {
            vo.getIntroductionVo().setEnrollLimit(vo.getIntroductionVo().getEnroll().getLimit());
        }
        return vo;
    }

    /**
     * 查询一个培训项目实体
     *
     * @param id
     * @return
     */
    @GetMapping("/one/get")
    public TrainingProject getOne(@RequestParam("id") Long id) {
    	TrainingProject trainingProject = trainingProjectService.selectById(id);
    	if(trainingProject != null){
    		List<TrainingProjectDetailsImageVO> detailsImage = trainingProjectDetailsImageMapper.selectTrainingProjectDetailsImage(id);
    		trainingProject.setDetailsImage(detailsImage);
    	}
        return trainingProject;
    }

    /**
     * 获取我的培训项目
     *
     * @return
     */
    @GetMapping("/my/countNum/get")
    public Integer getMyTrainingProjectCountNum(@RequestBody BaseModel<TrainingProjectParamVo> model) throws IOException {
        return trainingProjectService.getMyTrainingProjectCountNum(model);
    }


    @ApiOperation(value = "可见范围导出", notes = "可见范围导出")
    @GetMapping("/export/visiblRange")
    public VisibleRangeExport vsibleRangeExport(@ApiParam(value = "培训项目的Id", name = "培训项目的Id", required = true) @RequestParam(name = "trainingProjectId", required = true) Long trainingProjectId) {
        return trainingProjectService.vsibleRangeExport(trainingProjectId);
    }

    @ApiOperation(value = "培训项目列表", notes = "培训项目列表")
    @GetMapping("/training/list")
    public List<TrainingProjectVoPortalVo> getTrainingListByIds(@RequestParam(name = "ids") List<Long> ids) {
        return trainingProjectService.getTrainingListByIds(ids);
    }


    @GetMapping(value = "/list/notIds")
    public Page<TrainingProject> listNotIds(@RequestBody SearchProjectVo searchProjectVo) {
        return trainingProjectService.listNotIds(searchProjectVo.getListIds(), searchProjectVo.getName(), searchProjectVo.getSiteId(), searchProjectVo.getPageNo(), searchProjectVo.getPageSize());
    }


    //************************************************-----PC端接口----*********************************************************************************************

    /**
     * PC端火热报名列表
     *
     * @param model
     * @return
     */
    @GetMapping("/pc/hot/page/list")
    public Page<HotEnrollListVo> pcHotPageList(@RequestBody BaseModel<HotEnrollParamVo> model) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Page<HotEnrollListVo> page = trainingProjectService.apiHotPageList(model);
        List<HotEnrollListVo> listVo = page.getRecords();
        if (null != listVo && listVo.size() > 0) {
            for (HotEnrollListVo vo : listVo) {
                vo.setEnrollStartTimeString(sdf.format(vo.getEnrollStartTime()));//对时间格式化
                vo.setEnrollEndTimeString(sdf.format(vo.getEnrollEndTime()));
                Integer activityNum = tpPlanActivityService.getactivityNumByTrainingProjectId(vo.getTrainingProjectId());
                List<Long> courseIds = tpPlanActivityService.getAllCourseIdByTrainingProjectId(vo.getTrainingProjectId());

                vo.setListCourseIds(null == courseIds ? new ArrayList<>() : courseIds);
                vo.setActivitieNum((null == activityNum ? 0 : activityNum));

            }
        }
        return page;
    }


    /**
     * PC端分页列表 -- 培训项目首页
     *
     * @param model
     * @return
     */
    @PostMapping("/pc/page/list")
    public Page<TrainingProjectListVo> pcPageList(@RequestBody BaseModel<TrainingProjectParamVo> model) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Page<TrainingProjectListVo> page = trainingProjectService.apiPageList(model);
        List<TrainingProjectListVo> list = page.getRecords();
        for (TrainingProjectListVo vo : list) {
            vo.setStartTimeString(sdf.format(vo.getStartTime()));//时间格式化
            vo.setEndTimeString(sdf.format(vo.getEndTime()));
            Integer activityNum = tpPlanActivityService.getactivityNumByTrainingProjectId(vo.getId());
            List<Long> courseIds = tpPlanActivityService.getAllCourseIdByTrainingProjectId(vo.getId());
            vo.setListCourseIds(null == courseIds ? new ArrayList<>() : courseIds);
            vo.setActivitieNum((null == activityNum ? 0 : activityNum));

        }

        return page;
    }

    /**
     * 查询需要报名培训项目的培训过详情
     *
     * @param model
     * @return
     */
    @PostMapping("/pc/detail/get")
    public TrainingProjectDetailVo getPcTpDetail(@RequestBody BaseModel<Long> model) throws ParseException {
        TrainingProjectDetailVo vo = trainingProjectService.getTpDetail(model.getObj(), model.getContext(), model.getDate(), false);
        if (vo != null) {
            if (null != vo.getIntroductionVo().getEnroll()) {
                vo.getIntroductionVo().setEnrollLimit(vo.getIntroductionVo().getEnroll().getLimit());
            }
        }
        return vo;
    }

    /**
     * 分页列表 -- Pc端我的培训项目
     *
     * @param model
     * @return
     * @throws Exception
     */
    @PostMapping("/pc/page/my/list")
    public Page<TrainingProjectListVo> pcMyPageList(@RequestBody BaseModel<TrainingProjectMyParamVo> model) throws Exception {
        return trainingProjectService.apiMyPageList(model);
    }


    @GetMapping("/pc/train/portal/train/relation")
    public List<TrainingProject> pcTrainingProjectList(
            @RequestParam(name = "relationIds") List<Long> relationIds,
            @RequestParam(name = "num") Integer num,
            @RequestParam(name = "listIds", required = false) List<Long> listIds) {
        return trainingProjectService.getTrainingListByRelationIds(relationIds, num, listIds);
    }


    /**
     * 培训，添加上培训学习记录
     * 查询培训过详情
     *
     * @param model
     * @return
     */
    @PostMapping("/pc/detail/progress/get")
    public TrainingProjectDetailVo getPcTpDetailWithProgress(@RequestBody BaseModel<Long> model) throws ParseException {
        TrainingProjectDetailVo vo = trainingProjectPcService.getPcTpDetail(model.getObj(), model.getContext(), model.getDate());
        if (vo != null) {
            if (null != vo.getIntroductionVo().getEnroll()) {
                vo.getIntroductionVo().setEnrollLimit(vo.getIntroductionVo().getEnroll().getLimit());
            }
        }

        return vo;
    }

    /**
     * 自定义项目h5接口培训项目验证用户权限
     *
     * @return
     * @author ding
     */
    @GetMapping("/getCustomProjectRange")
    Integer getRange(@RequestParam("projectId") Long projectId) {
        RequestContext requestContext = ContextHolder.get();
        Long accountId = requestContext.getAccountId();
        TrainingProject trainingProject = trainingProjectService.selectById(projectId);
        if (null == trainingProject) {
            return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
        }
        if (trainingProject.getVisibleRange() == 1) {
            return ProjectConstant.TP_PLAN_CUSTOMPROJECT_PASS;
        } else {
            List<TpAuthorizationRange> list = this.VisibleRange(projectId);
            List<Long> accountIds = new ArrayList<>();
            List<Long> orgIds = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                for (TpAuthorizationRange tpAuthorizationRange : list) {
                    //1是部门2是用户
                    if (tpAuthorizationRange.getType() == 1) {
                        orgIds.add(tpAuthorizationRange.getRelationId());
                    } else if (tpAuthorizationRange.getType() == 2) {
                        accountIds.add(tpAuthorizationRange.getRelationId());
                    }
                }
            }

            ReportRangeAccountReqVO rrar = new ReportRangeAccountReqVO();
            rrar.setSiteId(requestContext.getSiteId());
            rrar.setAccountIds(accountIds);
            rrar.setOrgIds(orgIds);
            List<ReportAccountRespVO> list1 = reportClient.getRangeAccounts(rrar);
//            if (!CollectionUtils.isEmpty(list1)) {
//                List<ReportAccountRespVO> resultList = list1;
//                if (!CollectionUtils.isEmpty(resultList)) {
//                    for (ReportAccountRespVO reportAccountRespVO : resultList) {
//                        if (reportAccountRespVO.getUserId().equals(accountId)) {
//                            return ProjectConstant.TP_PLAN_CUSTOMPROJECT_PASS;
//                        } else {
//                            continue;
//                        }
//                    }
//                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//                } else {
//                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//                }
//            } else {
//                return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//            }
            //            ReportRangeAccountReqVO rrar = new ReportRangeAccountReqVO();
//            rrar.setIsParentOrg(false);
//            rrar.setSiteId(requestContext.getSiteId());
//            rrar.setAccountIds(accountIds);
//            rrar.setOrgIds(orgIds);
//            List<ReportAccountRespVO> list1 = reportClient.getRangeAccounts(rrar);
//            if (!CollectionUtils.isEmpty(list1)) {
//                List<ReportAccountRespVO> resultList = list1;
//                if (!CollectionUtils.isEmpty(resultList)) {
//                    for (ReportAccountRespVO reportAccountRespVO : resultList) {
//                        if (reportAccountRespVO.getUserId().equals(accountId)) {
//                            return ProjectConstant.TP_PLAN_CUSTOMPROJECT_PASS;
//                        } else {
//                            continue;
//                        }
//                    }
//                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//                } else {
//                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//                }
//            } else {
//                return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
//            }
            if (!CollectionUtils.isEmpty(list1)) {
                List<Long> accountIds1 = list1.stream().map(ReportAccountRespVO::getUserId).collect(Collectors.toList());
                if (accountIds1.contains(accountId)) {
                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_PASS;
                } else {
                    return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
                }
            } else {
                return ProjectConstant.TP_PLAN_CUSTOMPROJECT_FAIL;
            }
        }
    }

    /**
     * 学员端获取用户的列表
     *
     * @param ids
     * @return
     */
    @GetMapping("/api/student/trainingList")
    public List<TrainingProject> getTrainingList(@RequestParam(name = "ids") List<Long> ids) {
        return trainingProjectService.getTrainingList(ids);
    }

    /**
     * 缓存处理
     *
     * @return
     */
    @GetMapping("/cache/init")
    public boolean cacheInit(@RequestParam(name = "subDate", required = false) Date subDate) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                processFinishedRecordCacheJob.processClicked(subDate);
                processFinishedRecordCacheJob.processActivityUnfinished(subDate);
                processFinishedRecordCacheJob.processActivityFinished(subDate);
                processFinishedRecordCacheJob.processPlan(subDate);
                processFinishedRecordCacheJob.processTrainingProject(subDate);
            }
        });
        return true;
    }

    /**
     * 完成记录处理
     *
     * @return
     */
    @GetMapping("/record/cache/init")
    public boolean recordInit(@RequestParam(name = "siteId", required = false) Long siteId) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                process2PlatTrainingProject.startProcess(siteId);
            }
        });
        return true;
    }

    @PostMapping("/list/ids")
    List<TrainingProject> getByIds(@RequestBody Collection<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            TrainingProject trainingProject = new TrainingProject();
            trainingProject.setDeleted(ProjectConstant.DELETED_NO);
            trainingProject.setStatus(ProjectConstant.PROJECT_STATUS_ENABLE);
            EntityWrapper<TrainingProject> ew = new EntityWrapper<>(trainingProject);
            ew.in("id", ids);
            return trainingProjectPcService.selectList(ew);
        }
        return null;
    }

    @GetMapping("/list/siteId")
    List<TrainingProject> getBySiteId(@RequestParam("siteId") Long siteId, @RequestParam(name = "name", required = false) String name) {
        TrainingProject trainingProject = new TrainingProject();
        trainingProject.setDeleted(ProjectConstant.DELETED_NO);
        trainingProject.setStatus(ProjectConstant.PROJECT_STATUS_ENABLE);
        trainingProject.setSiteId(siteId);
        EntityWrapper<TrainingProject> ew = new EntityWrapper<>(trainingProject);
        if (!StringUtils.isEmpty(name)) {
            ew.andNew();
            ew.like("name", name);
            ew.or();
            ew.like("key_words",name);
        }
        List<TrainingProject> tps = trainingProject.selectList(ew);
        return tps;
    }

    @GetMapping("/getCaseLibraryProject")
    Map<Long, TrainingProject> getCaseLibraryProject(@RequestParam("idList") List<Long> idList) {
        return tpPlanService.getCaseLibraryProject(idList);
    }

    /**
     * 我的案例获取可见范围id
     *
     * @param res
     * @return
     */
    @PostMapping("/caseLibrary/getRangeProjects")
    List<TrainingProject> getCaseLibraryRangeProjects(@RequestBody RequestContext res) {
        return trainingProjectService.getCaseLibraryRangeProjects(res);
    }

    @PostMapping("/getPageToCalendar")
    public Page<TrainingProjectVo> getPageToCalendar(@ApiParam("paramVo") @RequestBody CalendarTaskParamVo paramVo) {
        Page<TrainingProject> page = new Page(paramVo.getPageNo(), paramVo.getPageSize());
        return trainingProjectService.getPageToCalendar(paramVo.getDate(), page);
    }

    @GetMapping("/getPageByDrools")
    Page<DroolsVo> getPageByDrools(@RequestParam("field") String field,
                                   @RequestParam(value = "value", required = false) String value,
                                   @RequestParam("pageNo") Integer pageNo,
                                   @RequestParam("pageSize") Integer pageSize) {
        Page<DroolsVo> page = new Page<>(pageNo, pageSize);
        return trainingProjectService.getPageByDrools(field, value, page);
    }
    
    @GetMapping("/getJoinNumber")
    public void getJoinNumber() {
    	String lockName = "getJoinNumber";
    	if (redisDistributedLock.lock(lockName)) {
        	try {
				TrainingProject project = new TrainingProject();
				project.setStatus(1);
				project.setDeleted(0);
				List<TrainingProject> list = trainingProjectService.selectList(new EntityWrapper<TrainingProject>(project));
				int count = 0;
				if (!CollectionUtils.isEmpty(list)) {
					for(TrainingProject tr:list) {
				        String key = "tp:page:joinNumber:count:" + tr.getCompanyId();
				        String item = tr.getSiteId() + tr.getId().toString();
				        if (tr.getVisibleRange()==1) {
				        	count = tpViewRecordMapper.getViewNum(tr);
						}else {
							count = tpViewRecordMapper.getViewNumRange(tr);
						}
				        redisCache.hset(key, item, count + "", 86400);
					}
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				LOGGER.info("更新培训项目已学习人数异常",e);
			} finally {
                redisDistributedLock.releaseLock(lockName);
                LOGGER.info("释放reids锁" + lockName);
			}
		}

    }

    /**
     * 查询一个培训项目详情
     *包括项目和付费详情
     * @param projectId 项目id
     */
    @GetMapping("/description/get")
    public BizResponse<TrainingProjectVo> getProjectDescription(@RequestParam("projectId") Long projectId) {
        TrainingProjectVo projectVo = trainingProjectService.getProjectDescription(projectId);
        return BizResponse.ok(projectVo);
    }


    /**
     * 按条件获取付费课程
     * @param qo
     * @return
     */
    @PostMapping("/paid/get")
    public List<PaidTrainingProjectVO> getPaidTrainingProject(@Valid @RequestBody PaidTrainingProjectQO qo) {
        return trainingProjectService.getPaidTrainingProject(qo);
    }

    /**
     * 查询项目是否上架
     * @param trainingProjectId
     * @return
     */
    @PostMapping("/shelfUp/get")
    public boolean getShelfUp(@RequestParam("id") Long trainingProjectId) {
        EntityWrapper<TrainingProject> ew = new EntityWrapper<>();
        ew.eq("id", trainingProjectId);
        ew.eq("status", 1);
        TrainingProject trainingProject = trainingProjectService.selectOne(ew);
        if (null == trainingProject) {
            return false;
        }
        return true;
    }

    /**
     * 获取有活动的日期
     * @param bizType 业务类型:1活动服务;2培训测试
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/getTrainingActivity")
    public TrainingActivityVO getTrainingActivity(@RequestParam("bizType") Integer bizType, 
    		@RequestParam(name = "startDate", required = false) String startDate, @RequestParam(name = "endDate", required = false) String endDate) {
    	return trainingProjectService.getTrainingActivity(bizType, startDate, endDate);
    }
    
    /**
     * 获取置顶的项目
     * @param id
     * @return
     */
    @GetMapping("/top/get")
    List<TrainingProjectVo> getTop() {
    	RequestContext context = ContextHolder.get();
    	Long siteId = context.getSiteId();
    	List<TrainingProjectVo> list = trainingProjectService.getTop(siteId);
    	return list;
    }
    
    /**
     * 完成培训
     * @param trainingProjectId
     * @return
     */
    @GetMapping("/finished")
    Boolean trainingProjectFinished(@RequestParam("trainingProjectId") Long trainingProjectId, @RequestParam("siteId") Long siteId, @RequestParam("accountId") Long accountId) {
    	return trainingProjectService.trainingProjectFinished(trainingProjectId, siteId, accountId);
    }
}

