package com.yizhi.training.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.training.application.domain.TpComment;
import com.yizhi.training.application.vo.manage.PageCommentVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.session.RowBounds;

import java.util.List;

/**
 * <p>
 * 培训项目 - 评论 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
public interface TpCommentMapper extends BaseMapper<TpComment> {

    /**
     * 培训项目列表分页查询 RowBounds
     * @param trainingProjectId
     * @param bizType 关联业务类型:1活动服务;2新闻资讯；3培训测试；4培训资讯
     * @param rowBounds
     * @return
     */
    List<PageCommentVo> searchPage(@Param("createById") Long createById, @Param("trainingProjectId") Long trainingProjectId, @Param("bizType") Integer bizType, @Param("accountId") Long accountId, RowBounds rowBounds,@Param("type") Integer type);

    Integer searchPageCount(@Param("createById") Long createById,@Param("trainingProjectId") Long trainingProjectId, @Param("bizType") Integer bizType, @Param("accountId") Long accountId,@Param("type") Integer type);

    List<PageCommentVo> getList(@Param("createById") Long createById,@Param("trainingProjectId") Long trainingProjectId, @Param("bizType") Integer bizType, @Param("accountId") Long accountId);
}
