package com.yizhi.training.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.domain.TpCommentThumbsUp;
import com.yizhi.training.application.mapper.TpCommentThumbsUpMapper;
import com.yizhi.training.application.service.ITpCommentThumbsUpService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 评论点赞记录 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Service
public class TpCommentThumbsUpServiceImpl extends ServiceImpl<TpCommentThumbsUpMapper, TpCommentThumbsUp> implements ITpCommentThumbsUpService {

    @Autowired
    TpCommentThumbsUpMapper commentThumbsUpMapper;

    @Override
    public Integer countThumbsUp(Long commenId) {

        return commentThumbsUpMapper.countThumbsUp(commenId);
    }

    @Override
    public Boolean judgeHasThumbsUp(Long commentId) {
        RequestContext context = ContextHolder.get();
        TpCommentThumbsUp thumbsUp = new TpCommentThumbsUp();
        thumbsUp.setAccountId(context.getAccountId());
        thumbsUp.setTpCommentId(commentId);
        EntityWrapper<TpCommentThumbsUp> entityWrapper = new EntityWrapper<>(thumbsUp);

        if (this.baseMapper.selectCount(entityWrapper) > 0) {
            return true;
        } else {
            return false;
        }
    }

}
