package com.yizhi.training.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.training.application.vo.domain.AuthzUserGroupVo;
import com.yizhi.training.application.vo.domain.LeaveWordParamVo;
import com.yizhi.training.application.vo.domain.LeaveWordVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * com.yizhi.training.application.feign
 *
 * @author yanglang
 * @create 2025-01-03 13:38:47
 */
@FeignClient(name = "trainingProject", contextId = "LeaveWordClient")
public interface LeaveWordClient {

    @PostMapping("/manage/leaveWord/page")
    Page<LeaveWordVo> page(@RequestBody LeaveWordParamVo paramVo);

    @PostMapping("/manage/leaveWord/save")
    boolean save(@RequestBody LeaveWordVo leaveWordVo);

    @GetMapping("/manage/leaveWord/getById")
    LeaveWordVo getById(@RequestParam(name = "id")Long id);

    @GetMapping("/manage/leaveWord/updateState")
    boolean updateState(@RequestParam(name = "id")Long id,@RequestParam(name = "state")Integer state);

    @GetMapping("/manage/leaveWord/removeById")
    boolean removeById(@RequestParam(name = "id")Long id);


    @GetMapping("/manage/leaveWord/getAuthzUserGroup")
    public AuthzUserGroupVo getAuthzUserGroup(@RequestParam(name = "userId")Long userId);
}
