package com.yizhi.training.application.job;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.training.application.domain.TpPlanActivityViewRecord;
import com.yizhi.training.application.domain.TpStudentPlanRecord;
import com.yizhi.training.application.domain.TpStudentProjectRecord;
import com.yizhi.training.application.service.ITpStudentActivityRecordService;
import com.yizhi.training.application.service.ITpStudentPlanRecordService;
import com.yizhi.training.application.service.ITpStudentProjectRecordService;
import com.yizhi.training.application.service.TpPlanActivityViewRecordService;
import com.yizhi.training.application.domain.TpStudentActivityRecord;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Description TODO
 * @ClassName ProcessFinishedRecordCacheJob
 * @Author shengchenglong
 * @Date 2019-04-01 21:15
 * @Version 1.0
 **/
@Service
public class ProcessFinishedRecordCacheJob {

    public static final String finished = "1";
    public static final String unFinishe = "0";
    public int pageSize = 20000;

    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessFinishedRecordCacheJob.class);

    @Autowired
    private RedisCache redisCache;
    @Autowired
    private ITpStudentActivityRecordService tpStudentActivityRecordService;
    @Autowired
    private ITpStudentPlanRecordService tpStudentPlanRecordService;
    @Autowired
    private ITpStudentProjectRecordService tpStudentProjectRecordService;
    @Autowired
    private TpPlanActivityViewRecordService tpPlanActivityViewRecordService;

    /**
     * 处理已完成
     *
     * @param subDate
     */
    public void processActivityFinished(Date subDate) {
        processActivity(subDate, true);
    }

    /**
     * 处理未完成
     *
     * @param subDate
     */
    public void processActivityUnfinished(Date subDate) {
        processActivity(subDate, false);
    }

    /**
     * 处理活动 cache
     *
     * @param subDate
     * @param isFinished
     */
    private void processActivity(Date subDate, boolean isFinished) {
        EntityWrapper<TpStudentActivityRecord> ew = new EntityWrapper<>();
        ew.eq("finished", isFinished ? 1 : 0);
        String keyPrefix = isFinished ? CacheNamespace.TP_ACTIVITY_FINISHED : CacheNamespace.TP_ACTIVITY_UNFINISHED;
        if (subDate != null) {
            subDate = DateUtils.truncate(subDate, Calendar.DATE);
            ew.ge("finish_date", subDate);
        }

        List<TpStudentActivityRecord> list = null;
        int current = 0;
        Page<TpStudentActivityRecord> page = new Page<>(current, pageSize, "finish_date");
        // 如果是第一次 或者 当前页数<总共页数
        while (page.getCurrent() <= page.getPages() || current == 0) {
            page.setCurrent(++current);
            page = tpStudentActivityRecordService.selectPage(page, ew);
            list = page.getRecords();
            if (!CollectionUtils.isEmpty(list)) {
                LOGGER.info("----------------开始 处理 {} 活动 cache，截止日期：{}，总页数：{}，当前页：{}--------------", isFinished ? "已完成" : "未通过", subDate, page.getPages(), page.getCurrent());
                list.forEach(item -> {
                    redisCache.hset(keyPrefix.concat(String.valueOf(item.getAccountId())), String.valueOf(item.getRelationId()), finished);
                });
                LOGGER.info("----------------成功 处理 {} 活动 cache，截止日期：{}，总页数：{}，当前页：{}--------------", isFinished ? "已完成" : "未通过", subDate, page.getPages(), page.getCurrent());
            }
        }
    }

    /**
     * 处理计划 cache
     *
     * @param subDate
     */
    public void processPlan(Date subDate) {
        EntityWrapper<TpStudentPlanRecord> ew = new EntityWrapper<>();
        if (subDate != null) {
            subDate = DateUtils.truncate(subDate, Calendar.DATE);
            ew.ge("finish_date", subDate);
        }

        List<TpStudentPlanRecord> list = null;
        int current = 0;
        Page<TpStudentPlanRecord> page = new Page<>(current, pageSize, "finish_date");
        // 如果是第一次 或者 当前页数<总共页数
        while (page.getCurrent() <= page.getPages() || current == 0) {
            page.setCurrent(++current);
            page = tpStudentPlanRecordService.selectPage(page, ew);
            list = page.getRecords();
            if (!CollectionUtils.isEmpty(list)) {
                LOGGER.info("----------------开始 处理 已完成 计划 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
                list.forEach(item -> {
                    redisCache.hset(CacheNamespace.TP_PLAN_FINISHED.concat(String.valueOf(item.getAccountId())), String.valueOf(item.getTpPlanId()), finished);
                });
                LOGGER.info("----------------成功 处理 已完成 计划 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
            }
        }
    }

    /**
     * 处理项目 cache
     */
    public void processTrainingProject(Date subDate) {
        EntityWrapper<TpStudentProjectRecord> ew = new EntityWrapper<>();
        if (subDate != null) {
            subDate = DateUtils.truncate(subDate, Calendar.DATE);
            ew.ge("finish_date", subDate);
        }

        List<TpStudentProjectRecord> list = null;
        int current = 0;
        Page<TpStudentProjectRecord> page = new Page<>(current, pageSize, "finish_date");
        // 如果是第一次 或者 当前页数<总共页数
        while (page.getCurrent() <= page.getPages() || current == 0) {
            page.setCurrent(++current);
            page = tpStudentProjectRecordService.selectPage(page, ew);
            list = page.getRecords();
            if (!CollectionUtils.isEmpty(list)) {
                LOGGER.info("----------------开始 处理 已完成 项目 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
                list.forEach(item -> {
                    redisCache.hset(CacheNamespace.TP_TRAININGPROJECT_FINISHED.concat(String.valueOf(item.getAccountId())), String.valueOf(item.getTrainingProjectId()), finished);
                });
                LOGGER.info("----------------成功 处理 已完成 项目 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
            }
        }
    }

    /**
     * 处理活动点击 cache
     *
     * @param subDate
     */
    public void processClicked(Date subDate) {
        EntityWrapper<TpPlanActivityViewRecord> ew = new EntityWrapper<>();
        if (subDate != null) {
            subDate = DateUtils.truncate(subDate, Calendar.DATE);
            ew.ge("time", subDate);
        }

        List<TpPlanActivityViewRecord> list = null;
        int current = 0;
        Page<TpPlanActivityViewRecord> page = new Page<>(current, pageSize, "time");
        // 如果是第一次 或者 当前页数<总共页数
        while (page.getCurrent() <= page.getPages() || current == 0) {
            page.setCurrent(++current);
            page = tpPlanActivityViewRecordService.selectPage(page, ew);
            list = page.getRecords();
            if (!CollectionUtils.isEmpty(list)) {
                LOGGER.info("----------------开始 处理 已完成 活动点击 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
                list.forEach(item -> {
                    redisCache.hset(CacheNamespace.TP_ACTIVITY_CLICKED.concat(String.valueOf(item.getAccountId())), String.valueOf(item.getTpPlanActivityId()).concat("_").concat(String.valueOf(item.getTrainingProjectId())), finished);
                });
                LOGGER.info("----------------成功 处理 已完成 活动点击 cache，截止日期：{}，总页数：{}，当前页：{}--------------", subDate, page.getPages(), page.getCurrent());
            }
        }
    }

}
