package com.yizhi.training.application.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.training.application.domain.TrainingProjectDetailsImage;
import com.yizhi.training.application.vo.api.TrainingProjectDetailsImageVO;

/**
 * <p>
 * 培训项目 - 详情图片 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
public interface TrainingProjectDetailsImageMapper extends BaseMapper<TrainingProjectDetailsImage> {

	/**
	 * 获取最大Sort
	 * @param trainingId
	 * @return
	 */
	Integer selectMaxSort(@Param("projectId") Long projectId);

	/**
	 * 获取项目关联图片
	 * @param projectId
	 * @return
	 */
	List<TrainingProjectDetailsImageVO> selectTrainingProjectDetailsImage(@Param("projectId") Long projectId);

	/**
	 * 删除项目关联图片
	 * @param id
	 * @param updateById
	 * @param updateByName
	 * @return
	 */
	Integer deleImg(@Param("id") Long id, @Param("updateById") Long updateById, @Param("updateByName") String updateByName);
	
}
