package com.yizhi.training.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.training.application.constant.ProjectConstant;
import com.yizhi.training.application.domain.TpClassification;
import com.yizhi.training.application.domain.TrainingProject;
import com.yizhi.training.application.mapper.TpClassificationMapper;
import com.yizhi.training.application.service.ITpClassificationService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.training.application.service.ITrainingProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 培训项目分类表 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Service
@Transactional
public class TpClassificationServiceImpl extends ServiceImpl<TpClassificationMapper, TpClassification> implements ITpClassificationService {

    @Autowired
    private ITpClassificationService tpClassificationService;
    @Autowired
    private ITrainingProjectService trainingProjectService;

    private Logger logger = LoggerFactory.getLogger(TpClassificationServiceImpl.class);

    @Override
    public Boolean delete(TpClassification param) {

        TpClassification tpClassification = tpClassificationService.selectById(param.getId());

        if (null != tpClassification) {

            tpClassification.setDeleted(ProjectConstant.DELETED_YES);
            if (tpClassification.updateById()) {
                // 查询关联项目
                TrainingProject trainingProject = new TrainingProject();
                trainingProject.setTpClassificationId(param.getId());
                EntityWrapper<TrainingProject> wrapper = new EntityWrapper<>(trainingProject);
                List<TrainingProject> trainingProjects = trainingProjectService.selectList(wrapper);

                if (!CollectionUtils.isEmpty(trainingProjects)) {
                    List<Long> ids = new ArrayList<>();
                    for (TrainingProject t : trainingProjects) {
                        ids.add(t.getId());
                    }

                    EntityWrapper<TrainingProject> ew = new EntityWrapper<>();
                    ew.in("id", ids);
                    TrainingProject tp = new TrainingProject();
                    tp.setTpClassificationId(0L);
                    trainingProjectService.update(tp, ew);
                }
            }
        }

        return Boolean.valueOf(true);
    }

    @Override
    public Page getClassifyNameByDrools(String field, String value, Page page) {
        if (StringUtils.isEmpty(field)) {
            logger.info("列名不能为空！");
            return page;
        }
        RequestContext requestContext = ContextHolder.get();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();
        List<DroolsVo> voList = null;

        TpClassification classify = new TpClassification();
        classify.setSiteId(siteId);
        classify.setCompanyId(companyId);
        classify.setDeleted(0);
        EntityWrapper wrapper = new EntityWrapper(classify);
        wrapper.setSqlSelect("distinct(" + field + "),"+"id ")
                .isNotNull(field)
                .like(field, value)
                .addFilter(field+"!=''")
                .orderBy("create_time", false);

        List<TpClassification> list = this.baseMapper.selectPage(page, wrapper);
        if (!CollectionUtils.isEmpty(list)){
            voList = new ArrayList<>(list.size());
            for (TpClassification a:list){
                DroolsVo vo = new DroolsVo();
                vo.setTaskId(a.getId());
                vo.setTaskFieldValue(a.getName());
                vo.setTaskParamsType(field);
                voList.add(vo);
            }
        }
        page.setRecords(voList);
        return page;
    }
}
