package com.yizhi.training.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.domain.TpStudentProjectRecord;
import com.yizhi.training.application.mapper.TpStudentProjectRecordMapper;
import com.yizhi.training.application.service.ITpStudentProjectRecordService;

import java.util.List;

import com.yizhi.training.application.vo.api.TpStudentProjectRecordVoVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 培训项目完成情况，由学习计划完成记录计算得出 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-04-09
 */
@Service
public class TpStudentProjectRecordServiceImpl extends ServiceImpl<TpStudentProjectRecordMapper, TpStudentProjectRecord> implements ITpStudentProjectRecordService {


    @Autowired
    private TpStudentProjectRecordMapper tpStudentProjectRecordMapper;

    @Override
    public Integer getFactNumByAccountId(Long accountId) {
        // TODO Auto-generated method stub
        TpStudentProjectRecord tpStudentProjectRecord = new TpStudentProjectRecord();
        tpStudentProjectRecord.setAccountId(accountId);
        EntityWrapper<TpStudentProjectRecord> wrapper = new EntityWrapper<TpStudentProjectRecord>(tpStudentProjectRecord);
        return this.selectCount(wrapper);
    }


    @Override
    public TpStudentProjectRecord getTpStudentProjectRecord(Long accountId, Long projectId) {
        // TODO Auto-generated method stub
        TpStudentProjectRecord tpr = new TpStudentProjectRecord();
        tpr.setAccountId(accountId);
        tpr.setTrainingProjectId(projectId);
        EntityWrapper<TpStudentProjectRecord> wrapper = new EntityWrapper<TpStudentProjectRecord>(tpr);
        return this.selectOne(wrapper);
    }


    @Override
    public List<TpStudentProjectRecord> getTpStudentProjectRecordByTpIdAndTime(Long tpId, String startTime,
                                                                               String endTime) {
        // TODO Auto-generated method stub
        return tpStudentProjectRecordMapper.getTpStudentProjectRecordByTpIdAndTime(tpId, startTime, endTime);
    }

    @Override
    public List<TpStudentProjectRecordVoVO> getProjectsStatus(List<Long> projectIds) {

        RequestContext res = ContextHolder.get();

        List<TpStudentProjectRecordVoVO> list = tpStudentProjectRecordMapper.getProjectsStatus(res.getAccountId(), projectIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for (TpStudentProjectRecordVoVO studentProjectRecordVO : list) {
                //未开始
                if (studentProjectRecordVO.getStartTime().getTime() > System.currentTimeMillis()) {
                    studentProjectRecordVO.setState(0);
                }
            }
        }
        return list;
    }

    @Override
    public Integer getProjectsStudyingNum(List<Long> projectIds) {
        RequestContext res = ContextHolder.get();

        return tpStudentProjectRecordMapper.getProjectsStudyingNum(projectIds, res.getCompanyId(), res.getSiteId());
    }

    @Override
    public List<TpStudentProjectRecordVoVO> getProjectsStudyingRecords(List<Long> projectIds) {

        RequestContext res = ContextHolder.get();

        List<TpStudentProjectRecordVoVO> tpStudentProjectRecords = tpStudentProjectRecordMapper.getProjectsStudyingRecords(projectIds, res.getAccountId());

        if (CollectionUtils.isNotEmpty(tpStudentProjectRecords)){
            for (TpStudentProjectRecordVoVO tpStudentProjectRecordVO : tpStudentProjectRecords){
                if (tpStudentProjectRecordVO.getStartTime().getTime() > System.currentTimeMillis()){
                    tpStudentProjectRecordVO.setState(0);
                }
            }
        }
        return tpStudentProjectRecords;
    }

}
