package com.yizhi.training.application.enums;

public enum TrEnrollStatusEnum {
    NO_ENROLL(10,"无需报名"),
    FREE_ENROLL(20,"免费报名"),
    PAY_ENROLL(30,"收费报名"),
    
    /**
     * 活动待开始
     */
    ACT_WAIT_START(0,"待开始"),
    /**
     * 活动待报名
     */
    ACT_WAIT_ENROLL(1,"待报名"),
    /**
     * 活动待签到
     */
    ACT_WAIT_SIGN(2,"待签到"),
    /**
     * 活动报名
     */
    ACT_ENROLL(3,"报名"),
    /**
     * 活动签到
     */
    ACT_SIGN(4,"签到"),
    /**
     * 活动进行中
     */
    ACT_RUN(5,"进行中"),
    /**
     * 活动已结束
     */
    ACT_END(6,"已结束"),
    /**
     * 活动未报名
     */
    ACT_NO_ENROLL(7,"未报名"),
    /**
     * 活动未签到
     */
    ACT_NO_SIGN(8,"未签到")
    ;

    private Integer code;
    private String value;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    TrEnrollStatusEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }
}
