package com.yizhi.training.application.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.training.application.service.LeaveWordService;
import com.yizhi.training.application.vo.domain.AuthzUserGroupVo;
import com.yizhi.training.application.vo.domain.LeaveWordParamVo;
import com.yizhi.training.application.vo.domain.LeaveWordVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * com.yizhi.training.application.controller
 *
 * @author yanglang
 * @create 2025-01-03 13:34:48
 */
@RestController
@RequestMapping("/manage/leaveWord")
public class LeaveWordController {

    @Autowired
    private LeaveWordService leaveWordService;

    @PostMapping("/page")
    public Page<LeaveWordVo> page(@RequestBody LeaveWordParamVo paramVo){
        return leaveWordService.page(paramVo);
    }

    @PostMapping("/save")
    public boolean save(@RequestBody LeaveWordVo leaveWordVo){
        return leaveWordService.save(leaveWordVo);
    }

    @GetMapping("/getById")
    public LeaveWordVo getById(@RequestParam("id") Long id){
        return leaveWordService.getById(id);
    }

    @GetMapping("/getAuthzUserGroup")
    public AuthzUserGroupVo getAuthzUserGroup(@RequestParam(name = "userId")Long userId){
        return leaveWordService.getAuthzUserGroup(userId);
    }
    @GetMapping("/updateState")
    public boolean updateState(@RequestParam("id")Long id,@RequestParam("state")Integer state){
        return leaveWordService.updateState(id,state);
    }

    @GetMapping("/removeById")
    public boolean removeById(@RequestParam("id")Long id){
        return leaveWordService.removeById(id);
    }
}
