package com.yizhi.training.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.training.application.domain.TpPlanActivity;
import com.yizhi.training.application.domain.TpStudentProjectRecord;
import com.yizhi.training.application.domain.TrainingProject;
import com.yizhi.training.application.service.ITpPlanActivityService;
import com.yizhi.training.application.service.ITpStudentProjectRecordService;
import com.yizhi.training.application.service.ITrainingProjectService;
import com.yizhi.training.application.vo.api.TpStudentProjectRecordEbscnVO;
import com.yizhi.training.application.vo.api.UserTrainingProjectStatusVO;
import com.yizhi.training.application.vo.domain.TpStudentProjectRecordVo;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 外部系统光大证券的相关接口
 */
@RestController
@RequestMapping("/outside/ebscn")
public class OutsideEbscnController {

    @Autowired
    ITrainingProjectService trainingProjectService;

    @Autowired
    ITpStudentProjectRecordService tpStudentProjectRecordService;

    @Autowired
    ITpPlanActivityService tpPlanActivityService;

    public static final Logger LOGGER = LoggerFactory.getLogger(OutsideEbscnController.class);

    /**
     * 根据培训项目名称获取指定用户的完成状态
     */
    @PostMapping("/users/study/status")
    public TpStudentProjectRecordEbscnVO geUserTrainingProjectStatus(@RequestBody UserTrainingProjectStatusVO vo){
        String tpName = vo.getTrainingProjectName();
        Long siteId = vo.getSiteId();
        List<Long> userIds = vo.getUserIds();

        TpStudentProjectRecordEbscnVO vo1 = null;

        EntityWrapper<TrainingProject> ew = QueryUtil.condition(new TrainingProject());
        ew.eq("site_id", siteId).eq("name",tpName);
        TrainingProject trainingProject = trainingProjectService.selectOne(ew);
        TrainingProjectVo t=new TrainingProjectVo();

        if(trainingProject != null){
            BeanUtils.copyProperties(trainingProject,t);
            EntityWrapper<TpStudentProjectRecord> ewTpSPR = QueryUtil.condition(new TpStudentProjectRecord());
            ewTpSPR.eq("site_id", siteId).eq("training_project_id",trainingProject.getId()).in("account_id",userIds);
            List<TpStudentProjectRecord> gData = tpStudentProjectRecordService.selectList(ewTpSPR);
            List<TpStudentProjectRecordVo> gDateV=new ArrayList<>();
            for (TpStudentProjectRecord tps:gData
                 ) {
                TpStudentProjectRecordVo tpS=new TpStudentProjectRecordVo();
                BeanUtils.copyProperties(tps,tpS);
                gDateV.add(tpS);
            }
            if(!CollectionUtils.isEmpty(gData)){
                vo1 = new TpStudentProjectRecordEbscnVO();
                vo1.setTrainingProject(t);
                vo1.setData(gDateV);
                EntityWrapper<TpPlanActivity> ewTpa = QueryUtil.condition(new TpPlanActivity());
                ewTpa.eq("training_project_id", trainingProject.getId())
                        .eq("deleted",0).eq("type",0);
                List<TpPlanActivity> tpaList = tpPlanActivityService.selectList(ewTpa);
                // 获取项目关联的课程数
                List<Long> courseIds = tpaList.parallelStream().map(courseId->courseId.getRelationId()).collect(Collectors.toList());
                vo1.setCourseIds(courseIds);
            }

        }
        return vo1;
    }
}
